/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.kernel.api.security.Segment;

public class LoadSegment
implements Segment {
    private final String cidr;
    private final String url;
    public static final LoadSegment ALL = new LoadSegment(null, null);
    public static final String CIDR = "CIDR";
    public static final String URL = "URL";
    public static final String ALL_DATA = "ALL DATA";

    private LoadSegment(String cidr, String url) {
        this.cidr = cidr;
        this.url = url;
    }

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof LoadSegment) {
            LoadSegment other = (LoadSegment)segment;
            return !(this.cidr != null && !this.cidr.equals(other.cidr) || this.url != null && !this.url.equals(other.url));
        }
        return false;
    }

    @Override
    public String toCypherSnippet() {
        if (this.isAllData()) {
            return ALL_DATA;
        }
        if (this.isUrl()) {
            return String.format("%s \"%s\"", URL, this.getUrl());
        }
        return String.format("%s \"%s\"", CIDR, this.getCidr());
    }

    public String toString() {
        if (this.cidr == null && this.url == null) {
            return ALL_DATA;
        }
        if (this.cidr == null) {
            return String.format("URL('%s')", this.url);
        }
        return String.format("CIDR('%s')", this.cidr);
    }

    public static LoadSegment CIDR(String cidr) {
        return new LoadSegment(cidr, null);
    }

    public static LoadSegment URL(String url) {
        return new LoadSegment(null, url);
    }

    public static LoadSegment fromValueString(String value) {
        if (value.equals(ALL_DATA)) {
            return ALL;
        }
        if (value.startsWith(CIDR)) {
            String[] splitValue = value.split("'");
            return LoadSegment.CIDR(splitValue[1]);
        }
        String[] splitValue = value.split("'");
        return LoadSegment.URL(splitValue[1]);
    }

    public boolean isCidr() {
        return this.cidr != null;
    }

    public boolean isUrl() {
        return this.url != null;
    }

    public boolean isAllData() {
        return !this.isCidr() && !this.isUrl();
    }

    public String getCidr() {
        return this.cidr;
    }

    public String getUrl() {
        return this.url;
    }
}

