/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.impl.fulltext;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.neo4j.common.EntityType;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.impl.fulltext.LuceneFulltextDocumentStructure;
import org.neo4j.kernel.api.impl.fulltext.TransactionStateLuceneIndexWriter;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.Value;

class FulltextIndexTransactionStateVisitor
extends TxStateVisitor.Adapter {
    private final String[] propertyNames;
    private final SchemaDescriptor schema;
    private final boolean visitingNodes;
    private final int[] entityTokenIds;
    private final Value[] propertyValues;
    private final IntIntHashMap propKeyToIndex;
    private final MutableLongSet modifiedEntityIdsInThisTransaction;
    private final TransactionStateLuceneIndexWriter writer;
    private final PropertySelection indexedPropertySelection;
    private Read read;
    private NodeCursor nodeCursor;
    private PropertyCursor propertyCursor;
    private RelationshipScanCursor relationshipCursor;

    FulltextIndexTransactionStateVisitor(IndexDescriptor descriptor, String[] propertyNames, MutableLongSet modifiedEntityIdsInThisTransaction, TransactionStateLuceneIndexWriter writer) {
        this.propertyNames = propertyNames;
        this.schema = descriptor.schema();
        this.modifiedEntityIdsInThisTransaction = modifiedEntityIdsInThisTransaction;
        this.writer = writer;
        this.visitingNodes = this.schema.entityType() == EntityType.NODE;
        this.entityTokenIds = this.schema.getEntityTokenIds();
        int[] propertyIds = this.schema.getPropertyIds();
        this.propertyValues = new Value[propertyIds.length];
        this.propKeyToIndex = new IntIntHashMap();
        for (int i = 0; i < propertyIds.length; ++i) {
            this.propKeyToIndex.put(propertyIds[i], i);
        }
        this.indexedPropertySelection = PropertySelection.selection((int[])propertyIds);
    }

    FulltextIndexTransactionStateVisitor init(Read read, NodeCursor nodeCursor, RelationshipScanCursor relationshipCursor, PropertyCursor propertyCursor) {
        this.read = read;
        this.nodeCursor = nodeCursor;
        this.relationshipCursor = relationshipCursor;
        this.propertyCursor = propertyCursor;
        return this;
    }

    public void visitCreatedNode(long id) {
        this.indexNode(id);
    }

    public void visitNodePropertyChanges(long id, Iterable<StorageProperty> added, Iterable<StorageProperty> changed, IntIterable removed) {
        this.indexNode(id);
    }

    public void visitDeletedNode(long id) {
        this.modifiedEntityIdsInThisTransaction.add(id);
    }

    public void visitRelationshipModifications(RelationshipModifications modifications) {
        modifications.creations().forEach((id, type, start, end, addedProps, changedProps, removedProps) -> this.indexRelationship(id));
        modifications.deletions().forEach((id, type, start, end, addedProps, changedProps, noDeletedProps) -> this.modifiedEntityIdsInThisTransaction.add(id));
        modifications.updates().forEach((id, type, start, end, addedProps, changedProps, removedProps) -> this.indexRelationship(id));
    }

    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) {
        this.indexNode(id);
        if (this.visitingNodes) {
            for (int entityTokenId : this.entityTokenIds) {
                if (!removed.contains((long)entityTokenId)) continue;
                this.modifiedEntityIdsInThisTransaction.add(id);
                break;
            }
        }
    }

    private void indexNode(long id) {
        if (this.visitingNodes) {
            TokenSet labels;
            this.read.singleNode(id, this.nodeCursor);
            if (this.nodeCursor.next() && this.schema.isAffected((labels = this.nodeCursor.labels()).all())) {
                this.nodeCursor.properties(this.propertyCursor, this.indexedPropertySelection);
                this.indexProperties(id);
            }
        }
    }

    private void indexRelationship(long id) {
        if (!this.visitingNodes) {
            this.read.singleRelationship(id, this.relationshipCursor);
            if (this.relationshipCursor.next() && this.schema.isAffected(new int[]{this.relationshipCursor.type()})) {
                this.relationshipCursor.properties(this.propertyCursor, this.indexedPropertySelection);
                this.indexProperties(id);
            }
        }
    }

    private void indexProperties(long id) {
        while (this.propertyCursor.next()) {
            int propertyKey = this.propertyCursor.propertyKey();
            int index = this.propKeyToIndex.get(propertyKey);
            this.propertyValues[index] = this.propertyCursor.propertyValue();
        }
        if (this.modifiedEntityIdsInThisTransaction.add(id)) {
            try {
                this.writer.nullableAddDocument(LuceneFulltextDocumentStructure.documentRepresentingProperties(id, this.propertyNames, this.propertyValues));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        Arrays.fill(this.propertyValues, null);
    }
}

