/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.connectioninfo.RoutingInfo;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionExceptionMapper;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseTransactions;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class ProcedureGraphDatabaseAPI
extends GraphDatabaseTransactions
implements GraphDatabaseAPI {
    private final GraphDatabaseAPI delegate;
    private final Function<LoginContext, LoginContext> loginContextTransformer;

    public ProcedureGraphDatabaseAPI(GraphDatabaseAPI delegate, Function<LoginContext, LoginContext> loginContextTransformer, Config config) {
        super(config);
        this.delegate = Objects.requireNonNull(delegate);
        this.loginContextTransformer = Objects.requireNonNull(loginContextTransformer);
    }

    public boolean isAvailable() {
        return this.delegate.isAvailable();
    }

    public boolean isAvailable(long timeoutMillis) {
        return this.delegate.isAvailable(timeoutMillis);
    }

    public String databaseName() {
        return this.delegate.databaseName();
    }

    public DependencyResolver getDependencyResolver() {
        return this.delegate.getDependencyResolver();
    }

    public DatabaseLayout databaseLayout() {
        return this.delegate.databaseLayout();
    }

    public NamedDatabaseId databaseId() {
        return this.delegate.databaseId();
    }

    public DbmsInfo dbmsInfo() {
        return this.delegate.dbmsInfo();
    }

    public TopologyGraphDbmsModel.HostedOnMode mode() {
        return this.delegate.mode();
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, long timeout, TimeUnit unit) {
        return this.delegate.beginTransaction(type, this.loginContextTransformer.apply(loginContext), clientInfo, timeout, unit);
    }

    public InternalTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo clientInfo, RoutingInfo routingInfo, long timeout, TimeUnit unit, Consumer<Status> terminationCallback, TransactionExceptionMapper transactionExceptionMapper) {
        return this.beginTransaction(type, loginContext, clientInfo, timeout, unit);
    }
}

