/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.graphschema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.procedure.builtin.graphschema.GraphSchema;
import org.neo4j.procedure.builtin.graphschema.GraphSchemaModule;

public final class GraphSchemaGraphyResultWrapper {
    public final List<Node> nodes = new ArrayList<Node>();
    public final List<Relationship> relationships = new ArrayList<Relationship>();

    public static GraphSchemaGraphyResultWrapper flat(GraphSchema graphSchema) {
        Map<String, String> nodeLabels = graphSchema.nodeLabels().values().stream().collect(Collectors.toMap(GraphSchema.Token::id, GraphSchema.Token::value));
        Map<String, String> relationshipTypes = graphSchema.relationshipTypes().values().stream().collect(Collectors.toMap(GraphSchema.Token::id, GraphSchema.Token::value));
        GraphSchemaGraphyResultWrapper result = new GraphSchemaGraphyResultWrapper();
        HashMap<GraphSchema.Ref, VirtualNode> nodeObjectTypeNodes = new HashMap<GraphSchema.Ref, VirtualNode>();
        for (GraphSchema.NodeObjectType nodeObjectType : graphSchema.nodeObjectTypes().values()) {
            String[] labels = (String[])nodeObjectType.labels().stream().map(v -> (String)nodeLabels.get(v.value())).toArray(String[]::new);
            VirtualNode node = new VirtualNode(Map.of("$id", nodeObjectType.id(), "name", labels.length == 0 ? "n/a" : labels[0], "properties", GraphSchemaModule.asJsonString(nodeObjectType.properties())), labels);
            nodeObjectTypeNodes.put(new GraphSchema.Ref(nodeObjectType.id()), node);
        }
        result.nodes.addAll(nodeObjectTypeNodes.values());
        for (GraphSchema.RelationshipObjectType relationshipObjectType : graphSchema.relationshipObjectTypes().values()) {
            VirtualRelationship relationship = new VirtualRelationship((Node)nodeObjectTypeNodes.get(relationshipObjectType.from()), relationshipTypes.get(relationshipObjectType.type().value()), Map.of("$id", relationshipObjectType.id(), "properties", GraphSchemaModule.asJsonString(relationshipObjectType.properties())), (Node)nodeObjectTypeNodes.get(relationshipObjectType.to()));
            result.relationships.add(relationship);
        }
        return result;
    }

    public static GraphSchemaGraphyResultWrapper full(GraphSchema graphSchema) {
        Map<String, Node> nodeLabelNodes = graphSchema.nodeLabels().values().stream().collect(Collectors.toMap(GraphSchema.Token::id, t -> GraphSchemaGraphyResultWrapper.toVirtualNode(t, "NodeLabel")));
        Map<String, Node> relationshipTypeNodes = graphSchema.relationshipTypes().values().stream().collect(Collectors.toMap(GraphSchema.Token::id, t -> GraphSchemaGraphyResultWrapper.toVirtualNode(t, "RelationshipType")));
        GraphSchemaGraphyResultWrapper result = new GraphSchemaGraphyResultWrapper();
        HashMap<GraphSchema.Ref, VirtualNode> nodeObjectTypeNodes = new HashMap<GraphSchema.Ref, VirtualNode>();
        for (Map.Entry<GraphSchema.Ref, GraphSchema.NodeObjectType> entry : graphSchema.nodeObjectTypes().entrySet()) {
            GraphSchema.NodeObjectType nodeObjectType = entry.getValue();
            VirtualNode node = new VirtualNode(Map.of("$id", nodeObjectType.id(), "properties", GraphSchemaModule.asJsonString(nodeObjectType.properties())), "NodeObjectType");
            nodeObjectTypeNodes.put(entry.getKey(), node);
            for (GraphSchema.Ref ref : nodeObjectType.labels()) {
                Node tokenNode = nodeLabelNodes.get(ref.value());
                result.relationships.add(new VirtualRelationship(node, "HAS_LABEL", tokenNode));
            }
        }
        for (GraphSchema.RelationshipObjectType relationshipObjectType : graphSchema.relationshipObjectTypes().values()) {
            VirtualNode node = new VirtualNode(Map.of("$id", relationshipObjectType.id(), "properties", GraphSchemaModule.asJsonString(relationshipObjectType.properties())), "RelationshipObjectTypes");
            result.nodes.add(node);
            result.relationships.add(new VirtualRelationship(node, "HAS_TYPE", relationshipTypeNodes.get(relationshipObjectType.type().value())));
            result.relationships.add(new VirtualRelationship(node, "FROM", (Node)nodeObjectTypeNodes.get(relationshipObjectType.from())));
            result.relationships.add(new VirtualRelationship(node, "TO", (Node)nodeObjectTypeNodes.get(relationshipObjectType.to())));
        }
        result.nodes.addAll(nodeLabelNodes.values());
        result.nodes.addAll(relationshipTypeNodes.values());
        result.nodes.addAll(nodeObjectTypeNodes.values());
        return result;
    }

    private static Node toVirtualNode(GraphSchema.Token token, String label) {
        return new VirtualNode(Map.of("$id", token.id(), "value", token.value()), "Token", label);
    }

    static final class VirtualNode
    extends VirtualEntity
    implements Node {
        private final Set<Label> labels;

        VirtualNode(Map<String, Object> properties, String ... labels) {
            super(properties);
            this.labels = Arrays.stream(labels).map(Label::label).collect(Collectors.collectingAndThen(Collectors.toSet(), Set::copyOf));
        }

        public ResourceIterable<Relationship> getRelationships() {
            return null;
        }

        public boolean hasRelationship() {
            return false;
        }

        public ResourceIterable<Relationship> getRelationships(RelationshipType ... types) {
            return null;
        }

        public ResourceIterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
            return null;
        }

        public boolean hasRelationship(RelationshipType ... types) {
            return false;
        }

        public boolean hasRelationship(Direction direction, RelationshipType ... types) {
            return false;
        }

        public ResourceIterable<Relationship> getRelationships(Direction dir) {
            return null;
        }

        public boolean hasRelationship(Direction dir) {
            return false;
        }

        public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
            return null;
        }

        public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
            throw new UnsupportedOperationException();
        }

        public Iterable<RelationshipType> getRelationshipTypes() {
            return null;
        }

        public int getDegree() {
            return 0;
        }

        public int getDegree(RelationshipType type) {
            return 0;
        }

        public int getDegree(Direction direction) {
            return 0;
        }

        public int getDegree(RelationshipType type, Direction direction) {
            return 0;
        }

        public void addLabel(Label label) {
            throw new UnsupportedOperationException();
        }

        public void removeLabel(Label label) {
            throw new UnsupportedOperationException();
        }

        public boolean hasLabel(Label label) {
            return this.labels.contains(label);
        }

        public Iterable<Label> getLabels() {
            return this.labels;
        }
    }

    static final class VirtualRelationship
    extends VirtualEntity
    implements Relationship {
        private final Node startNode;
        private final Node endNode;
        private final RelationshipType type;

        VirtualRelationship(Node startNode, String type, Node endNode) {
            this(startNode, type, Map.of(), endNode);
        }

        VirtualRelationship(Node startNode, String type, Map<String, Object> properties, Node endNode) {
            super(properties);
            this.startNode = startNode;
            this.type = RelationshipType.withName((String)type);
            this.endNode = endNode;
        }

        public Node getStartNode() {
            return this.startNode;
        }

        public Node getEndNode() {
            return this.endNode;
        }

        public Node getOtherNode(Node node) {
            return this.startNode == node ? this.endNode : this.startNode;
        }

        public Node[] getNodes() {
            return new Node[]{this.startNode, this.endNode};
        }

        public RelationshipType getType() {
            return this.type;
        }

        public boolean isType(RelationshipType typeInQuestion) {
            return this.type.equals(typeInQuestion);
        }
    }

    static abstract class VirtualEntity
    implements Entity {
        private static final Supplier<Long> ID_FACTORY = new AtomicLong(-1L)::decrementAndGet;
        private final long id = ID_FACTORY.get();
        private final String elementId = String.valueOf(this.id);
        private final Map<String, Object> properties;

        VirtualEntity(Map<String, Object> properties) {
            this.properties = Map.copyOf(properties);
        }

        public final long getId() {
            return this.id;
        }

        public final String getElementId() {
            return this.elementId;
        }

        public final boolean hasProperty(String key) {
            return this.properties.containsKey(key);
        }

        public final Object getProperty(String key) {
            return this.properties.get(key);
        }

        public final Object getProperty(String key, Object defaultValue) {
            return this.properties.getOrDefault(key, defaultValue);
        }

        public final void setProperty(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        public final Object removeProperty(String key) {
            throw new UnsupportedOperationException();
        }

        public final Iterable<String> getPropertyKeys() {
            return this.properties.keySet();
        }

        public final Map<String, Object> getProperties(String ... keys) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : keys) {
                if (!this.hasProperty(key)) continue;
                result.put(key, this.getProperty(key));
            }
            return result;
        }

        public final Map<String, Object> getAllProperties() {
            return this.properties;
        }

        public final void delete() {
            throw new UnsupportedOperationException();
        }
    }
}

