/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Optional;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.hashing.HashFunction;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexRef;
import org.neo4j.internal.schema.ReservedSchemaRuleNames;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.util.Preconditions;

public class SchemaNameUtil {
    public static String sanitiseName(Optional<String> name) {
        if (name.isPresent()) {
            return SchemaNameUtil.sanitiseName(name.get());
        }
        throw new IllegalArgumentException("Schema rules must have names.");
    }

    public static String sanitiseName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Schema rule name cannot be null.");
        }
        if ((name = name.trim()).isEmpty() || name.isBlank()) {
            throw new IllegalArgumentException("Schema rule name cannot be the empty string or only contain whitespace.");
        }
        int length = name.length();
        for (int i = 0; i < length; ++i) {
            char ch = name.charAt(i);
            if (ch != '\u0000') continue;
            throw new IllegalArgumentException("Schema rule names are not allowed to contain null-bytes: '" + name + "'.");
        }
        if (ReservedSchemaRuleNames.contains(name)) {
            throw new IllegalArgumentException("The index name '" + name + "' is reserved, and cannot be used. The reserved names are " + ReservedSchemaRuleNames.getReservedNames() + ".");
        }
        return name;
    }

    public static String generateName(SchemaDescriptorSupplier rule) {
        Preconditions.checkArgument((rule.schema().getEntityTokenIds().length == 0 ? 1 : 0) != 0, (String)"Schema should target no entity tokens (labels, relationship types).");
        Preconditions.checkArgument((rule.schema().getPropertyIds().length == 0 ? 1 : 0) != 0, (String)"Schema should target no property keys.");
        return SchemaNameUtil.generateName(rule, null);
    }

    public static String generateName(SchemaDescriptorSupplier rule, TokenNameLookup tokenNameLookup) {
        HashFunction hf = HashFunction.incrementalXXH64();
        long key = hf.initialise((long)Boolean.hashCode(rule instanceof ConstraintDescriptor));
        key = hf.update(key, (long)rule.schema().entityType().ordinal());
        key = hf.update(key, (long)rule.schema().schemaPatternMatchingType().ordinal());
        switch (rule.schema().entityType()) {
            case NODE: {
                key = hf.updateWithArray(key, rule.schema().getEntityTokenIds(), id -> tokenNameLookup.labelGetName(id).hashCode());
                break;
            }
            case RELATIONSHIP: {
                key = hf.updateWithArray(key, rule.schema().getEntityTokenIds(), id -> tokenNameLookup.relationshipTypeGetName(id).hashCode());
            }
        }
        key = hf.updateWithArray(key, rule.schema().getPropertyIds(), id -> tokenNameLookup.propertyKeyGetName(id).hashCode());
        if (rule instanceof IndexRef) {
            IndexRef indexRef = (IndexRef)rule;
            key = hf.update(key, (long)indexRef.getIndexType().getTypeNumber());
            key = hf.update(key, (long)Boolean.hashCode(indexRef.isUnique()));
            return String.format("index_%x", hf.toInt(hf.finalise(key)));
        }
        if (rule instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)rule;
            key = hf.update(key, (long)constraint.type().ordinal());
            if (constraint.isIndexBackedConstraint()) {
                key = hf.update(key, (long)constraint.asIndexBackedConstraint().indexType().getTypeNumber());
            }
            if (constraint.enforcesPropertyType()) {
                key = hf.update(key, (long)constraint.asPropertyTypeConstraint().propertyType().hashCode());
            }
            if (constraint.isRelationshipEndpointLabelConstraint()) {
                RelationshipEndpointLabelConstraintDescriptor relEndpointLabelConstraint = constraint.asRelationshipEndpointLabelConstraint();
                key = hf.update(key, (long)tokenNameLookup.labelGetName(relEndpointLabelConstraint.endpointLabelId()).hashCode());
                key = hf.update(key, (long)relEndpointLabelConstraint.endpointType().ordinal());
            }
            if (constraint.isNodeLabelExistenceConstraint()) {
                key = hf.update(key, (long)tokenNameLookup.labelGetName(constraint.asNodeLabelExistenceConstraint().requiredLabelId()).hashCode());
            }
            return String.format("constraint_%x", hf.toInt(hf.finalise(key)));
        }
        throw new IllegalArgumentException("Don't know how to generate a name for this SchemaDescriptorSupplier implementation: " + rule + ".");
    }
}

