/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.AllIndexProviderDescriptors;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.SchemaCommand;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaNameUtil;

public interface SchemaCommandUtils {
    public static IndexPrototype forSchema(SchemaCommand.IndexCommand.Create command, SchemaDescriptor schema, IndexProviderDescriptor descriptorProvider) {
        return IndexPrototype.forSchema(schema, descriptorProvider).withIndexType(command.indexType());
    }

    public static IndexPrototype backingIndex(SchemaDescriptor schema) {
        return IndexPrototype.uniqueForSchema(schema, AllIndexProviderDescriptors.RANGE_DESCRIPTOR);
    }

    public static IndexPrototype withName(String name, IndexPrototype prototype, TokenNameLookup tokenNameLookup) {
        if (name != null && !name.isEmpty()) {
            return prototype.withName(name);
        }
        return prototype.withName(SchemaNameUtil.generateName(prototype, tokenNameLookup));
    }

    public static ConstraintDescriptor withName(String name, ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup) {
        if (name != null && !name.isEmpty()) {
            return constraint.withName(name);
        }
        return constraint.withName(SchemaNameUtil.generateName(constraint, tokenNameLookup));
    }
}

