/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ThreadContext {
    public static final String SECURITY_MANAGER_KEY = ThreadContext.class.getName() + "_SECURITY_MANAGER_KEY";
    public static final String SUBJECT_KEY = ThreadContext.class.getName() + "_SUBJECT_KEY";
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadContext.class);
    private static final ThreadLocal<Map<Object, Object>> RESOURCES = new InheritableThreadLocalMap();

    protected ThreadContext() {
    }

    public static Map<Object, Object> getResources() {
        if (RESOURCES.get() == null) {
            return Collections.emptyMap();
        }
        return new HashMap<Object, Object>(RESOURCES.get());
    }

    public static void setResources(Map<Object, Object> newResources) {
        if (CollectionUtils.isEmpty(newResources)) {
            return;
        }
        ThreadContext.ensureResourcesInitialized();
        RESOURCES.get().clear();
        RESOURCES.get().putAll(newResources);
    }

    private static Object getValue(Object key) {
        Map<Object, Object> perThreadResources = RESOURCES.get();
        return perThreadResources != null ? perThreadResources.get(key) : null;
    }

    private static void ensureResourcesInitialized() {
        if (RESOURCES.get() == null) {
            RESOURCES.set(new HashMap());
        }
    }

    public static Object get(Object key) {
        Object value;
        if (LOGGER.isTraceEnabled()) {
            String msg = "get() - in thread [" + Thread.currentThread().getName() + "]";
            LOGGER.trace(msg);
        }
        if ((value = ThreadContext.getValue(key)) != null && LOGGER.isTraceEnabled()) {
            String msg = "Retrieved value of type [" + value.getClass().getName() + "] for key [" + String.valueOf(key) + "] bound to thread [" + Thread.currentThread().getName() + "]";
            LOGGER.trace(msg);
        }
        return value;
    }

    public static void put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null");
        }
        if (value == null) {
            ThreadContext.remove(key);
            return;
        }
        ThreadContext.ensureResourcesInitialized();
        RESOURCES.get().put(key, value);
        if (LOGGER.isTraceEnabled()) {
            String msg = "Bound value of type [" + value.getClass().getName() + "] for key [" + String.valueOf(key) + "] to thread [" + Thread.currentThread().getName() + "]";
            LOGGER.trace(msg);
        }
    }

    public static Object remove(Object key) {
        Object value;
        Map<Object, Object> perThreadResources = RESOURCES.get();
        Object object = value = perThreadResources != null ? perThreadResources.remove(key) : null;
        if (value != null && LOGGER.isTraceEnabled()) {
            String msg = "Removed value of type [" + value.getClass().getName() + "] for key [" + String.valueOf(key) + "]from thread [" + Thread.currentThread().getName() + "]";
            LOGGER.trace(msg);
        }
        return value;
    }

    public static void remove() {
        RESOURCES.remove();
    }

    public static SecurityManager getSecurityManager() {
        return (SecurityManager)ThreadContext.get(SECURITY_MANAGER_KEY);
    }

    public static void bind(SecurityManager securityManager) {
        if (securityManager != null) {
            ThreadContext.put(SECURITY_MANAGER_KEY, securityManager);
        }
    }

    public static SecurityManager unbindSecurityManager() {
        return (SecurityManager)ThreadContext.remove(SECURITY_MANAGER_KEY);
    }

    public static Subject getSubject() {
        return (Subject)ThreadContext.get(SUBJECT_KEY);
    }

    public static void bind(Subject subject) {
        if (subject != null) {
            ThreadContext.put(SUBJECT_KEY, subject);
        }
    }

    public static Subject unbindSubject() {
        return (Subject)ThreadContext.remove(SUBJECT_KEY);
    }

    private static final class InheritableThreadLocalMap<T extends Map<Object, Object>>
    extends InheritableThreadLocal<Map<Object, Object>> {
        private InheritableThreadLocalMap() {
        }

        @Override
        protected Map<Object, Object> childValue(Map<Object, Object> parentValue) {
            if (parentValue != null) {
                return (Map)((HashMap)parentValue).clone();
            }
            return null;
        }
    }
}

