/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.realm.ldap;

import javax.naming.AuthenticationException;
import javax.naming.NamingException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authz.AuthorizationException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.realm.ldap.JndiLdapContextFactory;
import org.apache.shiro.realm.ldap.LdapContextFactory;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLdapRealm
extends AuthorizingRealm {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractLdapRealm.class);
    protected String principalSuffix;
    protected String searchBase;
    protected String url;
    protected String systemUsername;
    protected String systemPassword;
    protected String searchFilter = "(&(objectClass=*)(userPrincipalName={0}))";
    private LdapContextFactory ldapContextFactory;

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSystemUsername(String systemUsername) {
        this.systemUsername = systemUsername;
    }

    public void setSystemPassword(String systemPassword) {
        this.systemPassword = systemPassword;
    }

    public void setLdapContextFactory(LdapContextFactory ldapContextFactory) {
        this.ldapContextFactory = ldapContextFactory;
    }

    public void setSearchFilter(String searchFilter) {
        this.searchFilter = searchFilter;
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.ensureContextFactory();
    }

    private LdapContextFactory ensureContextFactory() {
        if (this.ldapContextFactory == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("No LdapContextFactory specified - creating a default instance.");
            }
            JndiLdapContextFactory defaultFactory = new JndiLdapContextFactory();
            defaultFactory.setUrl(this.url);
            defaultFactory.setSystemUsername(this.systemUsername);
            defaultFactory.setSystemPassword(this.systemPassword);
            this.ldapContextFactory = defaultFactory;
        }
        return this.ldapContextFactory;
    }

    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken token) throws org.apache.shiro.authc.AuthenticationException {
        AuthenticationInfo info;
        try {
            info = this.queryForAuthenticationInfo(token, this.ensureContextFactory());
        }
        catch (AuthenticationException e) {
            throw new org.apache.shiro.authc.AuthenticationException("LDAP authentication failed.", e);
        }
        catch (NamingException e) {
            String msg = "LDAP naming error while attempting to authenticate user.";
            throw new org.apache.shiro.authc.AuthenticationException(msg, e);
        }
        return info;
    }

    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        AuthorizationInfo info;
        try {
            info = this.queryForAuthorizationInfo(principals, this.ensureContextFactory());
        }
        catch (NamingException e) {
            String msg = "LDAP naming error while attempting to retrieve authorization for user [" + String.valueOf(principals) + "].";
            throw new AuthorizationException(msg, e);
        }
        return info;
    }

    protected abstract AuthenticationInfo queryForAuthenticationInfo(AuthenticationToken var1, LdapContextFactory var2) throws NamingException;

    protected abstract AuthorizationInfo queryForAuthorizationInfo(PrincipalCollection var1, LdapContextFactory var2) throws NamingException;
}

