/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers.traversal.productgraph;

import java.util.List;
import org.neo4j.internal.kernel.api.helpers.traversal.productgraph.SourceCursor;

final class ListCursor<T>
implements SourceCursor<List<T>, T> {
    private List<T> list;
    private int index = -1;

    ListCursor() {
    }

    @Override
    public void setSource(List<T> list) {
        this.list = list;
        this.index = -1;
    }

    @Override
    public boolean next() {
        return ++this.index < this.list.size();
    }

    @Override
    public T current() {
        return this.list.get(this.index);
    }

    @Override
    public void reset() {
        this.index = -1;
    }

    @Override
    public void close() {
        this.list = null;
    }
}

