/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.memory;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.cypher.internal.runtime.memory.ParallelScopedMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u00154A!\u0005\n\u0005?!AQ\u0006\u0001B\u0001B\u0003%\u0001\u0006C\u0003/\u0001\u0011\u0005q\u0006C\u00044\u0001\t\u0007I\u0011\u0002\u001b\t\r}\u0002\u0001\u0015!\u00036\u0011\u001d\u0001\u0005A1A\u0005\n\u0005Ca!\u0012\u0001!\u0002\u0013\u0011\u0005\"\u0002$\u0001\t\u0003:\u0005\"B*\u0001\t\u0003\"\u0006\"\u0002,\u0001\t\u00139\u0006\"\u0002-\u0001\t\u0003J\u0006\"\u0002.\u0001\t\u0003:\u0006\"B.\u0001\t\u0003b\u0006\"B/\u0001\t\u0003J\u0006\"\u00020\u0001\t\u0003J\u0006\"B0\u0001\t\u0003\u0002\u0007\"\u00022\u0001\t\u0003\u001a'!\u000f)s_\u001aLG.\u001b8h!\u0006\u0014\u0018\r\u001c7fY\"Kw\r[,bi\u0016\u0014X*\u0019:l)J\f7m[5oO^{'o[3s\u001b\u0016lwN]=Ue\u0006\u001c7.\u001a:\u000b\u0005M!\u0012AB7f[>\u0014\u0018P\u0003\u0002\u0016-\u00059!/\u001e8uS6,'BA\f\u0019\u0003!Ig\u000e^3s]\u0006d'BA\r\u001b\u0003\u0019\u0019\u0017\u0010\u001d5fe*\u00111\u0004H\u0001\u0006]\u0016|GG\u001b\u0006\u0002;\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\t\u0015\u0011\u0005\u00052S\"\u0001\u0012\u000b\u0005\r\"\u0013\u0001\u00027b]\u001eT\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(E\t1qJ\u00196fGR\u0004\"!K\u0016\u000e\u0003)R!a\u0005\u000e\n\u00051R#!D'f[>\u0014\u0018\u0010\u0016:bG.,'/\u0001\u0005eK2,w-\u0019;f\u0003\u0019a\u0014N\\5u}Q\u0011\u0001G\r\t\u0003c\u0001i\u0011A\u0005\u0005\u0006[\t\u0001\r\u0001K\u0001\nQ\u0016\f\u0007/V:bO\u0016,\u0012!\u000e\t\u0003muj\u0011a\u000e\u0006\u0003qe\na!\u0019;p[&\u001c'B\u0001\u001e<\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003y\u0011\nA!\u001e;jY&\u0011ah\u000e\u0002\n\u0019>tw-\u00113eKJ\f!\u0002[3baV\u001b\u0018mZ3!\u00035A\u0017n\u001a5XCR,'/T1sWV\t!\t\u0005\u00027\u0007&\u0011Ai\u000e\u0002\u000b\u0003R|W.[2M_:<\u0017A\u00045jO\"<\u0016\r^3s\u001b\u0006\u00148\u000eI\u0001\rC2dwnY1uK\"+\u0017\r\u001d\u000b\u0003\u0011:\u0003\"!\u0013'\u000e\u0003)S\u0011aS\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b*\u0013A!\u00168ji\")qj\u0002a\u0001!\u0006)!-\u001f;fgB\u0011\u0011*U\u0005\u0003%*\u0013A\u0001T8oO\u0006Y!/\u001a7fCN,\u0007*Z1q)\tAU\u000bC\u0003P\u0011\u0001\u0007\u0001+A\fd_6\u0004X\u000f^3OK^D\u0015n\u001a5XCR,'/T1sWR\t\u0001*A\tiK\u0006\u0004\b*[4i/\u0006$XM]'be.$\u0012\u0001U\u0001\u0006e\u0016\u001cX\r^\u0001\u0017O\u0016$8kY8qK\u0012lU-\\8ssR\u0013\u0018mY6feR\t\u0001&\u0001\tvg\u0016$g*\u0019;jm\u0016lU-\\8ss\u0006\u0019Rm\u001d;j[\u0006$X\r\u001a%fCBlU-\\8ss\u0006q\u0011\r\u001c7pG\u0006$XMT1uSZ,GC\u0001%b\u0011\u0015yu\u00021\u0001Q\u00035\u0011X\r\\3bg\u0016t\u0015\r^5wKR\u0011\u0001\n\u001a\u0005\u0006\u001fB\u0001\r\u0001\u0015")
public class ProfilingParallelHighWaterMarkTrackingWorkerMemoryTracker
implements MemoryTracker {
    private final MemoryTracker delegate;
    private final LongAdder heapUsage;
    private final AtomicLong highWaterMark;

    public void close() {
        super.close();
    }

    private LongAdder heapUsage() {
        return this.heapUsage;
    }

    private AtomicLong highWaterMark() {
        return this.highWaterMark;
    }

    public void allocateHeap(long bytes) {
        this.delegate.allocateHeap(bytes);
        this.heapUsage().add(bytes);
        this.computeNewHighWaterMark();
    }

    public void releaseHeap(long bytes) {
        this.heapUsage().add(-bytes);
        this.delegate.releaseHeap(bytes);
    }

    private void computeNewHighWaterMark() {
        long current = -1L;
        long newValue = -1L;
        do {
            newValue = this.heapUsage().sum();
            current = this.highWaterMark().get();
            if (current < newValue) continue;
            return;
        } while (!this.highWaterMark().weakCompareAndSetVolatile(current, newValue));
    }

    public long heapHighWaterMark() {
        return this.highWaterMark().get();
    }

    public void reset() {
        this.delegate.reset();
        this.heapUsage().reset();
    }

    public MemoryTracker getScopedMemoryTracker() {
        return new ParallelScopedMemoryTracker(this);
    }

    public long usedNativeMemory() {
        return this.delegate.usedNativeMemory();
    }

    public long estimatedHeapMemory() {
        return this.delegate.estimatedHeapMemory();
    }

    public void allocateNative(long bytes) {
        this.delegate.allocateNative(bytes);
    }

    public void releaseNative(long bytes) {
        this.delegate.releaseNative(bytes);
    }

    public ProfilingParallelHighWaterMarkTrackingWorkerMemoryTracker(MemoryTracker delegate) {
        this.delegate = delegate;
        this.heapUsage = new LongAdder();
        this.highWaterMark = new AtomicLong();
    }
}

