/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime;

import org.neo4j.cypher.internal.runtime.DbAccess;
import org.neo4j.cypher.internal.runtime.PropertyTokensResolver;

class IncompletePropertyTokenResolverProperty
implements PropertyTokensResolver {
    private final String[] names;
    private final int[] tokens;
    private boolean isComplete;

    IncompletePropertyTokenResolverProperty(String[] names, int[] tokens) {
        this.names = names;
        this.tokens = tokens;
    }

    @Override
    public void populate(DbAccess db) {
        if (this.isComplete) {
            return;
        }
        boolean newIsComplete = true;
        int size = this.names.length;
        for (int i = 0; i < size; ++i) {
            int newToken;
            int token = this.tokens[i];
            if (token != -1) continue;
            this.tokens[i] = newToken = db.propertyKey(this.names[i]);
            newIsComplete = newIsComplete && newToken != -1;
        }
        this.isComplete = newIsComplete;
    }

    @Override
    public String[] names() {
        return this.names;
    }

    @Override
    public int[] tokens() {
        return this.tokens;
    }
}

