/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.id;

import org.neo4j.internal.id.IdCapacityExceededException;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.NegativeIdException;
import org.neo4j.internal.id.ReservedIdException;

public final class IdValidator {
    public static final long INTEGER_MINUS_ONE = 0xFFFFFFFFL;

    private IdValidator() {
    }

    public static boolean isReservedId(long id) {
        return id == 0xFFFFFFFFL;
    }

    public static void assertValidId(IdType idType, long id, long maxId) {
        if (IdValidator.isReservedId(id)) {
            throw new ReservedIdException(id);
        }
        IdValidator.assertIdWithinCapacity(idType, id, maxId);
    }

    public static void assertIdWithinCapacity(IdType idType, long id, long maxId) {
        if (id < 0L) {
            throw new NegativeIdException(id);
        }
        IdValidator.assertIdWithinMaxCapacity(idType, id, maxId);
    }

    public static void assertIdWithinMaxCapacity(IdType idType, long id, long maxId) {
        if (id > maxId) {
            throw new IdCapacityExceededException(idType, id, maxId);
        }
    }

    public static boolean hasReservedIdInRange(long startIdInclusive, long endIdExclusive) {
        return startIdInclusive <= 0xFFFFFFFFL && endIdExclusive > 0xFFFFFFFFL;
    }
}

