/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.util.concurrent;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class SequenceArray {
    private static final long UNSET = -1L;
    private long[] array;
    private OutOfOrderSequence.Meta[] metas;
    private int cursor;
    private int itemsAhead;
    private int capacityMask;
    private int missingCount;

    SequenceArray(int initialCapacity) {
        Preconditions.requirePowerOfTwo((long)initialCapacity);
        this.array = new long[initialCapacity];
        this.metas = new OutOfOrderSequence.Meta[initialCapacity];
        this.missingCount = 0;
        this.capacityMask = initialCapacity - 1;
    }

    public void clear() {
        this.cursor = 0;
        this.itemsAhead = 0;
        this.missingCount = 0;
    }

    void offer(long baseNumber, long number, OutOfOrderSequence.Meta meta) {
        int diff = (int)(number - baseNumber);
        this.ensureArrayCapacity(diff);
        int index = this.cursor + diff - 1;
        for (int i = this.cursor + this.itemsAhead; i < index; ++i) {
            this.array[this.index((int)i)] = -1L;
        }
        this.missingCount = diff < this.itemsAhead ? --this.missingCount : (this.missingCount += diff - 1 - this.itemsAhead);
        int absIndex = this.index(index);
        this.array[absIndex] = number;
        this.metas[absIndex] = meta;
        this.itemsAhead = Math.max(this.itemsAhead, diff);
    }

    private int index(int logicalIndex) {
        return logicalIndex & this.capacityMask;
    }

    OutOfOrderSequence.NumberWithMeta pollHighestGapFree(long given, OutOfOrderSequence.Meta givenMeta) {
        if (this.itemsAhead == 0) {
            return new OutOfOrderSequence.NumberWithMeta(given, givenMeta);
        }
        long number = given;
        int length = this.itemsAhead - 1;
        --this.missingCount;
        boolean seenHole = false;
        int absIndex = 0;
        for (int i = 0; i < length; ++i) {
            this.advanceCursor();
            int tentativeAbsIndex = this.index(this.cursor);
            if (this.array[tentativeAbsIndex] == -1L) {
                seenHole = true;
                break;
            }
            absIndex = tentativeAbsIndex;
            assert (this.array[absIndex] == ++number) : "Expected index " + this.cursor + " to be " + number + ", but was " + this.array[absIndex] + ". This is for i=" + i;
        }
        if (!seenHole) {
            this.advanceCursor();
        }
        return new OutOfOrderSequence.NumberWithMeta(number, number == given ? givenMeta : this.metas[absIndex]);
    }

    private void advanceCursor() {
        assert (this.itemsAhead > 0);
        --this.itemsAhead;
        this.cursor = this.advanceCursor(this.cursor);
    }

    private int advanceCursor(int cursor) {
        return cursor + 1 & this.capacityMask;
    }

    private void ensureArrayCapacity(int capacity) {
        if (capacity > this.array.length) {
            int newCapacity = Numbers.ceilingPowerOfTwo((int)capacity);
            long[] newArray = new long[newCapacity];
            OutOfOrderSequence.Meta[] newMetas = new OutOfOrderSequence.Meta[newCapacity];
            for (int i = 0; i < this.itemsAhead; ++i) {
                int index = this.index(this.cursor + i);
                newArray[i] = this.array[index];
                newMetas[i] = this.metas[index];
            }
            this.array = newArray;
            this.metas = newMetas;
            this.cursor = 0;
            this.capacityMask = newCapacity - 1;
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.itemsAhead; ++i) {
            long value = this.array[this.index(this.cursor + i)];
            if (value == -1L) continue;
            builder.append(builder.isEmpty() ? "" : ",").append(value);
        }
        return builder.toString();
    }

    long[] missingItems(long gapFree) {
        int count = this.missingCount;
        if (count == 0) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] missingItems = new long[count];
        int resultCursor = 0;
        for (int i = 0; i < this.itemsAhead; ++i) {
            long value = this.array[this.index(this.cursor + i)];
            if (value != -1L) continue;
            missingItems[resultCursor++] = gapFree + (long)i + 1L;
            if (resultCursor != missingItems.length) continue;
            return missingItems;
        }
        return missingItems;
    }

    long[] snapshot() {
        int snapshotSize = this.itemsAhead - this.missingCount;
        if (snapshotSize == 0) {
            return ArrayUtils.EMPTY_LONG_ARRAY;
        }
        long[] snapshot = new long[snapshotSize];
        int resultCursor = 0;
        for (int i = 0; i < this.itemsAhead; ++i) {
            long value = this.array[this.index(this.cursor + i)];
            if (value == -1L) continue;
            snapshot[resultCursor++] = value;
        }
        return snapshot;
    }
}

