/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.stats;

import org.neo4j.counts.CountsStore;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;

public class RecordDatabaseEntityCounters
implements StoreEntityCounters {
    private final IdGeneratorFactory idGeneratorFactory;
    private final CountsStore countsStore;

    public RecordDatabaseEntityCounters(IdGeneratorFactory idGeneratorFactory, CountsStore countsStore) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.countsStore = countsStore;
    }

    public long nodes(CursorContext cursorContext) {
        return this.idGeneratorFactory.get((IdType)RecordIdType.NODE).getHighId();
    }

    public long relationships(CursorContext cursorContext) {
        return this.idGeneratorFactory.get((IdType)RecordIdType.RELATIONSHIP).getHighId();
    }

    public long properties(CursorContext cursorContext) {
        return this.idGeneratorFactory.get((IdType)RecordIdType.PROPERTY).getHighId();
    }

    public long relationshipTypes(CursorContext cursorContext) {
        return this.idGeneratorFactory.get((IdType)SchemaIdType.RELATIONSHIP_TYPE_TOKEN).getHighId();
    }

    public long allNodesCountStore(CursorContext cursorContext) {
        return this.countsStore.nodeCount(-1, cursorContext);
    }

    public long allRelationshipsCountStore(CursorContext cursorContext) {
        return this.countsStore.relationshipCount(-1, -1, -1, cursorContext);
    }

    public long estimateNodes() {
        return this.idGeneratorFactory.get((IdType)RecordIdType.NODE).getHighId();
    }

    public long estimateRelationships() {
        return this.idGeneratorFactory.get((IdType)RecordIdType.RELATIONSHIP).getHighId();
    }

    public long estimateLabels() {
        return this.idGeneratorFactory.get((IdType)SchemaIdType.LABEL_TOKEN).getHighId();
    }
}

