/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.record;

import org.neo4j.io.pagecache.CursorException;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;

public enum RecordLoad {
    LENIENT_NORMAL(false, true, true),
    LENIENT_CHECK(false, false, true),
    LENIENT_ALWAYS(true, false, true),
    NORMAL(LENIENT_NORMAL),
    CHECK(LENIENT_CHECK),
    ALWAYS(LENIENT_ALWAYS),
    FORCE(true, false, false, false, null);

    private final boolean alwaysLoad;
    private final boolean failOnUnused;
    private final boolean failOnCursorException;
    private final boolean failOnNonFirstUnit;
    private final RecordLoad lenientVariant;

    private RecordLoad(boolean alwaysLoad, boolean failOnUnused, boolean failOnCursorException) {
        this(alwaysLoad, failOnUnused, failOnCursorException, false, null);
    }

    private RecordLoad(RecordLoad lenientVariant) {
        this(lenientVariant.alwaysLoad, lenientVariant.failOnUnused, lenientVariant.failOnCursorException, true, lenientVariant);
    }

    private RecordLoad(boolean alwaysLoad, boolean failOnUnused, boolean failOnCursorException, boolean failOnNonFirstUnit, RecordLoad lenientVariant) {
        this.alwaysLoad = alwaysLoad;
        this.failOnUnused = failOnUnused;
        this.failOnCursorException = failOnCursorException;
        this.failOnNonFirstUnit = failOnNonFirstUnit;
        this.lenientVariant = lenientVariant;
    }

    public final boolean shouldLoad(boolean inUse) {
        return inUse || this.alwaysLoad;
    }

    public final boolean verify(AbstractBaseRecord record) {
        boolean inUse = record.inUse();
        if (this.failOnUnused && !inUse) {
            throw new InvalidRecordException(record + " not in use");
        }
        return this.shouldLoad(inUse);
    }

    public final void clearOrThrowCursorError(PageCursor cursor) {
        if (this.failOnCursorException) {
            try {
                cursor.checkAndClearCursorException();
            }
            catch (CursorException e) {
                throw new InvalidRecordException(e);
            }
        } else {
            cursor.clearCursorException();
        }
    }

    public boolean checkForOutOfBounds(PageCursor cursor) {
        return cursor.checkAndClearBoundsFlag() && this.failOnCursorException;
    }

    public boolean failOnNonFirstUnit() {
        return this.failOnNonFirstUnit;
    }

    public RecordLoad lenient() {
        return this.lenientVariant == null ? this : this.lenientVariant;
    }
}

