/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.kernel.impl.store.GeometryType;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.LongerShortString;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.ShortArray;
import org.neo4j.kernel.impl.store.TemporalType;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum PropertyType {
    BOOL(1){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.booleanValue((boolean)this.getValue(block.getSingleValueLong()));
        }

        private boolean getValue(long propBlock) {
            return (propBlock & 1L) == 1L;
        }
    }
    ,
    BYTE(2){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.byteValue((byte)block.getSingleValueByte());
        }
    }
    ,
    SHORT(3){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.shortValue((short)block.getSingleValueShort());
        }
    }
    ,
    CHAR(4){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.charValue((char)((char)block.getSingleValueShort()));
        }
    }
    ,
    INT(5){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.intValue((int)block.getSingleValueInt());
        }
    }
    ,
    LONG(6){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            long firstBlock = block.getSingleValueBlock();
            long value = this.valueIsInlined(firstBlock) ? block.getSingleValueLong() >>> 1 : block.getValueBlocks()[1];
            return Values.longValue((long)value);
        }

        private boolean valueIsInlined(long firstBlock) {
            return (firstBlock & 0x10000000L) > 0L;
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return this.valueIsInlined(firstBlock) ? 1 : 2;
        }
    }
    ,
    FLOAT(7){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.floatValue((float)Float.intBitsToFloat(block.getSingleValueInt()));
        }
    }
    ,
    DOUBLE(8){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return Values.doubleValue((double)Double.longBitsToDouble(block.getValueBlocks()[1]));
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return 2;
        }
    }
    ,
    STRING(9){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors storeCursors, MemoryTracker memoryTracker) {
            return store.getTextValueFor(block, storeCursors, memoryTracker);
        }

        @Override
        public byte[] readDynamicRecordHeader(byte[] recordBytes) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
    }
    ,
    ARRAY(10){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return store.getArrayFor(block, cursors, memoryTracker);
        }

        @Override
        public byte[] readDynamicRecordHeader(byte[] recordBytes) {
            byte itemType = recordBytes[0];
            if (itemType == STRING.byteValue()) {
                return this.headOf(recordBytes, 5);
            }
            if (itemType <= DOUBLE.byteValue()) {
                return this.headOf(recordBytes, 3);
            }
            if (itemType == GEOMETRY.byteValue()) {
                return this.headOf(recordBytes, 6);
            }
            if (itemType == TEMPORAL.byteValue()) {
                return this.headOf(recordBytes, 2);
            }
            throw new IllegalArgumentException("Unknown array type " + itemType);
        }

        private byte[] headOf(byte[] bytes, int length) {
            return Arrays.copyOf(bytes, length);
        }
    }
    ,
    SHORT_STRING(11){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return LongerShortString.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return LongerShortString.calculateNumberOfBlocksUsed(firstBlock);
        }
    }
    ,
    SHORT_ARRAY(12){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return ShortArray.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return ShortArray.calculateNumberOfBlocksUsed(firstBlock);
        }
    }
    ,
    GEOMETRY(13){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return GeometryType.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return GeometryType.calculateNumberOfBlocksUsed(firstBlock);
        }
    }
    ,
    TEMPORAL(14){

        @Override
        public Value value(PropertyBlock block, PropertyStore store, StoreCursors cursors, MemoryTracker memoryTracker) {
            return TemporalType.decode(block);
        }

        @Override
        public int calculateNumberOfBlocksUsed(long firstBlock) {
            return TemporalType.calculateNumberOfBlocksUsed(firstBlock);
        }
    };

    public static final int BLOCKS_USED_FOR_BAD_TYPE_OR_ENCODING = -1;
    private static final int PAYLOAD_SIZE = 32;
    private final int type;

    private PropertyType(int type) {
        this.type = type;
    }

    public int intValue() {
        return this.type;
    }

    public byte byteValue() {
        return (byte)this.type;
    }

    public abstract Value value(PropertyBlock var1, PropertyStore var2, StoreCursors var3, MemoryTracker var4);

    public static PropertyType getPropertyTypeOrNull(long propBlock) {
        int type = PropertyType.typeIdentifier(propBlock);
        return switch (type) {
            case 1 -> BOOL;
            case 2 -> BYTE;
            case 3 -> SHORT;
            case 4 -> CHAR;
            case 5 -> INT;
            case 6 -> LONG;
            case 7 -> FLOAT;
            case 8 -> DOUBLE;
            case 9 -> STRING;
            case 10 -> ARRAY;
            case 11 -> SHORT_STRING;
            case 12 -> SHORT_ARRAY;
            case 13 -> GEOMETRY;
            case 14 -> TEMPORAL;
            default -> null;
        };
    }

    private static int typeIdentifier(long propBlock) {
        return (int)((propBlock & 0xF000000L) >> 24);
    }

    public static PropertyType getPropertyTypeOrThrow(long propBlock) {
        PropertyType type = PropertyType.getPropertyTypeOrNull(propBlock);
        if (type == null) {
            throw new InvalidRecordException("Unknown property type: " + PropertyType.typeIdentifier(propBlock) + " (from property block " + Long.toHexString(propBlock) + ").");
        }
        return type;
    }

    public static int getPayloadSize() {
        return 32;
    }

    public static int getPayloadSizeLongs() {
        return 4;
    }

    public int calculateNumberOfBlocksUsed(long firstBlock) {
        return 1;
    }

    public byte[] readDynamicRecordHeader(byte[] recordBytes) {
        throw new UnsupportedOperationException();
    }
}

