/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.configuration.Config;
import org.neo4j.exceptions.UnderlyingStorageException;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.id.EmptyIdGeneratorFactory;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.format.RecordFormat;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogTailLogVersionsMetadata;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.storageengine.StoreFileClosedException;
import org.neo4j.storageengine.api.ClosedBatchMetadata;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.OpenTransactionMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreIdSerialization;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.util.ChunkedTransactionRegistry;
import org.neo4j.storageengine.util.HighestAppendBatch;
import org.neo4j.storageengine.util.HighestTransactionId;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class MetaDataStore
extends CommonAbstractStore<MetaDataRecord, NoStoreHeader>
implements MetadataProvider {
    private static final String TYPE_DESCRIPTOR = "NeoStore";
    private static final long LEGACY_STORE_VERSION_VALUE = -3523014627327384477L;
    private static final ImmutableSet<OpenOption> REQUIRED_OPTIONS = Sets.immutable.of((Object)PageCacheOpenOptions.BIG_ENDIAN);
    private static final ImmutableSet<OpenOption> FORBIDDEN_OPTIONS = Sets.immutable.of((Object)PageCacheOpenOptions.MULTI_VERSIONED);
    private volatile StoreId storeId;
    private volatile long legacyStoreVersion = -3523014627327384477L;
    private volatile UUID externalStoreUUID;
    private volatile UUID databaseUUID;
    private final AtomicLong logVersion;
    private final AtomicLong checkpointLogVersion;
    private final AtomicLong lastCommittingTx;
    private final Supplier<StoreId> storeIdFactory;
    private final HighestTransactionId highestCommittedTransaction;
    private final HighestTransactionId highestClosedTransaction;
    private final OutOfOrderSequence lastClosedTx;
    private final OutOfOrderSequence lastClosedBatch;
    private volatile boolean closed;
    private final AtomicLong appendIndex;
    private final HighestAppendBatch lastCommittedBatch;
    private final ChunkedTransactionRegistry chunkedTransactionRegistry = new ChunkedTransactionRegistry();

    MetaDataStore(FileSystemAbstraction fileSystem, Path file, Config conf, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, RecordFormat<MetaDataRecord> recordFormat, boolean readOnly, LogTailLogVersionsMetadata logTailMetadata, String databaseName, ImmutableSet<OpenOption> openOptions, Supplier<StoreId> storeIdFactory) {
        super(fileSystem, file, null, conf, null, EmptyIdGeneratorFactory.EMPTY_ID_GENERATOR_FACTORY, pageCache, pageCacheTracer, logProvider, TYPE_DESCRIPTOR, recordFormat, NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, readOnly, databaseName, MetaDataStore.buildOptions(openOptions));
        this.checkpointLogVersion = new AtomicLong(logTailMetadata.getCheckpointLogVersion());
        this.logVersion = new AtomicLong(logTailMetadata.getLogVersion());
        this.storeIdFactory = storeIdFactory;
        TransactionId lastCommittedTx = logTailMetadata.getLastCommittedTransaction();
        this.lastCommittingTx = new AtomicLong(lastCommittedTx.id());
        this.highestCommittedTransaction = new HighestTransactionId(lastCommittedTx);
        this.highestClosedTransaction = new HighestTransactionId(lastCommittedTx);
        LogPosition logPosition = logTailMetadata.getLastTransactionLogPosition();
        AppendBatchInfo lastBatch = logTailMetadata.lastBatch();
        this.lastCommittedBatch = new HighestAppendBatch(lastBatch);
        this.appendIndex = new AtomicLong(lastBatch.appendIndex());
        OutOfOrderSequence.Meta initialMeta = new OutOfOrderSequence.Meta(logPosition.getLogVersion(), logPosition.getByteOffset(), lastCommittedTx.kernelVersion().version(), lastCommittedTx.checksum(), lastCommittedTx.commitTimestamp(), lastCommittedTx.consensusIndex(), lastCommittedTx.appendIndex());
        this.lastClosedTx = new ArrayQueueOutOfOrderSequence(lastCommittedTx.id(), 128, initialMeta);
        this.lastClosedBatch = new ArrayQueueOutOfOrderSequence(lastBatch.appendIndex(), 128, initialMeta);
    }

    private static ImmutableSet<OpenOption> buildOptions(ImmutableSet<OpenOption> openOptions) {
        return openOptions.newWithoutAll(FORBIDDEN_OPTIONS).newWithAll(REQUIRED_OPTIONS);
    }

    public long nextAppendIndex() {
        return this.appendIndex.incrementAndGet();
    }

    public long getLastAppendIndex() {
        return this.appendIndex.get();
    }

    @Override
    protected void initialiseNewStoreFile(FileFlushEvent flushEvent, CursorContext cursorContext) throws IOException {
        super.initialiseNewStoreFile(flushEvent, cursorContext);
        StoreId storeId = this.storeIdFactory.get();
        this.generateMetadataFile(storeId, UUID.randomUUID(), null, cursorContext);
    }

    @Override
    protected void initialise(CursorContextFactory contextFactory) {
        super.initialise(contextFactory);
        try (CursorContext context = contextFactory.create("readMetadata");){
            this.readMetadataFile(context);
        }
    }

    public long getCheckpointLogVersion() {
        this.assertNotClosed();
        return this.checkpointLogVersion.get();
    }

    public void setCheckpointLogVersion(long version) {
        this.checkpointLogVersion.set(version);
    }

    public long incrementAndGetCheckpointLogVersion() {
        return this.checkpointLogVersion.incrementAndGet();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long transactionAppendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion, long appendIndex) {
        this.assertNotClosed();
        this.lastCommittingTx.set(transactionId);
        OutOfOrderSequence.Meta meta = new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, transactionAppendIndex);
        this.lastClosedBatch.set(appendIndex, meta);
        this.lastClosedTx.set(transactionId, meta);
        this.highestClosedTransaction.set(transactionId, transactionAppendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
        this.highestCommittedTransaction.set(transactionId, transactionAppendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
        this.appendIndex.set(appendIndex);
        this.lastCommittedBatch.set(appendIndex, LogPosition.UNSPECIFIED);
    }

    public void regenerateMetadata(StoreId storeId, UUID externalStoreUUID, CursorContext cursorContext) {
        this.generateMetadataFile(storeId, externalStoreUUID, null, cursorContext);
        this.readMetadataFile(cursorContext);
    }

    public void setDatabaseIdUuid(UUID uuid, CursorContext cursorContext) {
        this.assertNotClosed();
        this.generateMetadataFile(this.getStoreId(), this.externalStoreUUID, uuid, cursorContext);
        this.readMetadataFile(cursorContext);
    }

    public Optional<UUID> getDatabaseIdUuid(CursorContext cursorContext) {
        this.assertNotClosed();
        UUID databaseUUID = this.databaseUUID;
        return Optional.ofNullable(databaseUUID);
    }

    public StoreId getStoreId() {
        this.assertNotClosed();
        return this.storeId;
    }

    public ExternalStoreId getExternalStoreId() {
        this.assertNotClosed();
        return new ExternalStoreId(this.externalStoreUUID);
    }

    public long getCurrentLogVersion() {
        this.assertNotClosed();
        return this.logVersion.get();
    }

    public void setCurrentLogVersion(long version) {
        this.logVersion.set(version);
    }

    public long incrementAndGetVersion() {
        return this.logVersion.incrementAndGet();
    }

    public long nextCommittingTransactionId() {
        this.assertNotClosed();
        return this.lastCommittingTx.incrementAndGet();
    }

    public void transactionCommitted(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        this.assertNotClosed();
        this.highestCommittedTransaction.offer(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
    }

    public long getLastCommittedTransactionId() {
        this.assertNotClosed();
        return this.highestCommittedTransaction.get().id();
    }

    public TransactionId getLastCommittedTransaction() {
        this.assertNotClosed();
        return this.highestCommittedTransaction.get();
    }

    public long getLastClosedTransactionId() {
        this.assertNotClosed();
        return this.lastClosedTx.getHighestGapFreeNumber();
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        this.assertNotClosed();
        return new TransactionIdSnapshot(this.lastClosedTx.reverseSnapshot());
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        this.assertNotClosed();
        return new ClosedTransactionMetadata(this.lastClosedTx.get());
    }

    public ClosedBatchMetadata getLastClosedBatch() {
        this.assertNotClosed();
        return new ClosedBatchMetadata(this.lastClosedBatch.get());
    }

    public void transactionClosed(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.lastClosedTx.offer(transactionId, new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, appendIndex));
        this.highestClosedTransaction.offer(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
    }

    public void batchClosed(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, KernelVersion kernelVersion, LogPosition logPositionAfter) {
        this.lastClosedBatch.offer(appendIndex, new OutOfOrderSequence.Meta(logPositionAfter.getLogVersion(), logPositionAfter.getByteOffset(), kernelVersion.version(), 1, 1L, -1L, appendIndex));
        if (lastBatch && !firstBatch) {
            this.chunkedTransactionRegistry.removeTransaction(transactionId);
        }
    }

    public void resetLastClosedTransaction(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.assertNotClosed();
        OutOfOrderSequence.Meta meta = new OutOfOrderSequence.Meta(logVersion, byteOffset, kernelVersion.version(), checksum, commitTimestamp, consensusIndex, appendIndex);
        this.lastClosedBatch.set(appendIndex, meta);
        this.lastClosedTx.set(transactionId, meta);
    }

    public void appendBatch(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, LogPosition logPositionBefore, LogPosition logPositionAfter) {
        this.lastCommittedBatch.offer(appendIndex, logPositionAfter);
        if (firstBatch && lastBatch) {
            return;
        }
        if (firstBatch) {
            this.chunkedTransactionRegistry.registerTransaction(transactionId, appendIndex, logPositionBefore);
        }
    }

    public AppendBatchInfo getLastCommittedBatch() {
        return this.lastCommittedBatch.get();
    }

    public OpenTransactionMetadata getOldestOpenTransaction() {
        return this.chunkedTransactionRegistry.oldestOpenTransactionMetadata();
    }

    public TransactionId getHighestEverClosedTransaction() {
        return this.highestClosedTransaction.get();
    }

    public void logRecords(DiagnosticsLogger logger) {
        for (Position position : Position.values()) {
            Object value = switch (position) {
                default -> throw new IncompatibleClassChangeError();
                case Position.STORE_ID -> this.storeId;
                case Position.EXTERNAL_STORE_UUID -> this.externalStoreUUID;
                case Position.DATABASE_ID -> this.databaseUUID;
                case Position.LEGACY_STORE_VERSION -> Long.toString(this.legacyStoreVersion);
            };
            logger.log(position.name() + " (" + position.description + "): " + value);
        }
    }

    @Override
    public MetaDataRecord newRecord() {
        return new MetaDataRecord();
    }

    @Override
    public void prepareForCommit(MetaDataRecord record, IdSequence idSequence, CursorContext cursorContext) {
    }

    @Override
    public void close() {
        try {
            super.close();
        }
        finally {
            this.closed = true;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new StoreFileClosedException(this.storageFile);
        }
    }

    private void generateMetadataFile(StoreId storeId, UUID externalStoreUUID, UUID databaseUUID, CursorContext cursorContext) {
        block17: {
            try (PageCursor cursor = this.openPageCursorForWriting(0L, cursorContext);){
                if (cursor.next()) {
                    this.writeLongRecord(cursor, externalStoreUUID.getMostSignificantBits());
                    this.writeLongRecord(cursor, externalStoreUUID.getLeastSignificantBits());
                    if (databaseUUID != null) {
                        this.writeLongRecord(cursor, databaseUUID.getMostSignificantBits());
                        this.writeLongRecord(cursor, databaseUUID.getLeastSignificantBits());
                    } else {
                        this.writeEmptyRecord(cursor);
                        this.writeEmptyRecord(cursor);
                    }
                    this.writeLongRecord(cursor, -3523014627327384477L);
                    this.writeStoreId(cursor, storeId);
                    break block17;
                }
                throw new IllegalStateException("Unable to write metadata store page.");
            }
            catch (IOException e) {
                throw new UnderlyingStorageException((Throwable)e);
            }
        }
        try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
            this.flush(flushEvent, cursorContext);
        }
    }

    private void writeStoreId(PageCursor cursor, StoreId storeId) throws IOException {
        ByteBuffer buffer = MetaDataStore.allocateBufferForPosition(Position.STORE_ID);
        StoreIdSerialization.serializeWithFixedSize((StoreId)storeId, (ByteBuffer)buffer);
        buffer.flip();
        while (buffer.hasRemaining()) {
            this.writeLongRecord(cursor, buffer.getLong());
        }
    }

    private StoreId readStoreId(PageCursor cursor) throws IOException {
        ByteBuffer buffer = MetaDataStore.allocateBufferForPosition(Position.STORE_ID);
        cursor.mark();
        do {
            cursor.setOffsetToMark();
            buffer.clear();
            while (buffer.hasRemaining()) {
                buffer.putLong(this.readLongRecord(cursor));
            }
        } while (cursor.shouldRetry());
        buffer.flip();
        return StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
    }

    private void writeLongRecord(PageCursor cursor, long value) {
        cursor.putByte(Record.IN_USE.byteValue());
        cursor.putLong(value);
    }

    private void writeEmptyRecord(PageCursor cursor) {
        cursor.putByte(Record.NOT_IN_USE.byteValue());
        cursor.putLong(0L);
    }

    private long readLongRecord(PageCursor cursor) {
        cursor.getByte();
        return cursor.getLong();
    }

    private void readMetadataFile(CursorContext cursorContext) {
        try (PageCursor cursor = this.openPageCursorForReading(0L, cursorContext);){
            if (cursor.next()) {
                long metadataLegacyStoreVersion;
                UUID metadataDatabaseUUID;
                UUID metadataExternalUUID;
                do {
                    cursor.setOffset(0);
                    metadataExternalUUID = new UUID(this.readLongRecord(cursor), this.readLongRecord(cursor));
                    cursor.mark();
                    boolean databaseIdInUse = cursor.getByte() == Record.IN_USE.byteValue();
                    cursor.setOffsetToMark();
                    metadataDatabaseUUID = new UUID(this.readLongRecord(cursor), this.readLongRecord(cursor));
                    if (!databaseIdInUse) {
                        metadataDatabaseUUID = null;
                    }
                    metadataLegacyStoreVersion = this.readLongRecord(cursor);
                } while (cursor.shouldRetry());
                if (metadataLegacyStoreVersion != -3523014627327384477L) {
                    throw new IllegalStateException("Trying to read metadata store in unrecognised format");
                }
                this.storeId = this.readStoreId(cursor);
                this.legacyStoreVersion = metadataLegacyStoreVersion;
                this.externalStoreUUID = metadataExternalUUID;
                this.databaseUUID = metadataDatabaseUUID;
            }
        }
        catch (IOException e) {
            throw new UnderlyingStorageException((Throwable)e);
        }
    }

    public static FieldAccess getFieldAccess(PageCache pageCache, Path neoStore, String databaseName, CursorContext cursorContext) {
        return new FieldAccess(pageCache, neoStore, databaseName, cursorContext);
    }

    private static ByteBuffer allocateBufferForPosition(Position position) {
        return ByteBuffer.allocate(position.slotCount * 8);
    }

    public static long lastOccupiedSlot() {
        Position lastPosition = Position.values()[Position.values().length - 1];
        return lastPosition.firstSlotId + lastPosition.slotCount - 1;
    }

    private static enum Position {
        EXTERNAL_STORE_UUID(0, 2, "Database identifier exposed as external store identity. Generated on creation and never updated"),
        DATABASE_ID(2, 2, "The last used DatabaseId for this database"),
        LEGACY_STORE_VERSION(4, 1, "Legacy store format version. This field is used from 5.0 onwards only to distinguish non-migrated pre 5.0 metadata stores."),
        STORE_ID(5, 8, "Store ID");

        private final int firstSlotId;
        private final int slotCount;
        private final String description;

        private Position(int firstSlotId, int slotCount, String description) {
            this.firstSlotId = firstSlotId;
            this.slotCount = slotCount;
            this.description = description;
        }
    }

    public static class FieldAccess {
        private final PageCache pageCache;
        private final Path neoStore;
        private final String databaseName;
        private final CursorContext cursorContext;

        private FieldAccess(PageCache pageCache, Path neoStore, String databaseName, CursorContext cursorContext) {
            this.pageCache = pageCache;
            this.neoStore = neoStore;
            this.databaseName = databaseName;
            this.cursorContext = cursorContext;
        }

        public StoreId readStoreId() throws IOException {
            ByteBuffer buffer = MetaDataStore.allocateBufferForPosition(Position.STORE_ID);
            if (!this.readValue(Position.STORE_ID, buffer)) {
                throw new IllegalStateException("Trying to read Store ID field from uninitialised metadata store");
            }
            return StoreIdSerialization.deserializeWithFixedSize((ByteBuffer)buffer);
        }

        public Optional<UUID> readDatabaseUUID() throws IOException {
            UUID uuid = this.readUUID(Position.DATABASE_ID);
            return Optional.ofNullable(uuid);
        }

        private UUID readUUID(Position position) throws IOException {
            ByteBuffer buffer = MetaDataStore.allocateBufferForPosition(position);
            if (!this.readValue(position, buffer)) {
                return null;
            }
            return new UUID(buffer.getLong(), buffer.getLong());
        }

        public boolean isLegacyFieldValid() throws IOException {
            ByteBuffer buffer = MetaDataStore.allocateBufferForPosition(Position.LEGACY_STORE_VERSION);
            if (!this.readValue(Position.LEGACY_STORE_VERSION, buffer)) {
                return false;
            }
            return -3523014627327384477L == buffer.getLong();
        }

        public void writeStoreId(StoreId storeId) throws IOException {
            ByteBuffer buffer = MetaDataStore.allocateBufferForPosition(Position.STORE_ID);
            StoreIdSerialization.serializeWithFixedSize((StoreId)storeId, (ByteBuffer)buffer);
            buffer.flip();
            this.writeValue(Position.STORE_ID, buffer);
        }

        private boolean readValue(Position position, ByteBuffer value) throws IOException {
            boolean inUse = false;
            try (PagedFile pagedFile = this.pageCache.map(this.neoStore, this.pageCache.pageSize(), this.databaseName, REQUIRED_OPTIONS, IOController.DISABLED);){
                if (pagedFile.getLastPageId() < 0L) {
                    boolean bl = false;
                    return bl;
                }
                try (PageCursor cursor = pagedFile.io(0L, 1, this.cursorContext);){
                    if (!cursor.next()) {
                        boolean bl = false;
                        return bl;
                    }
                    value.mark();
                    block13: do {
                        value.reset();
                        for (int slot = 0; slot < position.slotCount; ++slot) {
                            cursor.setOffset(9 * (position.firstSlotId + slot));
                            boolean bl = inUse = cursor.getByte() == Record.IN_USE.byteValue();
                            if (!inUse) continue block13;
                            value.putLong(cursor.getLong());
                        }
                    } while (cursor.shouldRetry());
                }
            }
            value.flip();
            return inUse;
        }

        private void writeValue(Position position, ByteBuffer value) throws IOException {
            try (PagedFile pagedFile = this.pageCache.map(this.neoStore, this.pageCache.pageSize(), this.databaseName, REQUIRED_OPTIONS);
                 PageCursor cursor = pagedFile.io(0L, 2, this.cursorContext);){
                if (!cursor.next()) {
                    throw new IllegalStateException("Failed to write metadata store");
                }
                for (int slot = 0; slot < position.slotCount; ++slot) {
                    cursor.setOffset(9 * (position.firstSlotId + slot));
                    cursor.putByte(Record.IN_USE.byteValue());
                    cursor.putLong(value.getLong());
                }
            }
        }
    }
}

