/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.UUID;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.format.RecordFormatSelector;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.format.StoreVersion;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.util.BitBuffer;

public class LegacyMetadataHandler {
    private static final String UNKNOWN_VERSION = "Unknown";
    private static final UUID NOT_INITIALIZED_UUID = new UUID(Long.MIN_VALUE, Long.MIN_VALUE);
    private static final Map<String, StoreVersion> LEGACY_VERSION_MAPPING = Map.of("SF4.3.0", StoreVersion.STANDARD_V4_3, "AF4.3.0", StoreVersion.ALIGNED_V4_3, "HL4.3.0", StoreVersion.HIGH_LIMIT_V4_3);

    public static Metadata44 readMetadata44FromStore(PageCache pageCache, Path metadataStore, String databaseName, CursorContext cursorContext) throws IOException {
        try (PagedFile pagedFile = pageCache.map(metadataStore, pageCache.pageSize(), databaseName, Sets.immutable.of((Object)PageCacheOpenOptions.BIG_ENDIAN), IOController.DISABLED);){
            Metadata44 metadata44;
            block22: {
                if (pagedFile.getLastPageId() < 0L) {
                    throw new IllegalStateException("Metadata store is empty");
                }
                PageCursor cursor = pagedFile.io(0L, 1, cursorContext);
                try {
                    RuntimeException exception;
                    if (!cursor.next()) {
                        throw new IllegalStateException("Metadata store is empty");
                    }
                    Metadata44 result = null;
                    do {
                        exception = null;
                        try {
                            KernelVersion kernelVersion;
                            try {
                                long kernelVersionBits = LegacyMetadataHandler.readLongRecord(19, cursor);
                                kernelVersion = KernelVersion.getForVersion((byte)Numbers.safeCastLongToByte((long)kernelVersionBits));
                            }
                            catch (NotInUseException e) {
                                kernelVersion = KernelVersion.EARLIEST;
                            }
                            UUID externalId = LegacyMetadataHandler.readUUID(16, cursor);
                            UUID databaseId = LegacyMetadataHandler.readUUID(20, cursor);
                            try {
                                StoreId storeId = LegacyMetadataHandler.storeIdFromLegacyMetadata(LegacyMetadataHandler.readLongRecord(0, cursor), LegacyMetadataHandler.readLongRecord(1, cursor), LegacyMetadataHandler.readLongRecord(4, cursor));
                                result = new Metadata44(storeId, externalId, kernelVersion, databaseId);
                            }
                            catch (NotInUseException e) {
                                exception = new IllegalStateException("Failed to load data from legacy metadata store");
                            }
                        }
                        catch (RuntimeException e) {
                            exception = e;
                        }
                    } while (cursor.shouldRetry());
                    if (exception != null) {
                        throw exception;
                    }
                    metadata44 = result;
                    if (cursor == null) break block22;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return metadata44;
        }
    }

    private static UUID readUUID(int firstId, PageCursor cursor) {
        try {
            UUID uuid = new UUID(LegacyMetadataHandler.readLongRecord(firstId, cursor), LegacyMetadataHandler.readLongRecord(firstId + 1, cursor));
            if (uuid.equals(NOT_INITIALIZED_UUID)) {
                return null;
            }
            return uuid;
        }
        catch (NotInUseException e) {
            return null;
        }
    }

    private static long readLongRecord(int id, PageCursor cursor) throws NotInUseException {
        cursor.setOffset(id * 9);
        if (cursor.getByte() != Record.IN_USE.byteValue()) {
            throw new NotInUseException();
        }
        return cursor.getLong();
    }

    private static StoreId storeIdFromLegacyMetadata(long creationTime, long random, long legacyVersion) {
        String versionString = LegacyMetadataHandler.versionLongToString(legacyVersion);
        StoreVersion version = LEGACY_VERSION_MAPPING.get(versionString);
        if (version == null) {
            throw new IllegalArgumentException("Unable to read store with version '" + versionString + "'. Please make sure that database is migrated properly to be supported by current version of neo4j.");
        }
        RecordFormats recordFormat = Iterables.stream(RecordFormatSelector.allFormats()).filter(format -> format.getFormatFamily().name().equals(version.formatFamily().name()) && format.majorVersion() == version.majorVersion() && format.minorVersion() == version.minorVersion()).findAny().orElseThrow(() -> new IllegalArgumentException("Unknown store version '" + versionString + "'"));
        return new StoreId(creationTime, random, "record", recordFormat.getFormatFamily().name(), recordFormat.majorVersion(), recordFormat.minorVersion(), versionString);
    }

    private static String versionLongToString(long storeVersion) {
        if (storeVersion == -1L) {
            return UNKNOWN_VERSION;
        }
        BitBuffer bits = BitBuffer.bitsFromLongs((long[])new long[]{storeVersion});
        int length = bits.getShort(8);
        if (length == 0 || length > 7) {
            throw new IllegalArgumentException(String.format("The read version string length %d is not proper.", length));
        }
        char[] result = new char[length];
        for (int i = 0; i < length; ++i) {
            result[i] = (char)bits.getShort(8);
        }
        return new String(result);
    }

    private static class NotInUseException
    extends Exception {
        private NotInUseException() {
        }
    }

    public record Metadata44(StoreId storeId, UUID maybeExternalId, KernelVersion kernelVersion, UUID maybeDatabaseId) {
    }
}

