/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.AbstractDynamicStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.DynamicRecordAllocator;
import org.neo4j.kernel.impl.store.HasLabelSubscriber;
import org.neo4j.kernel.impl.store.InlineNodeLabels;
import org.neo4j.kernel.impl.store.LabelIdArray;
import org.neo4j.kernel.impl.store.NodeLabels;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.allocator.ReusableRecordsCompositeAllocator;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DynamicNodeLabels
implements NodeLabels {
    private final NodeRecord node;

    public DynamicNodeLabels(NodeRecord node) {
        this.node = node;
    }

    @Override
    public int[] get(NodeStore nodeStore, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return DynamicNodeLabels.get(this.node, nodeStore, storeCursors, memoryTracker);
    }

    public static int[] get(NodeRecord node, NodeStore nodeStore, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        nodeStore.ensureHeavy(node, NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()), storeCursors, memoryTracker);
        List<DynamicRecord> usedLabels = node.getUsedDynamicLabelRecords();
        if (usedLabels.isEmpty()) {
            return ArrayUtils.EMPTY_INT_ARRAY;
        }
        return DynamicNodeLabels.getDynamicLabelsArray(usedLabels, nodeStore.getDynamicLabelStore(), storeCursors, memoryTracker);
    }

    public static boolean hasLabel(NodeRecord node, NodeStore nodeStore, StoreCursors storeCursors, int label, MemoryTracker memoryTracker) {
        DynamicArrayStore dynamicLabelStore = nodeStore.getDynamicLabelStore();
        HasLabelSubscriber subscriber = new HasLabelSubscriber(label, dynamicLabelStore, storeCursors, memoryTracker);
        if (node.isLight()) {
            dynamicLabelStore.streamRecords(NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()), RecordLoad.NORMAL, false, storeCursors.readCursor((CursorType)RecordCursorTypes.DYNAMIC_LABEL_STORE_CURSOR), subscriber, memoryTracker);
        } else {
            for (DynamicRecord record : node.getUsedDynamicLabelRecords()) {
                if (!subscriber.onRecord(record)) break;
            }
        }
        return subscriber.hasLabel();
    }

    @Override
    public Collection<DynamicRecord> put(int[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        Arrays.sort(labelIds);
        return DynamicNodeLabels.putSorted(this.node, labelIds, nodeStore, allocator, cursorContext, storeCursors, memoryTracker);
    }

    static Collection<DynamicRecord> putSorted(NodeRecord node, int[] labelIds, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long existingLabelsField = node.getLabelField();
        long existingLabelsBits = NodeLabelsField.parseLabelsBody(existingLabelsField);
        List<DynamicRecord> changedDynamicRecords = node.getDynamicLabelRecords();
        long labelField = node.getLabelField();
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(labelField)) {
            nodeStore.ensureHeavy(node, existingLabelsBits, storeCursors, memoryTracker);
            changedDynamicRecords = node.getDynamicLabelRecords();
            DynamicNodeLabels.setNotInUse(changedDynamicRecords);
        }
        if (!InlineNodeLabels.tryInlineInNodeRecord(node, labelIds, changedDynamicRecords)) {
            Iterator<DynamicRecord> recycledRecords = changedDynamicRecords.iterator();
            List<DynamicRecord> allocatedRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(node.getId(), labelIds, new ReusableRecordsCompositeAllocator(recycledRecords, allocator), cursorContext, memoryTracker);
            while (recycledRecords.hasNext()) {
                DynamicRecord removedRecord = recycledRecords.next();
                removedRecord.setInUse(false);
                allocatedRecords.add(removedRecord);
            }
            node.setLabelField(DynamicNodeLabels.dynamicPointer(allocatedRecords), allocatedRecords);
            changedDynamicRecords = allocatedRecords;
        }
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> add(int labelId, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), storeCursors, memoryTracker);
        int[] existingLabelIds = DynamicNodeLabels.getDynamicLabelsArray(this.node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore(), storeCursors, memoryTracker);
        int[] newLabelIds = LabelIdArray.concatAndSort(existingLabelIds, labelId);
        List<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        List<DynamicRecord> changedDynamicRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, new ReusableRecordsCompositeAllocator(existingRecords, allocator), cursorContext, memoryTracker);
        this.node.setLabelField(DynamicNodeLabels.dynamicPointer(changedDynamicRecords), changedDynamicRecords);
        return changedDynamicRecords;
    }

    @Override
    public Collection<DynamicRecord> remove(int labelId, NodeStore nodeStore, DynamicRecordAllocator allocator, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        nodeStore.ensureHeavy(this.node, NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), storeCursors, memoryTracker);
        int[] existingLabelIds = DynamicNodeLabels.getDynamicLabelsArray(this.node.getUsedDynamicLabelRecords(), nodeStore.getDynamicLabelStore(), storeCursors, memoryTracker);
        int[] newLabelIds = LabelIdArray.filter(existingLabelIds, labelId);
        List<DynamicRecord> existingRecords = this.node.getDynamicLabelRecords();
        if (InlineNodeLabels.tryInlineInNodeRecord(this.node, newLabelIds, existingRecords)) {
            DynamicNodeLabels.setNotInUse(existingRecords);
        } else {
            List<DynamicRecord> newRecords = DynamicNodeLabels.allocateRecordsForDynamicLabels(this.node.getId(), newLabelIds, new ReusableRecordsCompositeAllocator(existingRecords, allocator), cursorContext, memoryTracker);
            this.node.setLabelField(DynamicNodeLabels.dynamicPointer(newRecords), existingRecords);
            if (!newRecords.equals(existingRecords)) {
                for (DynamicRecord record : existingRecords) {
                    if (newRecords.contains(record)) continue;
                    record.setInUse(false);
                }
            }
        }
        return existingRecords;
    }

    public static long dynamicPointer(Collection<DynamicRecord> newRecords) {
        return DynamicNodeLabels.dynamicPointer(((DynamicRecord)Iterables.first(newRecords)).getId());
    }

    public static long dynamicPointer(long dynamicRecordId) {
        return 0x8000000000L | dynamicRecordId;
    }

    private static void setNotInUse(Collection<DynamicRecord> changedDynamicRecords) {
        for (DynamicRecord record : changedDynamicRecords) {
            record.setInUse(false);
        }
    }

    public String toString() {
        if (this.node.isLight()) {
            return String.format("Dynamic(id:%d)", NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()));
        }
        return String.format("Dynamic(id:%d,[%s])", NodeLabelsField.firstDynamicLabelRecordId(this.node.getLabelField()), Arrays.toString(DynamicNodeLabels.parseHeavyRecords(this.node.getUsedDynamicLabelRecords())));
    }

    public static List<DynamicRecord> allocateRecordsForDynamicLabels(long nodeId, int[] labels, DynamicRecordAllocator allocator, CursorContext cursorContext, MemoryTracker memoryTracker) {
        long[] storedLongs = LabelIdArray.prependNodeId(nodeId, labels);
        ArrayList<DynamicRecord> records = new ArrayList<DynamicRecord>();
        DynamicArrayStore.allocateRecords(records, storedLongs, allocator, cursorContext, memoryTracker);
        return records;
    }

    public static int[] getDynamicLabelsArray(Iterable<DynamicRecord> records, DynamicArrayStore dynamicLabelStore, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long[] storedLongs = (long[])dynamicLabelStore.getArrayFor(records, storeCursors, memoryTracker).asObject();
        return LabelIdArray.stripNodeId(storedLongs);
    }

    private static int[] parseHeavyRecords(Iterable<DynamicRecord> records) {
        AbstractDynamicStore.HeavyRecordData heavyRecordData = AbstractDynamicStore.readFullByteArrayFromHeavyRecords(records, PropertyType.ARRAY);
        long[] storedLongs = (long[])DynamicArrayStore.getNumbersArray(heavyRecordData.header(), heavyRecordData.data()).asObject();
        return LabelIdArray.stripNodeId(storedLongs);
    }
}

