/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.validation;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import org.neo4j.internal.recordstorage.validation.PageEntry;
import org.neo4j.internal.recordstorage.validation.TransactionCommandValidator;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.lock.ActiveLock;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.ValidationLockDumper;

public class VerboseValidationLogDumper
implements ValidationLockDumper {
    private static final long UNKNOWN_PAGE_VERSION = -1L;
    private final Log log;
    private final NeoStores neoStores;

    public VerboseValidationLogDumper(LogProvider logProvider, NeoStores neoStores) {
        this.log = logProvider.getLog(this.getClass());
        this.neoStores = neoStores;
    }

    public void dumpLocks(TransactionValidator validator, LockManager.Client lockClient, int chunkNumber, long txId) {
        TransactionCommandValidator tcm = (TransactionCommandValidator)validator;
        Map<PageEntry, Long> observedVersions = tcm.getObservedPageVersions();
        StringBuilder locksDumpBuilder = new StringBuilder();
        locksDumpBuilder.append("Transaction sequence number: ").append(lockClient.getTransactionId()).append(" with tx id(chunk): ").append(txId).append("(").append(chunkNumber).append(")");
        Collection locks = lockClient.activeLocks();
        if (locks.isEmpty()) {
            locksDumpBuilder.append(" does not have any validation page locks.");
        } else {
            locksDumpBuilder.append(" locked page(s):").append(System.lineSeparator());
            EnumMap<StoreType, Integer> storyTypeRecords = new EnumMap<StoreType, Integer>(StoreType.class);
            for (ActiveLock activeLock : locks) {
                long resourceId = activeLock.resourceId();
                StoreType storeType = StoreType.values()[(int)(resourceId >> 54)];
                int recordsPerPage = storyTypeRecords.computeIfAbsent(storeType, type -> this.neoStores.getRecordStore((StoreType)((Object)type)).getRecordsPerPage());
                long pageId = resourceId & 0x3FFFFFFFFFFFFFL;
                locksDumpBuilder.append(pageId).append(" of ").append((Object)storeType).append(" store, with records per page ").append(recordsPerPage).append(" observed page version: ").append(observedVersions.getOrDefault(new PageEntry(pageId, storeType), -1L)).append(System.lineSeparator());
            }
        }
        this.log.error(locksDumpBuilder.toString());
    }
}

