/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.validation;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.recordstorage.validation.TransactionCommandValidator;
import org.neo4j.internal.recordstorage.validation.VerboseValidationLogDumper;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.logging.LogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidator;
import org.neo4j.storageengine.api.txstate.validation.TransactionValidatorFactory;
import org.neo4j.storageengine.api.txstate.validation.ValidationLockDumper;

public class TransactionCommandValidatorFactory
implements TransactionValidatorFactory {
    private final NeoStores neoStores;
    private final Config config;
    private final LogProvider logProvider;

    public TransactionCommandValidatorFactory(NeoStores neoStores, Config config, LogProvider logProvider) {
        this.neoStores = neoStores;
        this.config = config;
        this.logProvider = logProvider;
    }

    public TransactionValidator createTransactionValidator(MemoryTracker memoryTracker, TransactionMonitor transactionMonitor) {
        return new TransactionCommandValidator(this.neoStores, this.config, transactionMonitor);
    }

    public ValidationLockDumper createValidationLockDumper() {
        return (Boolean)this.config.get(GraphDatabaseInternalSettings.multi_version_dump_transaction_validation_page_locks) != false ? new VerboseValidationLogDumper(this.logProvider, this.neoStores) : ValidationLockDumper.EMPTY_DUMPER;
    }
}

