/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.indexcommand;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.common.EntityType;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.recordstorage.indexcommand.IndexRecordState;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.EntityChange;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class TransactionToIndexUpdateVisitor
extends TxStateVisitor.Delegator {
    private static final int[] NO_TOKENS = ArrayUtils.EMPTY_INT_ARRAY;
    private final IndexRecordState indexRecordState;
    private final ReadableTransactionState txState;
    private final StorageNodeCursor nodeCursor;
    private final StorageRelationshipScanCursor relationshipCursor;
    private final IndexDescriptor labelIndex;
    private final IndexDescriptor relationshipTypeIndex;

    public TransactionToIndexUpdateVisitor(TxStateVisitor next, IndexRecordState indexRecordState, StorageReader storageReader, ReadableTransactionState txState, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(next);
        this.indexRecordState = indexRecordState;
        this.txState = txState;
        this.nodeCursor = storageReader.allocateNodeCursor(cursorContext, storeCursors, memoryTracker);
        this.relationshipCursor = storageReader.allocateRelationshipScanCursor(cursorContext, storeCursors, memoryTracker);
        this.labelIndex = TransactionToIndexUpdateVisitor.getTokenIndex(storageReader, EntityType.NODE);
        this.relationshipTypeIndex = TransactionToIndexUpdateVisitor.getTokenIndex(storageReader, EntityType.RELATIONSHIP);
    }

    private static IndexDescriptor getTokenIndex(StorageReader storageReader, EntityType entityType) {
        return (IndexDescriptor)Iterators.firstOrNull((Iterator)storageReader.indexGetForSchema((SchemaDescriptor)SchemaDescriptors.forAnyEntityTokens((EntityType)entityType)));
    }

    public void visitDeletedNode(long id) {
        super.visitDeletedNode(id);
        if (this.labelIndex == null) {
            return;
        }
        this.nodeCursor.single(id);
        if (this.nodeCursor.next()) {
            int[] labelsBefore = this.nodeCursor.labels();
            if (labelsBefore.length > 1) {
                Arrays.sort(labelsBefore);
            }
            this.indexRecordState.addTokenUpdate((TokenIndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.labelIndex, (int[])labelsBefore, (int[])NO_TOKENS));
        }
    }

    public void visitNodeLabelChanges(long id, LongSet added, LongSet removed) throws ConstraintValidationException {
        int[] currentLabels;
        IntHashSet labels;
        super.visitNodeLabelChanges(id, added, removed);
        if (this.labelIndex == null) {
            return;
        }
        if (this.txState.nodeIsAddedInThisBatch(id)) {
            labels = IntHashSet.newSetWith((int[])TransactionToIndexUpdateVisitor.toIntArray(added));
            currentLabels = NO_TOKENS;
        } else {
            this.nodeCursor.single(id);
            currentLabels = this.nodeCursor.next() ? this.nodeCursor.labels() : NO_TOKENS;
            IntHashSet mutableLabels = new IntHashSet();
            for (int currentLabel : currentLabels) {
                if (removed.contains((long)currentLabel)) continue;
                mutableLabels.add(currentLabel);
            }
            mutableLabels.addAll(TransactionToIndexUpdateVisitor.toIntArray(added));
            labels = mutableLabels;
        }
        this.indexRecordState.addTokenUpdate((TokenIndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.labelIndex, (int[])currentLabels, (int[])labels.toSortedArray()));
    }

    public void visitRelationshipModifications(RelationshipModifications modifications) throws ConstraintValidationException {
        super.visitRelationshipModifications(modifications);
        if (this.relationshipTypeIndex == null) {
            return;
        }
        modifications.creations().forEach((id, type, startNode, endNode, addedProperties, changedProperties, removedProperties) -> this.indexRecordState.addTokenUpdate((TokenIndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.relationshipTypeIndex, (int[])NO_TOKENS, (int[])new int[]{type})));
        modifications.deletions().forEach((id, type, startNode, endNode, noProperties, changedProperties, removedProperties) -> {
            if (type == -1) {
                this.relationshipCursor.single(id);
                if (!this.relationshipCursor.next()) {
                    throw new IllegalStateException("Relationship being deleted should exist along with its nodes. Relationship[" + id + "]");
                }
                this.indexRecordState.addTokenUpdate((TokenIndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.relationshipTypeIndex, (int[])new int[]{this.relationshipCursor.type()}, (int[])NO_TOKENS));
            } else {
                this.indexRecordState.addTokenUpdate((TokenIndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.change((long)id, (SchemaDescriptorSupplier)this.relationshipTypeIndex, (int[])new int[]{type}, (int[])NO_TOKENS));
            }
        });
    }

    public void visitValueIndexUpdate(IndexDescriptor descriptor, long entityId, ValueTuple values, EntityChange entityChange) {
        super.visitValueIndexUpdate(descriptor, entityId, values, entityChange);
        IndexRecordState.IndexEntityPair key = new IndexRecordState.IndexEntityPair(descriptor.getId(), entityId);
        ValueIndexEntryUpdate<IndexDescriptor> existingUpdate = this.indexRecordState.getValueUpdate(key);
        ValueIndexEntryUpdate<IndexDescriptor> update = this.getValueUpdate(descriptor, entityId, values, entityChange, existingUpdate, key);
        this.indexRecordState.putValueUpdate(key, update);
    }

    private ValueIndexEntryUpdate<IndexDescriptor> getValueUpdate(IndexDescriptor descriptor, long entityId, ValueTuple values, EntityChange entityChange, ValueIndexEntryUpdate<IndexDescriptor> existingUpdate, IndexRecordState.IndexEntityPair key) {
        if (entityChange == EntityChange.ADDED) {
            return existingUpdate == null ? IndexEntryUpdate.add((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])values.getValues()) : IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])existingUpdate.values(), (Value[])values.getValues());
        }
        return existingUpdate == null ? IndexEntryUpdate.remove((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])values.getValues()) : IndexEntryUpdate.change((long)entityId, (SchemaDescriptorSupplier)descriptor, (Value[])values.getValues(), (Value[])existingUpdate.values());
    }

    public void close() throws KernelException {
        super.close();
        IOUtils.closeAllUnchecked((AutoCloseable[])new StorageEntityScanCursor[]{this.nodeCursor, this.relationshipCursor});
    }

    private static int[] toIntArray(LongSet ids) {
        return TransactionToIndexUpdateVisitor.toIntArray(ids.toArray());
    }

    private static int[] toIntArray(long[] data) {
        int[] tokens = new int[data.length];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = (int)data[i];
        }
        return tokens;
    }
}

