/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.indexcommand;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.string.Mask;

public class TokenIndexUpdateCommand
extends IndexUpdateCommand<int[]> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(TokenIndexUpdateCommand.class);
    private final int[] before;
    private final int[] values;

    public TokenIndexUpdateCommand(LogCommandSerialization serialization, UpdateMode updateMode, long indexId, long entityId, int[] before, int[] values) {
        super(serialization, updateMode, indexId, entityId);
        this.before = before;
        this.values = values;
    }

    @Override
    public int[] getBefore() {
        return this.before;
    }

    @Override
    public int[] getAfter() {
        return this.values;
    }

    @Override
    public String toString(Mask mask) {
        return String.format("TokenIndexUpdateCommand[mode:%s, indexId:%d, entityId:%d, before:%s, after:%s]", this.updateMode, this.indexId, this.entityId, Arrays.toString(this.before), Arrays.toString(this.values));
    }

    @Override
    public boolean handle(CommandVisitor handler) throws IOException {
        return handler.visitIndexUpdateCommand(this);
    }

    public void serialize(WritableChannel channel) throws IOException {
        this.serialization.writeIndexUpdateCommand(channel, this);
    }
}

