/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.indexcommand;

import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockType;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.UpdateMode;

public abstract class IndexUpdateCommand<T>
extends Command {
    final UpdateMode updateMode;
    final long indexId;
    final long entityId;

    public IndexUpdateCommand(LogCommandSerialization serialization, UpdateMode updateMode, long indexId, long entityId) {
        super(serialization);
        this.updateMode = updateMode;
        this.indexId = indexId;
        this.entityId = entityId;
    }

    public UpdateMode getUpdateMode() {
        return this.updateMode;
    }

    public long getIndexId() {
        return this.indexId;
    }

    public long getEntityId() {
        return this.entityId;
    }

    public abstract T getBefore();

    public abstract T getAfter();

    @Override
    public void lockForRecovery(LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
        lockGroup.add(lockService.acquireCustomLock(4, this.getIndexId(), LockType.EXCLUSIVE));
    }
}

