/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.indexcommand;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.collection.trackable.HeapTrackingCollections;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.RecordState;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.recordstorage.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.values.storable.Value;

public class IndexRecordState
implements RecordState {
    private final LogCommandSerialization serialization;
    private final List<TokenIndexEntryUpdate<IndexDescriptor>> tokenIndexUpdates = new ArrayList<TokenIndexEntryUpdate<IndexDescriptor>>();
    private final Map<IndexEntityPair, ValueIndexEntryUpdate<IndexDescriptor>> valueIndexUpdates = new HashMap<IndexEntityPair, ValueIndexEntryUpdate<IndexDescriptor>>();

    public IndexRecordState(LogCommandSerialization serialization) {
        this.serialization = serialization;
    }

    @Override
    public void extractCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        int tokenIndexCommandsSize;
        int valueIndexCommandsSize = this.valueIndexUpdates.size();
        if (valueIndexCommandsSize + (tokenIndexCommandsSize = this.tokenIndexUpdates.size()) == 0) {
            return;
        }
        memoryTracker.allocateHeap((long)valueIndexCommandsSize * ValueIndexUpdateCommand.SHALLOW_SIZE);
        memoryTracker.allocateHeap((long)tokenIndexCommandsSize * TokenIndexUpdateCommand.SHALLOW_SIZE);
        this.extractValueCommands(target, memoryTracker);
        this.extractTokenCommands(target, memoryTracker);
    }

    private void extractTokenCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        try (HeapTrackingArrayList tokenIndexIndexCommands = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);){
            for (TokenIndexEntryUpdate<IndexDescriptor> update : this.tokenIndexUpdates) {
                tokenIndexIndexCommands.add((Object)new TokenIndexUpdateCommand(this.serialization, update.updateMode(), ((IndexDescriptor)update.indexKey()).getId(), update.getEntityId(), update.beforeValues(), update.values()));
            }
            tokenIndexIndexCommands.sort((Comparator)IndexComamdComparator.INDEX_COMMANDS_COMPARATOR);
            target.addAll((Collection<StorageCommand>)tokenIndexIndexCommands);
        }
    }

    private void extractValueCommands(Collection<StorageCommand> target, MemoryTracker memoryTracker) {
        try (HeapTrackingArrayList valueIndexCommands = HeapTrackingCollections.newArrayList((MemoryTracker)memoryTracker);){
            for (ValueIndexEntryUpdate<IndexDescriptor> update : this.valueIndexUpdates.values()) {
                Value[] before = null;
                if (update.updateMode() == UpdateMode.CHANGED) {
                    before = update.beforeValues();
                }
                valueIndexCommands.add((Object)new ValueIndexUpdateCommand(this.serialization, update.updateMode(), ((IndexDescriptor)update.indexKey()).getId(), update.getEntityId(), before, update.values()));
            }
            valueIndexCommands.sort((Comparator)IndexComamdComparator.INDEX_COMMANDS_COMPARATOR);
            target.addAll((Collection<StorageCommand>)valueIndexCommands);
        }
    }

    public void addTokenUpdate(TokenIndexEntryUpdate<IndexDescriptor> tokenIndexUpdate) {
        this.tokenIndexUpdates.add(tokenIndexUpdate);
    }

    public void putValueUpdate(IndexEntityPair key, ValueIndexEntryUpdate<IndexDescriptor> update) {
        this.valueIndexUpdates.put(key, update);
    }

    public ValueIndexEntryUpdate<IndexDescriptor> getValueUpdate(IndexEntityPair key) {
        return this.valueIndexUpdates.get(key);
    }

    private static class IndexComamdComparator
    implements Comparator<IndexUpdateCommand> {
        static final IndexComamdComparator INDEX_COMMANDS_COMPARATOR = new IndexComamdComparator();

        private IndexComamdComparator() {
        }

        @Override
        public int compare(IndexUpdateCommand o1, IndexUpdateCommand o2) {
            int result = Long.compare(o1.getIndexId(), o2.getIndexId());
            if (result != 0) {
                return result;
            }
            return Long.compare(o1.getEntityId(), o2.getEntityId());
        }
    }

    record IndexEntityPair(long indexId, long entityId) {
    }
}

