/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.idx.value;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.List;
import org.neo4j.internal.recordstorage.idx.value.ValueStream;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.values.AnyValueWriter;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.RelationshipValue;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;

class ValueWriter
implements AnyValueWriter<IOException> {
    private final WritableChannel out;

    ValueWriter(WritableChannel out) {
        this.out = out;
    }

    public AnyValueWriter.EntityMode entityMode() {
        return AnyValueWriter.EntityMode.FULL;
    }

    public void writeNodeReference(long nodeId) {
        throw new UnsupportedOperationException("Cannot write entities");
    }

    public void writeNode(String elementId, long nodeId, TextArray labels, MapValue properties, boolean isDeleted) {
        throw new UnsupportedOperationException("Cannot write entities");
    }

    public void writeRelationshipReference(long relationshipId) {
        throw new UnsupportedOperationException("Cannot write entities");
    }

    public void writeRelationship(String elementId, long relId, String startNodeElementId, long startNodeId, String endNodeElementId, long endNodeId, TextValue type, MapValue properties, boolean isDeleted) {
        throw new UnsupportedOperationException("Cannot write entities");
    }

    public void beginMap(int size) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void endMap() {
    }

    public void beginList(int size) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void endList() {
    }

    public void writePathReference(long[] nodes, long[] relationships) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void writePathReference(VirtualNodeValue[] nodes, VirtualRelationshipValue[] relationships) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void writePathReference(List<VirtualNodeValue> nodes, List<VirtualRelationshipValue> relationships) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void writePath(NodeValue[] nodes, RelationshipValue[] relationships) {
        throw new UnsupportedOperationException("Cannot write paths");
    }

    public void writeVirtualNodeHack(Object node) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void writeVirtualRelationshipHack(Object relationship) {
        throw new UnsupportedOperationException("Cannot write virtual types");
    }

    public void writePoint(CoordinateReferenceSystem crs, double[] coordinate) throws IOException {
        ValueStream.writePoint(this.out, crs, coordinate);
    }

    public void writeDuration(long months, long days, long seconds, int nanos) throws IOException {
        ValueStream.writeDuration(this.out, months, days, seconds, nanos);
    }

    public void writeDate(LocalDate localDate) throws IOException {
        ValueStream.writeDate(this.out, localDate);
    }

    public void writeLocalTime(LocalTime localTime) throws IOException {
        ValueStream.writeLocalTime(this.out, localTime);
    }

    public void writeTime(OffsetTime offsetTime) throws IOException {
        ValueStream.writeTime(this.out, offsetTime);
    }

    public void writeLocalDateTime(LocalDateTime localDateTime) throws IOException {
        ValueStream.writeLocalDateTime(this.out, localDateTime);
    }

    public void writeDateTime(ZonedDateTime zonedDateTime) throws IOException {
        ValueStream.writeDateTime(this.out, zonedDateTime);
    }

    public void writeNull() throws IOException {
        ValueStream.writeNoValue(this.out);
    }

    public void writeBoolean(boolean value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeInteger(byte value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeInteger(short value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeInteger(int value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeInteger(long value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeFloatingPoint(float value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeFloatingPoint(double value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeUTF8(byte[] bytes, int offset, int length) throws IOException {
        ValueStream.writeUTF8(this.out, bytes, offset, length);
    }

    public void writeString(String value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void writeString(char value) throws IOException {
        ValueStream.write(this.out, value);
    }

    public void beginArray(int size, ValueWriter.ArrayType arrayType) throws IOException {
        ValueStream.packArrayHeader(this.out, size);
        byte type = switch (arrayType) {
            case ValueWriter.ArrayType.SHORT -> -38;
            case ValueWriter.ArrayType.INT -> -39;
            case ValueWriter.ArrayType.LONG -> -40;
            case ValueWriter.ArrayType.FLOAT -> -42;
            case ValueWriter.ArrayType.DOUBLE -> -41;
            case ValueWriter.ArrayType.BOOLEAN -> -37;
            case ValueWriter.ArrayType.STRING -> -35;
            case ValueWriter.ArrayType.CHAR -> -36;
            case ValueWriter.ArrayType.POINT -> -28;
            case ValueWriter.ArrayType.ZONED_DATE_TIME -> -34;
            case ValueWriter.ArrayType.LOCAL_DATE_TIME -> -33;
            case ValueWriter.ArrayType.DATE -> -32;
            case ValueWriter.ArrayType.ZONED_TIME -> -30;
            case ValueWriter.ArrayType.LOCAL_TIME -> -31;
            case ValueWriter.ArrayType.DURATION -> -29;
            default -> throw new IllegalStateException("Unexpected value: " + arrayType);
        };
        this.out.put(type);
    }

    public void endArray() {
    }

    public void writeByteArray(byte[] value) throws IOException {
        ValueStream.write(this.out, value);
    }
}

