/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.idx;

import java.io.IOException;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;

public class PositiveNumberEncoder {
    private static final byte MARKER_1 = -128;
    private static final byte MARKER_2 = 64;
    private static final byte MARKER_3 = 32;
    private static final byte MARKER_4 = 16;
    private static final byte MARKER_5 = 8;

    public static void writeNumber(WritableChannel out, long number) throws IOException {
        if ((number & 0xF800000000000000L) != 0L) {
            throw new IllegalArgumentException("The submitted number is not supported: " + number);
        }
        if ((number & 0xFFFFFFFFFFFFFF80L) == 0L) {
            out.put((byte)(number | 0xFFFFFFFFFFFFFF80L));
            return;
        }
        if ((number & 0xFFFFFFFFFFFFC000L) == 0L) {
            out.put((byte)(number >> 8 | 0x40L));
            out.put((byte)number);
            return;
        }
        if ((number & 0xFFFFFFFFFFE00000L) == 0L) {
            out.put((byte)(number >> 16 | 0x20L));
            out.put((byte)(number >> 8));
            out.put((byte)number);
            return;
        }
        if ((number & 0xFFFFFFFFF0000000L) == 0L) {
            out.put((byte)(number >> 24 | 0x10L));
            out.put((byte)(number >> 16));
            out.put((byte)(number >> 8));
            out.put((byte)number);
            return;
        }
        if ((number & 0xFFFFFFF800000000L) == 0L) {
            out.put((byte)(number >> 32 | 8L));
            out.put((byte)(number >> 24));
            out.put((byte)(number >> 16));
            out.put((byte)(number >> 8));
            out.put((byte)number);
            return;
        }
        out.put((byte)(number >> 56));
        out.put((byte)(number >> 48));
        out.put((byte)(number >> 40));
        out.put((byte)(number >> 32));
        out.put((byte)(number >> 24));
        out.put((byte)(number >> 16));
        out.put((byte)(number >> 8));
        out.put((byte)number);
    }

    public static long readNumber(ReadableChannel in) throws IOException {
        byte firstByte = in.get();
        if ((firstByte & 0xFFFFFF80) != 0) {
            return firstByte ^ 0xFFFFFF80;
        }
        if ((firstByte & 0x40) != 0) {
            return ((firstByte ^ 0x40) & 0xFF) << 8 | in.get() & 0xFF;
        }
        if ((firstByte & 0x20) != 0) {
            return ((firstByte ^ 0x20) & 0xFF) << 16 | (in.get() & 0xFF) << 8 | in.get() & 0xFF;
        }
        if ((firstByte & 0x10) != 0) {
            return ((long)(firstByte ^ 0x10) & 0xFFL) << 24 | (long)((in.get() & 0xFF) << 16) | (long)((in.get() & 0xFF) << 8) | (long)(in.get() & 0xFF);
        }
        if ((firstByte & 8) != 0) {
            return ((long)(firstByte ^ 8) & 0xFFL) << 32 | ((long)in.get() & 0xFFL) << 24 | (long)((in.get() & 0xFF) << 16) | (long)((in.get() & 0xFF) << 8) | (long)(in.get() & 0xFF);
        }
        return ((long)firstByte & 0xFFL) << 56 | ((long)in.get() & 0xFFL) << 48 | ((long)in.get() & 0xFFL) << 40 | ((long)in.get() & 0xFFL) << 32 | ((long)in.get() & 0xFFL) << 24 | (long)((in.get() & 0xFF) << 16) | (long)((in.get() & 0xFF) << 8) | (long)(in.get() & 0xFF);
    }
}

