/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.Supplier;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;

class SimpleDegreeStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final Supplier<DegreeUpdater> degreeUpdaterSupplier;
    private DegreeUpdater degreesUpdater;

    SimpleDegreeStoreTransactionApplier(Supplier<DegreeUpdater> degreeUpdaterSupplier) {
        this.degreeUpdaterSupplier = degreeUpdaterSupplier;
    }

    @Override
    public boolean visitGroupDegreeCommand(Command.GroupDegreeCommand command) {
        this.degreesUpdater().increment(command.groupId(), command.direction(), command.delta());
        return false;
    }

    @Override
    public void close() {
        if (this.degreesUpdater != null) {
            this.degreesUpdater.close();
        }
    }

    private DegreeUpdater degreesUpdater() {
        if (this.degreesUpdater == null) {
            this.degreesUpdater = this.degreeUpdaterSupplier.get();
        }
        return this.degreesUpdater;
    }
}

