/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordNodeScan;
import org.neo4j.internal.recordstorage.RecordRelationshipGroupCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipScanCursor;
import org.neo4j.internal.recordstorage.RecordRelationshipTraversalCursor;
import org.neo4j.internal.recordstorage.RelationshipReferenceEncoding;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RecordLoadOverride;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipDirection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.string.Mask;

public class RecordNodeCursor
extends NodeRecord
implements StorageNodeCursor {
    private final NodeStore read;
    private final RelationshipGroupDegreesStore groupDegreesStore;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final RelationshipStore relationshipStore;
    private final RelationshipGroupStore groupStore;
    private PageCursor singleCursor;
    private PageCursor scanCursor;
    private PageCursor currentCursor;
    private long next;
    private long highMark;
    private long nextStoreReference;
    private boolean open;
    private boolean batched;
    private RecordRelationshipGroupCursor groupCursor;
    private RecordRelationshipTraversalCursor relationshipCursor;
    private RecordRelationshipScanCursor relationshipScanCursor;
    private RecordLoadOverride loadMode;
    private final MemoryTracker memoryTracker;

    RecordNodeCursor(NodeStore read, RelationshipStore relationshipStore, RelationshipGroupStore groupStore, RelationshipGroupDegreesStore groupDegreesStore, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        super(-1L);
        this.read = read;
        this.groupDegreesStore = groupDegreesStore;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
        this.relationshipStore = relationshipStore;
        this.groupStore = groupStore;
        this.memoryTracker = memoryTracker;
        this.loadMode = RecordLoadOverride.none();
    }

    public void scan() {
        if (this.getId() != -1L) {
            this.resetState();
        }
        this.selectScanCursor();
        this.next = 0L;
        this.highMark = this.nodeHighMark();
        this.nextStoreReference = -1L;
        this.open = true;
        this.batched = false;
    }

    public void single(long reference) {
        if (this.getId() != -1L) {
            this.resetState();
        }
        this.selectSingleCursor();
        this.next = reference >= 0L ? reference : -1L;
        this.highMark = -1L;
        this.nextStoreReference = -1L;
        this.open = true;
        this.batched = false;
    }

    public boolean scanBatch(AllNodeScan scan, long sizeHint) {
        if (this.getId() != -1L) {
            this.reset();
        }
        this.batched = true;
        this.open = true;
        this.nextStoreReference = -1L;
        return ((RecordNodeScan)scan).scanBatch(sizeHint, this);
    }

    boolean scanRange(long start, long stop) {
        long max = this.nodeHighMark();
        if (start > max) {
            this.reset();
            return false;
        }
        if (start > stop) {
            this.reset();
            return true;
        }
        this.selectScanCursor();
        this.next = start;
        this.highMark = Math.min(stop, max);
        return true;
    }

    public long entityReference() {
        return this.getId();
    }

    public int[] labels() {
        return NodeLabelsField.get(this, this.read, this.storeCursors, this.memoryTracker);
    }

    public boolean hasLabel(int label) {
        return NodeLabelsField.hasLabel(this, this.read, this.storeCursors, label, this.memoryTracker);
    }

    public boolean hasLabel() {
        return this.getLabelField() != (long)Record.NO_LABELS_FIELD.intValue();
    }

    public boolean hasProperties() {
        return this.nextProp != -1L;
    }

    public long relationshipsReference() {
        return RecordNodeCursor.relationshipsReferenceWithDenseMarker(this.getNextRel(), this.isDense());
    }

    static long relationshipsReferenceWithDenseMarker(long nextRel, boolean isDense) {
        return isDense ? RelationshipReferenceEncoding.encodeDense(nextRel) : nextRel;
    }

    public void relationships(StorageRelationshipTraversalCursor traversalCursor, RelationshipSelection selection) {
        ((RecordRelationshipTraversalCursor)traversalCursor).init(this, selection);
    }

    public boolean supportsFastRelationshipsTo() {
        return false;
    }

    public void relationshipsTo(StorageRelationshipTraversalCursor traversalCursor, RelationshipSelection selection, long neighbourNodeReference) {
        throw new UnsupportedOperationException();
    }

    public int[] relationshipTypes() {
        MutableIntSet types = IntSets.mutable.empty();
        if (!this.isDense()) {
            this.ensureRelationshipTraversalCursorInitialized();
            this.relationshipCursor.init(this, RelationshipSelection.ALL_RELATIONSHIPS);
            while (this.relationshipCursor.next()) {
                types.add(this.relationshipCursor.type());
            }
        } else {
            if (this.groupCursor == null) {
                this.groupCursor = new RecordRelationshipGroupCursor(this.relationshipStore, this.groupStore, this.groupDegreesStore, this.loadMode, this.cursorContext, this.storeCursors, this.memoryTracker);
            }
            this.groupCursor.init(this.entityReference(), this.getNextRel(), true);
            while (this.groupCursor.next()) {
                types.add(this.groupCursor.getType());
            }
        }
        return types.toArray();
    }

    private void ensureRelationshipTraversalCursorInitialized() {
        if (this.relationshipCursor == null) {
            this.relationshipCursor = new RecordRelationshipTraversalCursor(this.relationshipStore, this.groupStore, this.groupDegreesStore, this.cursorContext, this.storeCursors, this.memoryTracker);
        }
    }

    private void ensureRelationshipScanCursorInitialized() {
        if (this.relationshipScanCursor == null) {
            this.relationshipScanCursor = new RecordRelationshipScanCursor(this.relationshipStore, this.cursorContext, this.storeCursors, this.memoryTracker);
        }
    }

    public void degrees(RelationshipSelection selection, Degrees.Mutator mutator) {
        if (!(mutator.isSplit() || this.isDense() || selection.isLimited())) {
            this.ensureRelationshipScanCursorInitialized();
            this.relationshipScanCursor.single(this.getNextRel());
            if (this.relationshipScanCursor.next()) {
                int degree = this.relationshipScanCursor.sourceNodeReference() == this.getId() ? (int)this.relationshipScanCursor.getFirstPrevRel() : (int)this.relationshipScanCursor.getSecondPrevRel();
                mutator.add(-1, degree, 0, 0);
            }
            return;
        }
        if (!this.isDense()) {
            this.ensureRelationshipTraversalCursorInitialized();
            this.relationshipCursor.init(this, RelationshipSelection.ALL_RELATIONSHIPS);
            while (this.relationshipCursor.next()) {
                if (!selection.test(this.relationshipCursor.type())) continue;
                int outgoing = 0;
                int incoming = 0;
                int loop = 0;
                if (this.relationshipCursor.sourceNodeReference() == this.entityReference()) {
                    if (this.relationshipCursor.targetNodeReference() == this.entityReference()) {
                        ++loop;
                    } else if (selection.test(RelationshipDirection.OUTGOING)) {
                        ++outgoing;
                    }
                } else if (selection.test(RelationshipDirection.INCOMING)) {
                    ++incoming;
                }
                if (mutator.add(this.relationshipCursor.type(), outgoing, incoming, loop)) continue;
                return;
            }
        } else {
            if (this.groupCursor == null) {
                this.groupCursor = new RecordRelationshipGroupCursor(this.relationshipStore, this.groupStore, this.groupDegreesStore, this.loadMode, this.cursorContext, this.storeCursors, this.memoryTracker);
            }
            this.groupCursor.init(this.entityReference(), this.getNextRel(), this.isDense());
            int criteriaMet = 0;
            boolean typeLimited = selection.isTypeLimited();
            int numCriteria = selection.numberOfCriteria();
            while (this.groupCursor.next()) {
                int type = this.groupCursor.getType();
                if (!selection.test(type)) continue;
                if (!this.groupCursor.degree(mutator, selection)) {
                    return;
                }
                if (!typeLimited || ++criteriaMet < numCriteria) continue;
                break;
            }
        }
    }

    public boolean supportsFastDegreeLookup() {
        return this.isDense();
    }

    public void setForceLoad() {
        this.loadMode = RecordLoadOverride.FORCE;
        if (this.groupCursor != null) {
            this.groupCursor.loadMode = RecordLoadOverride.FORCE;
        }
    }

    public Reference propertiesReference() {
        return LongReference.longReference((long)this.getNextProp());
    }

    public void properties(StoragePropertyCursor propertyCursor, PropertySelection selection) {
        propertyCursor.initNodeProperties(LongReference.longReference((long)this.getNextProp()), selection);
    }

    public boolean next() {
        if (this.next == -1L) {
            this.resetState();
            return false;
        }
        do {
            if (this.nextStoreReference == this.next) {
                this.nodeAdvance(this, this.currentCursor);
                ++this.next;
                ++this.nextStoreReference;
            } else {
                this.node(this, this.next++, this.currentCursor);
                this.nextStoreReference = this.next;
            }
            if (this.next <= this.highMark) continue;
            if (this.isSingle() || this.batched) {
                this.next = -1L;
                return this.inUse();
            }
            this.highMark = this.nodeHighMark();
            if (this.next <= this.highMark) continue;
            this.next = -1L;
            return this.inUse();
        } while (!this.inUse());
        return true;
    }

    public void reset() {
        if (this.open) {
            this.open = false;
            this.resetState();
        }
    }

    private void resetState() {
        this.next = -1L;
        this.setId(-1L);
        this.clear();
        this.loadMode = RecordLoadOverride.none();
        if (this.groupCursor != null) {
            this.groupCursor.loadMode = RecordLoadOverride.none();
        }
    }

    private boolean isSingle() {
        return this.highMark == -1L;
    }

    @Override
    public String toString(Mask mask) {
        if (!this.open) {
            return "RecordNodeCursor[closed state]";
        }
        return "RecordNodeCursor[id=" + this.getId() + ", open state with: highMark=" + this.highMark + ", next=" + this.next + ", underlying record=" + super.toString(mask) + "]";
    }

    public void close() {
        if (this.scanCursor != null) {
            this.scanCursor.close();
            this.scanCursor = null;
        }
        this.singleCursor = null;
        this.currentCursor = null;
        if (this.groupCursor != null) {
            this.groupCursor.close();
            this.groupCursor = null;
        }
        if (this.relationshipCursor != null) {
            this.relationshipCursor.close();
            this.relationshipCursor = null;
        }
        if (this.relationshipScanCursor != null) {
            this.relationshipScanCursor.close();
            this.relationshipScanCursor = null;
        }
    }

    private void selectScanCursor() {
        if (this.scanCursor == null) {
            this.scanCursor = this.read.openPageCursorForReading(0L, this.cursorContext);
        }
        this.currentCursor = this.scanCursor;
    }

    private void selectSingleCursor() {
        if (this.singleCursor == null) {
            this.singleCursor = this.storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR);
        }
        this.currentCursor = this.singleCursor;
    }

    private long nodeHighMark() {
        return this.read.getHighestPossibleIdInUse(this.cursorContext);
    }

    private void node(NodeRecord record, long reference, PageCursor pageCursor) {
        this.read.getRecordByCursor(reference, record, this.loadMode.orElse(RecordLoad.CHECK).lenient(), pageCursor, this.memoryTracker);
    }

    private void nodeAdvance(NodeRecord record, PageCursor pageCursor) {
        this.read.nextRecordByCursor(record, this.loadMode.orElse(RecordLoad.CHECK).lenient(), pageCursor, this.memoryTracker);
    }
}

