/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.function.Supplier;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;

class MultiVersionCountsStoreTransactionApplier
extends TransactionApplier.Adapter {
    private final Supplier<CountsUpdater> updaterSupplier;
    private CountsUpdater countsUpdater;
    private boolean haveUpdates;
    private boolean countsUpdaterClosed;

    MultiVersionCountsStoreTransactionApplier(Supplier<CountsUpdater> updaterSupplier) {
        this.updaterSupplier = updaterSupplier;
    }

    @Override
    public void close() {
        this.closeCountsUpdatersIfOpen();
    }

    private void closeCountsUpdatersIfOpen() {
        if (!this.countsUpdaterClosed) {
            this.countsUpdater().close();
            this.countsUpdaterClosed = true;
        }
    }

    @Override
    public boolean visitNodeCountsCommand(Command.NodeCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater().incrementNodeCount(command.labelId(), command.delta());
        return false;
    }

    private CountsUpdater countsUpdater() {
        if (this.countsUpdater == null) {
            this.countsUpdater = this.updaterSupplier.get();
        }
        return this.countsUpdater;
    }

    @Override
    public boolean visitRelationshipCountsCommand(Command.RelationshipCountsCommand command) {
        this.haveUpdates = true;
        this.countsUpdater().incrementRelationshipCount(command.startLabelId(), command.typeId(), command.endLabelId(), command.delta());
        return false;
    }

    @Override
    public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
        assert (!this.haveUpdates) : "Assumed that a schema transaction wouldn't also contain data commands affecting counts store, but was proven wrong with this transaction";
        this.closeCountsUpdatersIfOpen();
        return false;
    }
}

