/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandReading;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.string.UTF8;
import org.neo4j.util.BitUtils;
import org.neo4j.util.Preconditions;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueWriter;
import org.neo4j.values.storable.Values;

class LogCommandSerializationV4_2
extends LogCommandSerialization {
    static final LogCommandSerializationV4_2 INSTANCE = new LogCommandSerializationV4_2();

    LogCommandSerializationV4_2() {
    }

    public KernelVersion kernelVersion() {
        return KernelVersion.V4_2;
    }

    @Override
    protected Command readNodeCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        NodeRecord before = LogCommandSerializationV4_2.readNodeRecord(id, channel);
        NodeRecord after = LogCommandSerializationV4_2.readNodeRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.NodeCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readRelationshipCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipRecord before = LogCommandSerializationV4_2.readRelationshipRecord(id, channel);
        RelationshipRecord after = LogCommandSerializationV4_2.readRelationshipRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readPropertyCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        PropertyRecord before = LogCommandSerializationV4_2.readPropertyRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyRecord after = LogCommandSerializationV4_2.readPropertyRecord(id, channel);
        if (after == null) {
            return null;
        }
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.PropertyCommand((LogCommandSerialization)this, before, after);
    }

    @Override
    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = LogCommandSerializationV4_2.readRelationshipGroupRecord(id, channel);
        RelationshipGroupRecord after = LogCommandSerializationV4_2.readRelationshipGroupRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipGroupRecord readRelationshipGroupRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        RelationshipGroupRecord before = this.readRelationshipGroupExtendedRecord(id, channel);
        RelationshipGroupRecord after = this.readRelationshipGroupExtendedRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipGroupCommand((LogCommandSerialization)this, before, after);
    }

    private RelationshipGroupRecord readRelationshipGroupExtendedRecord(long id, ReadableChannel channel) throws IOException {
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requireSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        int type = Numbers.unsignedShortToInt((short)channel.getShort());
        type |= Numbers.unsignedByteToInt((byte)channel.get()) << 16;
        long next = channel.getLong();
        long firstOut = channel.getLong();
        long firstIn = channel.getLong();
        long firstLoop = channel.getLong();
        long owningNode = channel.getLong();
        RelationshipGroupRecord record = new RelationshipGroupRecord(id).initialize(inUse, type, firstOut, firstIn, firstLoop, owningNode, next);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        record.setUseFixedReferences(usesFixedReferenceFormat);
        return record;
    }

    @Override
    protected Command readRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        RelationshipTypeTokenRecord before = LogCommandSerializationV4_2.readRelationshipTypeTokenRecord(id, channel);
        RelationshipTypeTokenRecord after = LogCommandSerializationV4_2.readRelationshipTypeTokenRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.RelationshipTypeTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static RelationshipTypeTokenRecord readRelationshipTypeTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        RelationshipTypeTokenRecord record = new RelationshipTypeTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LogCommandSerializationV4_2.readDynamicRecord(channel);
            record.addNameRecord(dr);
        }
        return record;
    }

    @Override
    protected Command readLabelTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        LabelTokenRecord before = LogCommandSerializationV4_2.readLabelTokenRecord(id, channel);
        LabelTokenRecord after = LogCommandSerializationV4_2.readLabelTokenRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.LabelTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static LabelTokenRecord readLabelTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        LabelTokenRecord record = new LabelTokenRecord(id);
        record.setInUse(inUse);
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        int nrTypeRecords = channel.getInt();
        for (int i = 0; i < nrTypeRecords; ++i) {
            DynamicRecord dr = LogCommandSerializationV4_2.readDynamicRecord(channel);
            record.addNameRecord(dr);
        }
        return record;
    }

    @Override
    protected Command readPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        int id = channel.getInt();
        PropertyKeyTokenRecord before = LogCommandSerializationV4_2.readPropertyKeyTokenRecord(id, channel);
        if (before == null) {
            return null;
        }
        PropertyKeyTokenRecord after = LogCommandSerializationV4_2.readPropertyKeyTokenRecord(id, channel);
        if (after == null) {
            return null;
        }
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        return new Command.PropertyKeyTokenCommand((LogCommandSerialization)this, before, after);
    }

    private static PropertyKeyTokenRecord readPropertyKeyTokenRecord(int id, ReadableChannel channel) throws IOException {
        byte headerByte = channel.get();
        boolean inUse = false;
        boolean internal = false;
        if ((headerByte & Record.IN_USE.byteValue()) == Record.IN_USE.byteValue()) {
            inUse = true;
            internal = (headerByte & 0x20) == 32;
        } else if (headerByte != Record.NOT_IN_USE.byteValue()) {
            throw new IOException("Illegal in use flag: " + headerByte);
        }
        PropertyKeyTokenRecord record = new PropertyKeyTokenRecord(id);
        record.setInUse(inUse);
        record.setPropertyCount(channel.getInt());
        record.setNameId(channel.getInt());
        record.setInternal(internal);
        if (LogCommandSerializationV4_2.readDynamicRecords(channel, record, CommandReading.PROPERTY_INDEX_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return record;
    }

    @Override
    protected Command readSchemaRuleCommand(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        byte schemaRulePresence = channel.get();
        boolean hasSchemaRule = schemaRulePresence == 1;
        SchemaRecord before = LogCommandSerializationV4_2.readSchemaRecord(id, channel);
        SchemaRecord after = LogCommandSerializationV4_2.readSchemaRecord(id, channel);
        LogCommandSerializationV4_2.markAfterRecordAsCreatedIfCommandLooksCreated(before, after);
        SchemaRule schemaRule = null;
        if (hasSchemaRule) {
            LogCommandSerializationV4_2.readStringValueMap(channel);
        }
        return new Command.SchemaRuleCommand(this, before, after, schemaRule);
    }

    private static SchemaRecord readSchemaRecord(long id, ReadableChannel channel) throws IOException {
        SchemaRecord schemaRecord = new SchemaRecord(id);
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        if (inUse) {
            schemaRecord.setInUse(inUse);
            if (BitUtils.bitFlag((int)flags, (int)2)) {
                schemaRecord.setCreated();
            }
            schemaRecord.setUseFixedReferences(BitUtils.bitFlag((int)flags, (int)16));
            byte schemaFlags = channel.get();
            schemaRecord.setConstraint(BitUtils.bitFlag((byte)schemaFlags, (byte)1));
            schemaRecord.setNextProp(channel.getLong());
            if (BitUtils.bitFlag((int)flags, (int)8)) {
                schemaRecord.setSecondaryUnitIdOnLoad(channel.getLong());
            }
        } else {
            schemaRecord.clear();
        }
        return schemaRecord;
    }

    static Map<String, Value> readStringValueMap(ReadableChannel channel) throws IOException {
        HashMap<String, Value> map = new HashMap<String, Value>();
        int size = channel.getInt();
        for (int i = 0; i < size; ++i) {
            byte[] keyBytes = LogCommandSerializationV4_2.readMapKeyByteArray(channel);
            String key = UTF8.decode((byte[])keyBytes);
            Value value = LogCommandSerializationV4_2.readMapValue(channel);
            map.put(key, value);
        }
        return map;
    }

    private static byte[] readMapKeyByteArray(ReadableChannel channel) throws IOException {
        int size = channel.getInt();
        byte[] bytes = new byte[size];
        channel.get(bytes, size);
        return bytes;
    }

    private static Value readMapValue(ReadableChannel channel) throws IOException {
        SchemaMapValueType type = SchemaMapValueType.map(channel.get());
        switch (type) {
            case BOOL_LITERAL_TRUE: {
                return Values.booleanValue((boolean)true);
            }
            case BOOL_LITERAL_FALSE: {
                return Values.booleanValue((boolean)false);
            }
            case BOOL_ARRAY_ELEMENT: {
                throw new IOException("Cannot read schema rule map value of type boolean array element as a top-level type.");
            }
            case BYTE: {
                return Values.byteValue((byte)channel.get());
            }
            case SHORT: {
                return Values.shortValue((short)channel.getShort());
            }
            case INT: {
                return Values.intValue((int)channel.getInt());
            }
            case LONG: {
                return Values.longValue((long)channel.getLong());
            }
            case FLOAT: {
                return Values.floatValue((float)channel.getFloat());
            }
            case DOUBLE: {
                return Values.doubleValue((double)channel.getDouble());
            }
            case STRING: {
                int size = channel.getInt();
                byte[] bytes = new byte[size];
                channel.get(bytes, size);
                return Values.utf8Value((byte[])bytes);
            }
            case CHAR: {
                return Values.charValue((char)((char)channel.getInt()));
            }
            case ARRAY: {
                int arraySize = channel.getInt();
                SchemaMapValueType elementType = SchemaMapValueType.map(channel.get());
                switch (elementType) {
                    case BOOL_LITERAL_TRUE: {
                        throw new IOException("BOOL_LITERAL_TRUE cannot be a schema rule map value array element type.");
                    }
                    case BOOL_LITERAL_FALSE: {
                        throw new IOException("BOOL_LITERAL_FALSE cannot be a schema rule map value array element type.");
                    }
                    case BOOL_ARRAY_ELEMENT: {
                        boolean[] array = new boolean[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.get() == SchemaMapValueType.BOOL_LITERAL_TRUE.type();
                        }
                        return Values.booleanArray((boolean[])array);
                    }
                    case BYTE: {
                        byte[] array = new byte[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.get();
                        }
                        return Values.byteArray((byte[])array);
                    }
                    case SHORT: {
                        short[] array = new short[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getShort();
                        }
                        return Values.shortArray((short[])array);
                    }
                    case INT: {
                        int[] array = new int[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getInt();
                        }
                        return Values.intArray((int[])array);
                    }
                    case LONG: {
                        long[] array = new long[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getLong();
                        }
                        return Values.longArray((long[])array);
                    }
                    case FLOAT: {
                        float[] array = new float[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getFloat();
                        }
                        return Values.floatArray((float[])array);
                    }
                    case DOUBLE: {
                        double[] array = new double[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = channel.getDouble();
                        }
                        return Values.doubleArray((double[])array);
                    }
                    case STRING: {
                        String[] array = new String[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            int size = channel.getInt();
                            byte[] bytes = new byte[size];
                            channel.get(bytes, size);
                            array[i] = UTF8.decode((byte[])bytes);
                        }
                        return Values.stringArray((String[])array);
                    }
                    case CHAR: {
                        char[] array = new char[arraySize];
                        for (int i = 0; i < arraySize; ++i) {
                            array[i] = (char)channel.getInt();
                        }
                        return Values.charArray((char[])array);
                    }
                    case ARRAY: {
                        throw new IOException("Nested arrays are not support for schema rule map values.");
                    }
                }
                throw new IOException("Unknown array element type: " + elementType);
            }
        }
        throw new IOException("Unknown schema map value type: " + type);
    }

    private static NodeRecord readNodeRecord(long id, ReadableChannel channel) throws IOException {
        NodeRecord record;
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean isCreated = BitUtils.bitFlag((int)flags, (int)2);
        boolean requiresSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        ArrayList<DynamicRecord> dynamicLabelRecords = new ArrayList<DynamicRecord>();
        long labelField = Record.NO_LABELS_FIELD.intValue();
        if (inUse) {
            boolean dense = channel.get() == 1;
            long nextRel = channel.getLong();
            long nextProp = channel.getLong();
            record = new NodeRecord(id).initialize(false, nextProp, dense, nextRel, 0L);
            labelField = channel.getLong();
            record.setRequiresSecondaryUnit(requiresSecondaryUnit);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong());
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new NodeRecord(id);
        }
        LogCommandSerializationV4_2.readDynamicRecords(channel, dynamicLabelRecords, CommandReading.COLLECTION_DYNAMIC_RECORD_ADDER);
        record.setLabelField(labelField, dynamicLabelRecords);
        record.setInUse(inUse);
        if (isCreated) {
            record.setCreated();
        }
        return record;
    }

    private static RelationshipRecord readRelationshipRecord(long id, ReadableChannel channel) throws IOException {
        RelationshipRecord record;
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean requiresSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        if (inUse) {
            record = new RelationshipRecord(id);
            record.setLinks(channel.getLong(), channel.getLong(), channel.getInt());
            record.setInUse(true);
            record.setRequiresSecondaryUnit(requiresSecondaryUnit);
            record.setFirstPrevRel(channel.getLong());
            record.setFirstNextRel(channel.getLong());
            record.setSecondPrevRel(channel.getLong());
            record.setSecondNextRel(channel.getLong());
            record.setNextProp(channel.getLong());
            byte extraByte = channel.get();
            record.setFirstInFirstChain((extraByte & 1) > 0);
            record.setFirstInSecondChain((extraByte & 2) > 0);
            if (hasSecondaryUnit) {
                record.setSecondaryUnitIdOnLoad(channel.getLong());
            }
            record.setUseFixedReferences(usesFixedReferenceFormat);
        } else {
            record = new RelationshipRecord(id);
            record.setLinks(-1L, -1L, channel.getInt());
            record.setInUse(false);
        }
        if (BitUtils.bitFlag((int)flags, (int)2)) {
            record.setCreated();
        }
        return record;
    }

    private static DynamicRecord readDynamicRecord(ReadableChannel channel) throws IOException {
        long id = channel.getLong();
        assert (id >= 0L && id <= 0xFFFFFFFFFL) : id + " is not a valid dynamic record id";
        int type = channel.getInt();
        byte inUseFlag = channel.get();
        boolean inUse = (inUseFlag & Record.IN_USE.byteValue()) != 0;
        DynamicRecord record = new DynamicRecord(id);
        record.setInUse(inUse, type);
        if (inUse) {
            int nrOfBytes;
            record.setStartRecord((inUseFlag & 0x20) != 0);
            if ((inUseFlag & 2) != 0) {
                record.setCreated();
            }
            Preconditions.checkState(((nrOfBytes = channel.getInt()) >= 0 && nrOfBytes < 0xFFFFFF ? 1 : 0) != 0, (String)(nrOfBytes + " is not valid for a number of bytes field of a dynamic record"));
            long nextBlock = channel.getLong();
            assert (nextBlock >= 0L && nextBlock <= 0x800000000L || nextBlock == (long)Record.NO_NEXT_BLOCK.intValue()) : nextBlock + " is not valid for a next record field of a dynamic record";
            record.setNextBlock(nextBlock);
            byte[] data = new byte[nrOfBytes];
            channel.get(data, nrOfBytes);
            record.setData(data);
        }
        return record;
    }

    private static <T> int readDynamicRecords(ReadableChannel channel, T target, CommandReading.DynamicRecordAdder<T> adder) throws IOException {
        int numberOfRecords;
        assert (numberOfRecords >= 0);
        for (numberOfRecords = channel.getInt(); numberOfRecords > 0; --numberOfRecords) {
            DynamicRecord read = LogCommandSerializationV4_2.readDynamicRecord(channel);
            adder.add(target, read);
        }
        return numberOfRecords;
    }

    private static PropertyRecord readPropertyRecord(long id, ReadableChannel channel) throws IOException {
        PropertyRecord record = new PropertyRecord(id);
        byte flags = channel.get();
        boolean inUse = BitUtils.bitFlag((byte)flags, (byte)Record.IN_USE.byteValue());
        boolean nodeProperty = !BitUtils.bitFlag((byte)flags, (byte)Record.REL_PROPERTY.byteValue());
        boolean requireSecondaryUnit = BitUtils.bitFlag((int)flags, (int)4);
        boolean hasSecondaryUnit = BitUtils.bitFlag((int)flags, (int)8);
        boolean usesFixedReferenceFormat = BitUtils.bitFlag((int)flags, (int)16);
        record.setRequiresSecondaryUnit(requireSecondaryUnit);
        record.setUseFixedReferences(usesFixedReferenceFormat);
        long nextProp = channel.getLong();
        long prevProp = channel.getLong();
        record.setNextProp(nextProp);
        record.setPrevProp(prevProp);
        long primitiveId = channel.getLong();
        if (primitiveId != -1L && nodeProperty) {
            record.setNodeId(primitiveId);
        } else if (primitiveId != -1L) {
            record.setRelId(primitiveId);
        }
        if (hasSecondaryUnit) {
            record.setSecondaryUnitIdOnLoad(channel.getLong());
        }
        int nrPropBlocks = channel.get();
        assert (nrPropBlocks >= 0);
        if (nrPropBlocks > 0) {
            record.setInUse(true);
        }
        while (nrPropBlocks-- > 0) {
            PropertyBlock block = LogCommandSerializationV4_2.readPropertyBlock(channel);
            if (block == null) {
                return null;
            }
            record.addPropertyBlock(block);
        }
        int deletedRecords = LogCommandSerializationV4_2.readDynamicRecords(channel, record, CommandReading.PROPERTY_DELETED_DYNAMIC_RECORD_ADDER);
        if (deletedRecords == -1) {
            return null;
        }
        assert (deletedRecords >= 0);
        while (deletedRecords-- > 0) {
            DynamicRecord read = LogCommandSerializationV4_2.readDynamicRecord(channel);
            record.addDeletedRecord(read);
        }
        if (inUse && !record.inUse() || !inUse && record.inUse()) {
            throw new IllegalStateException("Weird, inUse was read in as " + inUse + " but the record is " + record);
        }
        return record;
    }

    private static PropertyBlock readPropertyBlock(ReadableChannel channel) throws IOException {
        PropertyBlock toReturn = new PropertyBlock();
        byte blockSize = channel.get();
        assert (blockSize > 0 && blockSize % 8 == 0) : blockSize + " is not a valid block size value";
        long[] blocks = LogCommandSerializationV4_2.readLongs(channel, blockSize / 8);
        assert (blocks.length == blockSize / 8) : blocks.length + " longs were read in while i asked for what corresponds to " + blockSize;
        assert (PropertyType.getPropertyTypeOrThrow(blocks[0]).calculateNumberOfBlocksUsed(blocks[0]) == blocks.length) : blocks.length + " is not a valid number of blocks for type " + PropertyType.getPropertyTypeOrThrow(blocks[0]);
        toReturn.setValueBlocks(blocks);
        if (LogCommandSerializationV4_2.readDynamicRecords(channel, toReturn, CommandReading.PROPERTY_BLOCK_DYNAMIC_RECORD_ADDER) == -1) {
            return null;
        }
        return toReturn;
    }

    private static long[] readLongs(ReadableChannel channel, int count) throws IOException {
        long[] result = new long[count];
        for (int i = 0; i < count; ++i) {
            result[i] = channel.getLong();
        }
        return result;
    }

    @Override
    protected Command readNodeCountsCommand(ReadableChannel channel) throws IOException {
        int labelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.NodeCountsCommand(this, labelId, delta);
    }

    @Override
    protected Command readRelationshipCountsCommand(ReadableChannel channel) throws IOException {
        int startLabelId = channel.getInt();
        int typeId = channel.getInt();
        int endLabelId = channel.getInt();
        long delta = channel.getLong();
        return new Command.RelationshipCountsCommand(this, startLabelId, typeId, endLabelId, delta);
    }

    @Override
    protected Command readNeoStoreCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    static void markAfterRecordAsCreatedIfCommandLooksCreated(AbstractBaseRecord before, AbstractBaseRecord after) {
        if (!before.inUse() && after.inUse()) {
            after.setCreated();
        }
        if (!before.hasSecondaryUnitId() && after.hasSecondaryUnitId()) {
            after.setSecondaryUnitIdOnCreate(after.getSecondaryUnitId());
        }
    }

    @Override
    protected Command readLegacySchemaRuleCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexDefineCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexAddNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexAddRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexCreateCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexDeleteCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    @Override
    protected Command readIndexRemoveCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    static enum SchemaMapValueType {
        BOOL_LITERAL_TRUE,
        BOOL_LITERAL_FALSE,
        BOOL_ARRAY_ELEMENT,
        BYTE,
        SHORT,
        INT,
        LONG,
        FLOAT,
        DOUBLE,
        STRING,
        CHAR,
        ARRAY;

        private static final SchemaMapValueType[] TYPE_ID_TO_ENUM;

        public static SchemaMapValueType map(byte type) {
            return TYPE_ID_TO_ENUM[type];
        }

        public static SchemaMapValueType map(ValueWriter.ArrayType arrayType) throws IOException {
            switch (arrayType) {
                case BYTE: {
                    return BYTE;
                }
                case SHORT: {
                    return SHORT;
                }
                case INT: {
                    return INT;
                }
                case LONG: {
                    return LONG;
                }
                case FLOAT: {
                    return FLOAT;
                }
                case DOUBLE: {
                    return DOUBLE;
                }
                case BOOLEAN: {
                    return BOOL_ARRAY_ELEMENT;
                }
                case STRING: {
                    return STRING;
                }
                case CHAR: {
                    return CHAR;
                }
            }
            throw new IOException("Unsupported schema record map value type: " + arrayType);
        }

        public byte type() {
            return (byte)this.ordinal();
        }

        static {
            TYPE_ID_TO_ENUM = SchemaMapValueType.values();
        }
    }
}

