/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandSelector;
import org.neo4j.internal.recordstorage.IndexActivator;
import org.neo4j.internal.recordstorage.IndexUpdatesExtractor;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class IndexTransactionApplierFactory
implements TransactionApplierFactory {
    private final TransactionApplicationMode mode;
    private final IndexUpdateListener indexUpdateListener;

    public IndexTransactionApplierFactory(TransactionApplicationMode mode, IndexUpdateListener indexUpdateListener) {
        this.mode = mode;
        this.indexUpdateListener = indexUpdateListener;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction commands, BatchContext batchContext) {
        return new SingleTransactionApplier(commands, batchContext, this.mode.isReverseStep() ? CommandSelector.REVERSE : CommandSelector.NORMAL);
    }

    private class SingleTransactionApplier
    extends TransactionApplier.Adapter {
        private final Subject subject;
        private final IndexUpdatesExtractor indexUpdatesExtractor;
        private List<IndexDescriptor> createdIndexes;
        private final IndexActivator indexActivator;
        private final BatchContext batchContext;
        private final CommandSelector commandSelector;

        SingleTransactionApplier(StorageEngineTransaction commands, BatchContext batchContext, CommandSelector commandSelector) {
            this.subject = commands.subject();
            this.indexActivator = batchContext.getIndexActivator();
            this.batchContext = batchContext;
            this.commandSelector = commandSelector;
            this.indexUpdatesExtractor = new IndexUpdatesExtractor(commandSelector);
        }

        @Override
        public void close() {
            if (this.indexUpdatesExtractor.containsAnyEntityOrPropertyUpdate()) {
                this.batchContext.indexUpdates().feed(this.indexUpdatesExtractor.getNodeCommands(), this.indexUpdatesExtractor.getRelationshipCommands(), this.commandSelector);
                this.indexUpdatesExtractor.close();
            }
            if (this.createdIndexes != null) {
                IndexTransactionApplierFactory.this.indexUpdateListener.createIndexes(this.subject, this.createdIndexes.toArray(new IndexDescriptor[0]));
                this.createdIndexes = null;
            }
        }

        @Override
        public boolean visitNodeCommand(Command.NodeCommand command) {
            return this.indexUpdatesExtractor.visitNodeCommand(command);
        }

        @Override
        public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
            return this.indexUpdatesExtractor.visitRelationshipCommand(command);
        }

        @Override
        public boolean visitPropertyCommand(Command.PropertyCommand command) {
            return this.indexUpdatesExtractor.visitPropertyCommand(command);
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) throws IOException {
            SchemaRule schemaRule = command.getSchemaRule();
            this.processSchemaCommand(command.getMode(), schemaRule);
            return false;
        }

        private void processSchemaCommand(Command.Mode commandMode, SchemaRule schemaRule) throws IOException {
            if (schemaRule instanceof IndexDescriptor) {
                IndexDescriptor indexDescriptor = (IndexDescriptor)schemaRule;
                this.batchContext.applyPendingIndexUpdates();
                switch (commandMode) {
                    case UPDATE: {
                        if (!indexDescriptor.isUnique()) break;
                        this.indexActivator.activateIndex(indexDescriptor);
                        break;
                    }
                    case CREATE: {
                        this.createdIndexes = this.createdIndexes == null ? new ArrayList() : this.createdIndexes;
                        this.createdIndexes.add(indexDescriptor);
                        break;
                    }
                    case DELETE: {
                        IndexTransactionApplierFactory.this.indexUpdateListener.dropIndex(indexDescriptor);
                        this.indexActivator.indexDropped(indexDescriptor);
                    }
                }
            }
        }
    }
}

