/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.CommandSelector;
import org.neo4j.internal.recordstorage.IndexActivator;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.indexcommand.TokenIndexUpdateCommand;
import org.neo4j.internal.recordstorage.indexcommand.ValueIndexUpdateCommand;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.util.IndexUpdatesWorkSync;
import org.neo4j.values.storable.Value;

public class IndexCommandTransactionApplierFactory
implements TransactionApplierFactory {
    private final IndexUpdateListener indexUpdateListener;
    private final SchemaCache schemaCache;
    private final TransactionApplicationMode mode;
    private final IndexUpdatesWorkSync indexUpdatesSync;

    public IndexCommandTransactionApplierFactory(IndexUpdateListener indexUpdateListener, IndexUpdatesWorkSync indexUpdatesSync, SchemaCache schemaCache, TransactionApplicationMode mode) {
        this.indexUpdateListener = indexUpdateListener;
        this.indexUpdatesSync = indexUpdatesSync;
        this.schemaCache = schemaCache;
        this.mode = mode;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction transaction, BatchContext batchContext) {
        CommandSelector commandSelector = this.mode.isReverseStep() ? CommandSelector.REVERSE : CommandSelector.NORMAL;
        return new SingleTransactionApplier(transaction, batchContext, transaction.cursorContext(), commandSelector);
    }

    private class SingleTransactionApplier
    extends TransactionApplier.Adapter {
        private final Subject subject;
        private List<IndexDescriptor> createdIndexes;
        private final IndexActivator indexActivator;
        private final CursorContext cursorContext;
        private final CommandSelector commandSelector;
        private final List<IndexEntryUpdate<IndexDescriptor>> indexUpdates = new ArrayList<IndexEntryUpdate<IndexDescriptor>>();

        SingleTransactionApplier(StorageEngineTransaction transaction, BatchContext batchContext, CursorContext cursorContext, CommandSelector commandSelector) {
            this.subject = transaction.subject();
            this.indexActivator = batchContext.getIndexActivator();
            this.cursorContext = cursorContext;
            this.commandSelector = commandSelector;
        }

        @Override
        public void close() throws IOException {
            if (!this.indexUpdates.isEmpty()) {
                try (IndexUpdatesWorkSync.Batch indexUpdatesBatch = IndexCommandTransactionApplierFactory.this.indexUpdatesSync.newBatch(this.cursorContext);){
                    indexUpdatesBatch.indexUpdates(this.indexUpdates);
                    indexUpdatesBatch.applyAsync();
                }
            }
            if (this.createdIndexes != null) {
                IndexCommandTransactionApplierFactory.this.indexUpdateListener.createIndexes(this.subject, this.createdIndexes.toArray(new IndexDescriptor[0]));
                this.createdIndexes = null;
            }
        }

        @Override
        public boolean visitIndexUpdateCommand(IndexUpdateCommand command) {
            IndexDescriptor index = IndexCommandTransactionApplierFactory.this.schemaCache.getIndex(command.getIndexId());
            if (index == null) {
                return false;
            }
            if (command instanceof TokenIndexUpdateCommand) {
                TokenIndexUpdateCommand idxCommand = (TokenIndexUpdateCommand)command;
                TokenIndexEntryUpdate indexUpdate = IndexEntryUpdate.change((long)idxCommand.getEntityId(), (SchemaDescriptorSupplier)index, (int[])this.commandSelector.getBefore(idxCommand), (int[])this.commandSelector.getAfter(idxCommand));
                this.indexUpdates.add((IndexEntryUpdate<IndexDescriptor>)indexUpdate);
            } else {
                ValueIndexUpdateCommand idxCommand = (ValueIndexUpdateCommand)command;
                switch (this.commandSelector.mode(idxCommand)) {
                    case ADDED: {
                        this.indexUpdates.add((IndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.add((long)idxCommand.getEntityId(), (SchemaDescriptorSupplier)index, (Value[])idxCommand.getAfter()));
                        break;
                    }
                    case CHANGED: {
                        this.indexUpdates.add((IndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.change((long)idxCommand.getEntityId(), (SchemaDescriptorSupplier)index, (Value[])this.commandSelector.getBefore(idxCommand), (Value[])this.commandSelector.getAfter(idxCommand)));
                        break;
                    }
                    case REMOVED: {
                        this.indexUpdates.add((IndexEntryUpdate<IndexDescriptor>)IndexEntryUpdate.remove((long)idxCommand.getEntityId(), (SchemaDescriptorSupplier)index, (Value[])idxCommand.getAfter()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            return false;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
            SchemaRule schemaRule = command.getSchemaRule();
            this.processSchemaCommand(command.getMode(), schemaRule);
            return false;
        }

        private void processSchemaCommand(Command.Mode commandMode, SchemaRule schemaRule) {
            if (schemaRule instanceof IndexDescriptor) {
                IndexDescriptor indexRule = (IndexDescriptor)schemaRule;
                switch (commandMode) {
                    case UPDATE: {
                        if (!indexRule.isUnique()) break;
                        this.indexActivator.activateIndex(indexRule);
                        break;
                    }
                    case CREATE: {
                        this.createdIndexes = this.createdIndexes == null ? new ArrayList() : this.createdIndexes;
                        this.createdIndexes.add(indexRule);
                        break;
                    }
                    case DELETE: {
                        IndexCommandTransactionApplierFactory.this.indexUpdateListener.dropIndex(indexRule);
                        this.indexActivator.indexDropped(indexRule);
                        break;
                    }
                    default: {
                        throw new IllegalStateException(commandMode.name());
                    }
                }
            }
        }
    }
}

