/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.input.LenientStoreInput;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;

public abstract class LenientStoreInputChunk
implements InputChunk {
    private static final String COPY_STORE_READER_TAG = "copyStoreReader";
    private final PropertyStore propertyStore;
    private final StoreCursors storeCursors;
    private long id;
    private long endId;
    protected final ReadBehaviour readBehaviour;
    protected final TokenHolders tokenHolders;
    protected final PageCursor cursor;
    protected final Group group;
    private final CursorContext cursorContext;
    private final MutableLongSet seenPropertyRecordIds = LongSets.mutable.empty();
    private final MutableIntSet seenPropertyKeyIds = IntSets.mutable.empty();
    private final PageCursor propertyCursor;
    private final PropertyRecord propertyRecord;
    private final MemoryTracker memoryTracker;

    LenientStoreInputChunk(ReadBehaviour readBehaviour, PropertyStore propertyStore, TokenHolders tokenHolders, CursorContextFactory contextFactory, StoreCursors storeCursors, PageCursor cursor, Group group, MemoryTracker memoryTracker) {
        this.readBehaviour = readBehaviour;
        this.propertyStore = propertyStore;
        this.tokenHolders = tokenHolders;
        this.cursorContext = contextFactory.create(COPY_STORE_READER_TAG);
        this.storeCursors = storeCursors;
        this.cursor = cursor;
        this.propertyCursor = storeCursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR);
        this.propertyRecord = propertyStore.newRecord();
        this.group = group;
        this.memoryTracker = memoryTracker;
    }

    void setChunkRange(long startId, long endId) {
        this.id = startId;
        this.endId = endId;
    }

    public boolean next(InputEntityVisitor visitor) {
        if (this.id < this.endId) {
            try {
                this.readAndVisit(this.id, visitor, this.storeCursors, this.memoryTracker);
            }
            catch (Exception e) {
                this.readBehaviour.removed();
                this.readBehaviour.error((Throwable)e, "%s(%d): Ignoring broken record.", new Object[]{this.recordType(), this.id});
            }
            ++this.id;
            return true;
        }
        return false;
    }

    public void close() {
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.storeCursors, this.cursorContext});
    }

    abstract void readAndVisit(long var1, InputEntityVisitor var3, StoreCursors var4, MemoryTracker var5) throws IOException;

    abstract String recordType();

    abstract boolean shouldIncludeProperty(ReadBehaviour var1, String var2, String[] var3);

    void visitPropertyChainNoThrow(InputEntityVisitor visitor, PrimitiveRecord record, EntityType owningEntityType, String[] owningEntityTokens, MemoryTracker memoryTracker) {
        try {
            if (record.getNextProp() == (long)Record.NO_NEXT_PROPERTY.intValue()) {
                return;
            }
            this.seenPropertyRecordIds.clear();
            this.seenPropertyKeyIds.clear();
            long prevProp = Record.NO_PREVIOUS_PROPERTY.intValue();
            long nextProp = record.getNextProp();
            while (!Record.NO_NEXT_PROPERTY.is(nextProp)) {
                if (!this.seenPropertyRecordIds.add(nextProp)) {
                    this.readBehaviour.error("%s(%d): Ignoring circular property chain %s.", new Object[]{owningEntityType, record.getId(), this.propertyRecord});
                    return;
                }
                this.propertyStore.getRecordByCursor(nextProp, this.propertyRecord, RecordLoad.NORMAL, this.propertyCursor, memoryTracker);
                if (this.propertyRecord.getPrevProp() != prevProp) {
                    this.readBehaviour.error("%s(%d): Ignoring broken property chain.", new Object[]{owningEntityType, record.getId()});
                    return;
                }
                prevProp = this.propertyRecord.getId();
                for (PropertyBlock propBlock : this.propertyRecord.propertyBlocks()) {
                    this.propertyStore.ensureHeavy(propBlock, this.storeCursors, memoryTracker);
                    String key = LenientStoreInput.getTokenByIdSafe(this.tokenHolders.propertyKeyTokens(), propBlock.getKeyIndexId()).name();
                    if (!this.shouldIncludeProperty(this.readBehaviour, key, owningEntityTokens)) continue;
                    Value propertyValue = propBlock.newPropertyValue(this.propertyStore, this.storeCursors, memoryTracker);
                    if (!this.seenPropertyKeyIds.add(propBlock.getKeyIndexId())) {
                        this.readBehaviour.error("%s(%d): Discarding duplicate property key %s(%d)=%s.", new Object[]{owningEntityType, record.getId(), key, propBlock.getKeyIndexId(), propertyValue});
                        continue;
                    }
                    visitor.property(key, propertyValue.asObject());
                }
                nextProp = this.propertyRecord.getNextProp();
            }
        }
        catch (Exception e) {
            this.readBehaviour.error((Throwable)e, "%s(%d): Ignoring broken property chain.", new Object[]{owningEntityType, record.getId()});
        }
    }
}

