/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Collection;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.LongFunction;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.IoThroughputStat;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.Key;
import org.neo4j.internal.batchimport.stats.Keys;
import org.neo4j.internal.batchimport.stats.Stat;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.internal.id.IdValidator;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;

public class UpdateRecordsStep<RECORD extends AbstractBaseRecord>
extends ProcessorStep<RECORD[]>
implements StatsProvider {
    protected final RecordStore<RECORD> store;
    private final int recordSize;
    private final Function<CursorContext, StoreCursors> storeCursorsCreator;
    private final CursorType cursorType;
    private final PrepareIdSequence prepareIdSequence;
    private final LongAdder recordsUpdated = new LongAdder();

    public UpdateRecordsStep(StageControl control, Configuration config, RecordStore<RECORD> store, PrepareIdSequence prepareIdSequence, CursorContextFactory contextFactory, Function<CursorContext, StoreCursors> storeCursorsCreator, CursorType cursorType) {
        super(control, "v", config, config.parallelRecordWrites() ? 0 : 1, contextFactory, new StatsProvider[0]);
        this.store = store;
        this.prepareIdSequence = prepareIdSequence;
        this.recordSize = store.getRecordSize();
        this.storeCursorsCreator = storeCursorsCreator;
        this.cursorType = cursorType;
    }

    protected void process(RECORD[] batch, BatchSender sender, CursorContext cursorContext, MemoryTracker memoryTracker) {
        LongFunction idSequence = (LongFunction)this.prepareIdSequence.apply(this.store.getIdGenerator());
        int recordsUpdatedInThisBatch = 0;
        try (StoreCursors storeCursors = this.storeCursorsCreator.apply(cursorContext);
             PageCursor cursor = storeCursors.writeCursor(this.cursorType);){
            for (RECORD record : batch) {
                if (record == null || !((AbstractBaseRecord)record).inUse() || IdValidator.isReservedId((long)((AbstractBaseRecord)record).getId())) continue;
                this.store.prepareForCommit(record, (IdSequence)idSequence.apply(((AbstractBaseRecord)record).getId()), cursorContext);
                this.store.updateRecord(record, IdUpdateListener.IGNORE, cursor, cursorContext, storeCursors);
                ++recordsUpdatedInThisBatch;
            }
        }
        this.recordsUpdated.add(recordsUpdatedInThisBatch);
    }

    protected void collectStatsProviders(Collection<StatsProvider> into) {
        super.collectStatsProviders(into);
        into.add(this);
    }

    public Stat stat(Key key) {
        return key == Keys.io_throughput ? new IoThroughputStat(this.startTime, this.endTime, (long)this.recordSize * this.recordsUpdated.sum()) : null;
    }

    public Key[] keys() {
        return new Keys[]{Keys.io_throughput};
    }
}

