/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.batchimport.ProcessRelationshipCountsDataStep;
import org.neo4j.internal.batchimport.RecordIdIterators;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipCountsStage
extends Stage {
    public static final String NAME = "Relationship counts";

    public RelationshipCountsStage(Configuration config, NodeLabelsCache cache, RelationshipStore relationshipStore, int highLabelId, int highRelationshipTypeId, CountsUpdater countsUpdater, NumberArrayFactory cacheFactory, ProgressListener progressListener, CursorContextFactory contextFactory, Function<CursorContext, StoreCursors> storeCursorsCreator, MemoryTracker memoryTracker) {
        super(NAME, null, config, 2);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterators.allIn(relationshipStore, config), relationshipStore.getRecordSize()));
        this.add((Step)new ReadRecordsStep<RelationshipRecord>(this.control(), config, false, relationshipStore, contextFactory));
        this.add((Step)new ProcessRelationshipCountsDataStep(this.control(), cache, config, highLabelId, highRelationshipTypeId, countsUpdater, cacheFactory, progressListener, contextFactory, storeCursorsCreator, memoryTracker));
    }
}

