/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Supplier;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

class NodeInputIdPropertyLookup
implements PropertyValueLookup {
    private final PropertyStore propertyStore;
    private final Supplier<StoreCursors> storeCursors;

    NodeInputIdPropertyLookup(PropertyStore propertyStore, Supplier<StoreCursors> storeCursors) {
        this.propertyStore = propertyStore;
        this.storeCursors = storeCursors;
    }

    public PropertyValueLookup.Lookup newLookup() {
        final StoreCursors cursors = this.storeCursors.get();
        final PropertyRecord propertyRecord = this.propertyStore.newRecord();
        return new PropertyValueLookup.Lookup(){

            public Object lookupProperty(long nodeId, MemoryTracker memoryTracker) {
                NodeInputIdPropertyLookup.this.propertyStore.getRecordByCursor(nodeId, propertyRecord, RecordLoad.CHECK, cursors.readCursor((CursorType)RecordCursorTypes.PROPERTY_CURSOR), memoryTracker);
                if (!propertyRecord.inUse()) {
                    return null;
                }
                return ((PropertyBlock)Iterables.first(propertyRecord.propertyBlocks())).newPropertyValue(NodeInputIdPropertyLookup.this.propertyStore, cursors, memoryTracker).asObject();
            }

            public void close() {
                cursors.close();
            }
        };
    }
}

