/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.batchimport.NodeCountsProcessor;
import org.neo4j.internal.batchimport.RecordIdIterators;
import org.neo4j.internal.batchimport.RecordProcessorStep;
import org.neo4j.internal.batchimport.cache.NodeLabelsCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeCountsStage
extends Stage {
    public static final String NAME = "Node counts";

    public NodeCountsStage(Configuration config, NodeLabelsCache cache, NodeStore nodeStore, int highLabelId, CountsUpdater countsUpdater, ProgressListener progressListener, CursorContextFactory contextFactory, Function<CursorContext, StoreCursors> storeCursorsCreator, StatsProvider ... additionalStatsProviders) {
        super(NAME, null, config, 2);
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterators.allIn(nodeStore, config), nodeStore.getRecordSize()));
        this.add((Step)new ReadRecordsStep<NodeRecord>(this.control(), config, false, nodeStore, contextFactory));
        this.add((Step)new RecordProcessorStep(this.control(), "COUNT", config, () -> new NodeCountsProcessor(nodeStore, cache, highLabelId, 0L, countsUpdater, progressListener), true, 0, contextFactory, storeCursorsCreator, additionalStatsProviders));
    }
}

