/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.staging.LonelyProcessingStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.helpers.progress.Indicator;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

public class IdMapperPreparationStep
extends LonelyProcessingStep {
    private final IdMapper idMapper;
    private final PropertyValueLookup allIds;
    private final Collector collector;

    public IdMapperPreparationStep(StageControl control, Configuration config, IdMapper idMapper, PropertyValueLookup allIds, Collector collector, StatsProvider ... additionalStatsProviders) {
        super(control, "", config, additionalStatsProviders);
        this.idMapper = idMapper;
        this.allIds = allIds;
        this.collector = collector;
    }

    protected void process() {
        this.idMapper.prepare(this.allIds, this.collector, new ProgressMonitorFactory(){
            private long totalCount;

            protected Indicator newIndicator(String process) {
                final int reportResolution = 100;
                return new Indicator(reportResolution){

                    protected void progress(int from, int to) {
                        int steps = to - from;
                        IdMapperPreparationStep.this.progress((long)((double)totalCount * ((double)steps / (double)reportResolution)));
                    }
                };
            }

            public ProgressListener singlePart(String process, long totalCount) {
                this.totalCount = totalCount;
                return super.singlePart(process, totalCount);
            }
        });
    }
}

