/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.LongSupplier;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.internal.batchimport.ImportMemoryCalculator;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.io.os.OsBeanUtil;
import org.neo4j.kernel.impl.store.format.RecordFormats;

class HeapSizeSanityChecker {
    private final Monitor monitor;
    private final LongSupplier freeMemoryLookup;
    private final LongSupplier actualHeapSizeLookup;

    HeapSizeSanityChecker(Monitor monitor) {
        this(monitor, OsBeanUtil::getFreePhysicalMemory, Runtime.getRuntime()::maxMemory);
    }

    HeapSizeSanityChecker(Monitor monitor, LongSupplier freeMemoryLookup, LongSupplier actualHeapSizeLookup) {
        this.monitor = monitor;
        this.freeMemoryLookup = freeMemoryLookup;
        this.actualHeapSizeLookup = actualHeapSizeLookup;
    }

    void sanityCheck(Input.Estimates inputEstimates, RecordFormats recordFormats, MemoryStatsVisitor.Visitable baseMemory, MemoryStatsVisitor.Visitable ... memoryVisitables) {
        boolean freeMemoryIsKnown;
        long estimatedCacheSize = ImportMemoryCalculator.estimatedCacheSize(baseMemory, memoryVisitables);
        long freeMemory = this.freeMemoryLookup.getAsLong();
        long optimalMinimalHeapSize = ImportMemoryCalculator.optimalMinimalHeapSize(inputEstimates, recordFormats);
        long actualHeapSize = this.actualHeapSizeLookup.getAsLong();
        boolean bl = freeMemoryIsKnown = freeMemory != -1L;
        if (freeMemoryIsKnown && actualHeapSize + freeMemory < estimatedCacheSize + optimalMinimalHeapSize) {
            this.monitor.insufficientAvailableMemory(estimatedCacheSize, optimalMinimalHeapSize, freeMemory);
            return;
        }
        if (actualHeapSize < optimalMinimalHeapSize) {
            this.monitor.insufficientHeapSize(optimalMinimalHeapSize, actualHeapSize);
            return;
        }
        if ((!freeMemoryIsKnown || freeMemory < estimatedCacheSize) && (double)actualHeapSize > (double)optimalMinimalHeapSize * 1.2) {
            this.monitor.abundantHeapSize(optimalMinimalHeapSize, actualHeapSize);
        }
    }
}

