/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.staging.LonelyProcessingStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class DeleteViolatingRelationshipsStep
extends LonelyProcessingStep {
    private static final String DELETE_VIOLATING_IMPORT_STEP_TAG = "deleteViolatingRelationshipsImportStep";
    private final RelationshipStore relStore;
    private final PropertyStore propertyStore;
    private final LongIterator relIds;
    private final DataImporter.Monitor storeMonitor;
    private final DataStatistics.Client client;
    private final CursorContextFactory contextFactory;
    private final NeoStores neoStores;
    private long relsRemoved;
    private long propertiesRemoved;

    public DeleteViolatingRelationshipsStep(StageControl control, Configuration config, LongIterator relIds, NeoStores neoStores, DataImporter.Monitor storeMonitor, DataStatistics.Client client, CursorContextFactory contextFactory) {
        super(control, "DELETE", config, new StatsProvider[0]);
        this.neoStores = neoStores;
        this.relStore = neoStores.getRelationshipStore();
        this.propertyStore = neoStores.getPropertyStore();
        this.relIds = relIds;
        this.storeMonitor = storeMonitor;
        this.client = client;
        this.contextFactory = contextFactory;
    }

    protected void process() {
        RelationshipRecord relRecord = (RelationshipRecord)this.relStore.newRecord();
        PropertyRecord propertyRecord = this.propertyStore.newRecord();
        try (CursorContext cursorContext = this.contextFactory.create(DELETE_VIOLATING_IMPORT_STEP_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);
             EmptyMemoryTracker memoryTracker = EmptyMemoryTracker.INSTANCE;){
            while (this.relIds.hasNext()) {
                long violatingRelId = this.relIds.next();
                this.relStore.getRecordByCursor(violatingRelId, relRecord, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.RELATIONSHIP_CURSOR), (MemoryTracker)memoryTracker);
                assert (relRecord.inUse()) : relRecord;
                long nextProp = relRecord.getNextProp();
                while (!Record.NULL_REFERENCE.is(nextProp)) {
                    this.propertyStore.getRecordByCursor(nextProp, propertyRecord, RecordLoad.NORMAL, storeCursors.readCursor(RecordCursorTypes.PROPERTY_CURSOR), (MemoryTracker)memoryTracker);
                    assert (propertyRecord.inUse()) : propertyRecord + " for " + relRecord;
                    this.propertyStore.ensureHeavy(propertyRecord, (StoreCursors)storeCursors, (MemoryTracker)memoryTracker);
                    this.propertiesRemoved += (long)propertyRecord.numberOfProperties();
                    nextProp = propertyRecord.getNextProp();
                    DeleteViolatingRelationshipsStep.deletePropertyRecordIncludingValueRecords(propertyRecord);
                    PageCursor propertyWriteCursor = storeCursors.writeCursor(RecordCursorTypes.PROPERTY_CURSOR);
                    try {
                        this.propertyStore.updateRecord(propertyRecord, propertyWriteCursor, cursorContext, (StoreCursors)storeCursors);
                    }
                    finally {
                        if (propertyWriteCursor == null) continue;
                        propertyWriteCursor.close();
                    }
                }
                relRecord.setInUse(false);
                this.client.increment(relRecord.getType(), -1);
                try (PageCursor relWriteCursor = storeCursors.writeCursor(RecordCursorTypes.RELATIONSHIP_CURSOR);){
                    this.relStore.updateRecord(relRecord, relWriteCursor, cursorContext, (StoreCursors)storeCursors);
                }
                ++this.relsRemoved;
            }
        }
    }

    private static void deletePropertyRecordIncludingValueRecords(PropertyRecord record) {
        for (PropertyBlock block : record.propertyBlocks()) {
            for (DynamicRecord valueRecord : block.getValueRecords()) {
                assert (valueRecord.inUse());
                valueRecord.setInUse(false);
                record.addDeletedRecord(valueRecord);
            }
        }
        record.clearPropertyBlocks();
        record.setInUse(false);
    }

    public void close() throws Exception {
        super.close();
        this.storeMonitor.relationshipsRemoved(this.relsRemoved);
        this.storeMonitor.propertiesRemoved(this.propertiesRemoved);
    }
}

