/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.report;

import java.util.function.Function;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.report.InconsistencyLogger;
import org.neo4j.internal.helpers.Strings;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.logging.InternalLog;

public class InconsistencyMessageLogger
implements InconsistencyLogger {
    private final InternalLog log;
    private final Function<AbstractBaseRecord, String> recordToStringFunction;

    public InconsistencyMessageLogger(InternalLog log) {
        this(log, AbstractBaseRecord::toString);
    }

    public InconsistencyMessageLogger(InternalLog log, Function<AbstractBaseRecord, String> recordToStringFunction) {
        this.log = log;
        this.recordToStringFunction = recordToStringFunction;
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log.error(this.buildMessage(message, record, args));
    }

    @Override
    public void error(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log.error(this.buildMessage(message, oldRecord, newRecord, args));
    }

    @Override
    public void error(String message) {
        this.log.error(this.buildMessage(message));
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord record, String message, Object ... args) {
        this.log.warn(this.buildMessage(message, record, args));
    }

    @Override
    public void warning(RecordType recordType, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, String message, Object ... args) {
        this.log.warn(this.buildMessage(message, oldRecord, newRecord, args));
    }

    @Override
    public void warning(String message) {
        this.log.warn(this.buildMessage(message));
    }

    private String buildMessage(String message) {
        StringBuilder builder = InconsistencyMessageLogger.tabAfterLinebreak(message);
        return builder.toString();
    }

    private String buildMessage(String message, AbstractBaseRecord record, Object ... args) {
        StringBuilder builder = InconsistencyMessageLogger.joinLines(message).append(System.lineSeparator()).append("\t").append(this.safeToString(record));
        this.appendArgs(builder, args);
        return builder.toString();
    }

    private String safeToString(AbstractBaseRecord record) {
        try {
            return this.recordToStringFunction.apply(record);
        }
        catch (Exception e) {
            return String.format("%s[%d,Error generating toString: %s]", record.getClass().getSimpleName(), record.getId(), e);
        }
    }

    private String buildMessage(String message, AbstractBaseRecord oldRecord, AbstractBaseRecord newRecord, Object ... args) {
        StringBuilder builder = InconsistencyMessageLogger.joinLines(message);
        builder.append(System.lineSeparator()).append("\t").append("- ").append(oldRecord);
        builder.append(System.lineSeparator()).append("\t").append("+ ").append(newRecord);
        this.appendArgs(builder, args);
        return builder.toString();
    }

    private static StringBuilder tabAfterLinebreak(String message) {
        String[] lines = message.split("\n");
        StringBuilder builder = new StringBuilder(lines[0].trim());
        for (int i = 1; i < lines.length; ++i) {
            builder.append(System.lineSeparator()).append("\t").append(lines[i].trim());
        }
        return builder;
    }

    private static StringBuilder joinLines(String message) {
        String[] lines = message.split("\n");
        StringBuilder builder = new StringBuilder(lines[0].trim());
        for (int i = 1; i < lines.length; ++i) {
            builder.append(' ').append(lines[i].trim());
        }
        return builder;
    }

    private void appendArgs(StringBuilder builder, Object[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        builder.append(System.lineSeparator()).append("\t").append("Inconsistent with:");
        for (Object arg : args) {
            builder.append(' ');
            String argToString = arg instanceof AbstractBaseRecord ? this.recordToStringFunction.apply((AbstractBaseRecord)arg) : Strings.prettyPrint((Object)arg);
            builder.append(argToString);
        }
    }
}

