/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.IndexChecker;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipIndexChecker
extends IndexChecker<RelationshipRecord> {
    public RelationshipIndexChecker(CheckerContext context) {
        super(context, EntityType.RELATIONSHIP, "Relationship");
    }

    @Override
    public boolean isNodeBasedCheck() {
        return false;
    }

    @Override
    CommonAbstractStore<RelationshipRecord, ?> store() {
        return this.context.neoStores.getRelationshipStore();
    }

    @Override
    long highId() {
        return this.context.highRelationshipId;
    }

    @Override
    RelationshipRecord getEntity(StoreCursors storeCursors, long entityId) {
        return this.context.recordLoader.relationship(entityId, storeCursors, this.context.memoryTracker);
    }

    @Override
    int[] getEntityTokens(CheckerContext context, StoreCursors storeCursors, RelationshipRecord record, RecordReader<DynamicRecord> additionalReader) {
        return new int[]{record.getType()};
    }

    @Override
    RecordReader<DynamicRecord> additionalEntityTokenReader(CursorContext cursorContext) {
        return null;
    }

    @Override
    void reportEntityNotInUse(ConsistencyReport.IndexConsistencyReport report, RelationshipRecord record) {
        report.relationshipNotInUse(record);
    }

    @Override
    void reportIndexedIncorrectValues(ConsistencyReport.IndexConsistencyReport report, RelationshipRecord record, Object[] propertyValues) {
        report.relationshipIndexedWithWrongValues(record, propertyValues);
    }

    @Override
    void reportIndexedWhenShouldNot(ConsistencyReport.IndexConsistencyReport report, RelationshipRecord record) {
        report.relationshipIndexedWhenShouldNot(record);
    }

    @Override
    ConsistencyReport.PrimitiveConsistencyReport getReport(RelationshipRecord cursor, ConsistencyReport.Reporter reporter) {
        return reporter.forRelationship(cursor);
    }
}

