/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;

class RecordReader<RECORD extends AbstractBaseRecord>
implements AutoCloseable {
    private final CommonAbstractStore<RECORD, ?> store;
    private final RECORD record;
    private final PageCursor cursor;
    private final MemoryTracker memoryTracker;

    RecordReader(CommonAbstractStore<RECORD, ?> store, boolean prefetch, CursorContext cursorContext, MemoryTracker memoryTracker) {
        this.store = store;
        this.record = store.newRecord();
        this.memoryTracker = memoryTracker;
        this.cursor = prefetch ? store.openPageCursorForReadingWithPrefetching(0L, cursorContext) : store.openPageCursorForReading(0L, cursorContext);
    }

    RECORD read(long id) {
        this.store.getRecordByCursor(id, this.record, RecordLoad.FORCE, this.cursor, this.memoryTracker);
        return this.record;
    }

    @Override
    public void close() {
        this.cursor.close();
    }

    RECORD record() {
        return this.record;
    }

    <STORE> STORE store() {
        return (STORE)this.store;
    }
}

