/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntConsumer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.EntityTokenIndexCheckState;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.checker.SchemaComplianceChecker;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.synthetic.IndexEntry;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;

class NodeChecker
implements Checker {
    private static final String NODE_INDEXES_CHECKER_TAG = "nodeIndexesChecker";
    private static final String NODE_RANGE_CHECKER_TAG = "nodeRangeChecker";
    private final IntObjectMap<? extends IntSet> mandatoryProperties;
    private final IntObjectMap<? extends IntObjectMap<PropertyTypeSet>> allowedTypes;
    private final ProgressListener nodeProgress;
    private final CheckerContext context;
    private final ConsistencyReport.Reporter reporter;
    private final CountsState observedCounts;
    private final RecordLoading recordLoader;
    private final TokenHolders tokenHolders;
    private final NeoStores neoStores;
    private final List<IndexDescriptor> smallIndexes;

    NodeChecker(CheckerContext context, IntObjectMap<? extends IntSet> mandatoryProperties, IntObjectMap<? extends IntObjectMap<PropertyTypeSet>> allowedTypes) {
        this.context = context;
        this.reporter = context.reporter;
        this.observedCounts = context.observedCounts;
        this.recordLoader = context.recordLoader;
        this.tokenHolders = context.tokenHolders;
        this.neoStores = context.neoStores;
        this.mandatoryProperties = mandatoryProperties;
        this.allowedTypes = allowedTypes;
        this.smallIndexes = context.indexSizes.smallIndexes(EntityType.NODE);
        this.nodeProgress = context.roundInsensitiveProgressReporter(this, "Nodes", this.neoStores.getNodeStore().getIdGenerator().getHighId());
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange, MemoryTracker memoryTracker) throws Exception {
        ParallelExecution execution = this.context.execution;
        execution.run(this.getClass().getSimpleName() + "-checkNodes", execution.partition(nodeIdRange, (from, to, last) -> () -> this.check(from, to, lastRange && last)));
        if (this.context.consistencyFlags.checkIndexes()) {
            execution.run(this.getClass().getSimpleName() + "-checkIndexesVsNodes", (ParallelExecution.ThrowingRunnable[])this.smallIndexes.stream().map(indexDescriptor -> () -> this.checkIndexVsNodes(nodeIdRange, (IndexDescriptor)indexDescriptor, lastRange)).toArray(ParallelExecution.ThrowingRunnable[]::new));
        }
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.checkGraph() || flags.checkIndexes() && !this.smallIndexes.isEmpty();
    }

    private BoundedIterable<EntityTokenRange> getLabelIndexReader(long fromNodeId, long toNodeId, boolean last, CursorContext cursorContext) {
        if (this.context.nodeLabelIndex != null) {
            return this.context.nodeLabelIndex.newAllEntriesTokenReader(fromNodeId, last ? Long.MAX_VALUE : toNodeId, cursorContext);
        }
        return BoundedIterable.empty();
    }

    private void check(long fromNodeId, long toNodeId, boolean last) throws Exception {
        long usedNodes = 0L;
        try (CursorContext cursorContext = this.context.contextFactory.create(NODE_RANGE_CHECKER_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);
             RecordReader<NodeRecord> nodeReader = new RecordReader<NodeRecord>(this.context.neoStores.getNodeStore(), true, cursorContext, this.context.memoryTracker);
             RecordReader<DynamicRecord> labelReader = new RecordReader<DynamicRecord>(this.context.neoStores.getNodeStore().getDynamicLabelStore(), false, cursorContext, this.context.memoryTracker);
             BoundedIterable<EntityTokenRange> labelIndexReader = this.getLabelIndexReader(fromNodeId, toNodeId, last, cursorContext);
             SafePropertyChainReader property = new SafePropertyChainReader(this.context, cursorContext);
             SchemaComplianceChecker schemaComplianceChecker = new SchemaComplianceChecker(this.context, this.mandatoryProperties, this.allowedTypes, this.smallIndexes, cursorContext, (StoreCursors)storeCursors);
             ProgressListener localProgress = this.nodeProgress.threadLocalReporter();
             PrimitiveLongResourceIterator freeIdsIterator = this.context.neoStores.getNodeStore().getIdGenerator().notUsedIdsIterator(fromNodeId, toNodeId);){
            IntObjectHashMap<Value> propertyValues = new IntObjectHashMap<Value>();
            CacheAccess.Client client = this.context.cacheAccess.client();
            long[] nextRelCacheFields = new long[]{-1L, -1L, 1L, 0L, 0L, 1L, 0L, 0L};
            Iterator nodeLabelRangeIterator = labelIndexReader.iterator();
            EntityTokenIndexCheckState labelIndexState = new EntityTokenIndexCheckState(null, fromNodeId - 1L);
            long nextFreeId = Record.NULL_REFERENCE.longValue();
            for (long nodeId = fromNodeId; nodeId < toNodeId && !this.context.isCancelled(); ++nodeId) {
                boolean hasInlinedLabels;
                long nextRel;
                localProgress.add(1L);
                NodeRecord nodeRecord = nodeReader.read(nodeId);
                while (nextFreeId < nodeId && freeIdsIterator.hasNext()) {
                    nextFreeId = freeIdsIterator.next();
                }
                if (!nodeRecord.inUse()) {
                    if (nodeId == nextFreeId) continue;
                    this.reporter.forNode(nodeRecord).idIsNotFreed();
                    continue;
                }
                if (nodeId == nextFreeId) {
                    this.reporter.forNode(nodeRecord).idIsFreed();
                }
                if ((nextRel = nodeRecord.getNextRel()) < Record.NULL_REFERENCE.longValue()) {
                    this.reporter.forNode(nodeRecord).relationshipNotInUse(new RelationshipRecord(nextRel));
                    nextRel = Record.NULL_REFERENCE.longValue();
                }
                nextRelCacheFields[0] = nextRel;
                nextRelCacheFields[3] = CacheSlots.longOf(nodeRecord.isDense());
                ++usedNodes;
                int[] unverifiedLabels = RecordLoading.safeGetNodeLabels(this.context, (StoreCursors)storeCursors, nodeRecord.getId(), nodeRecord.getLabelField(), labelReader, this.context.memoryTracker);
                int[] labels = this.checkNodeLabels(nodeRecord, unverifiedLabels, (StoreCursors)storeCursors);
                long labelField = nodeRecord.getLabelField();
                boolean bl = hasInlinedLabels = !NodeLabelsField.fieldPointsToDynamicRecordOfLabels(nodeRecord.getLabelField());
                if (labels == null) {
                    hasInlinedLabels = true;
                    labelField = Record.NO_LABELS_FIELD.longValue();
                }
                boolean hasSingleLabel = labels != null && labels.length == 1;
                nextRelCacheFields[4] = CacheSlots.longOf(hasInlinedLabels);
                nextRelCacheFields[1] = hasSingleLabel ? (long)labels[0] : (hasInlinedLabels ? labelField : this.observedCounts.cacheDynamicNodeLabels(labels));
                nextRelCacheFields[6] = CacheSlots.longOf(hasSingleLabel);
                propertyValues = RecordLoading.lightReplace(propertyValues);
                boolean propertyChainIsOk = property.read((MutableIntObjectMap<Value>)propertyValues, nodeRecord, this.reporter::forNode, (StoreCursors)storeCursors);
                if (labelIndexReader.maxCount() != 0L) {
                    this.checkNodeVsLabelIndex(nodeRecord, nodeLabelRangeIterator, labelIndexState, nodeId, labels, fromNodeId, (StoreCursors)storeCursors);
                }
                client.putToCache(nodeId, nextRelCacheFields);
                if (labels == null || !propertyChainIsOk) continue;
                schemaComplianceChecker.checkExistenceAndTypeConstraints(nodeRecord, labels, (IntObjectMap<Value>)propertyValues, this.reporter::forNode);
                if (!this.context.consistencyFlags.checkIndexes()) continue;
                schemaComplianceChecker.checkCorrectlyIndexed(nodeRecord, labels, (IntObjectMap<Value>)propertyValues, this.reporter::forNode);
            }
            if (!this.context.isCancelled() && labelIndexReader.maxCount() != 0L) {
                this.reportRemainingLabelIndexEntries(nodeLabelRangeIterator, labelIndexState, last ? Long.MAX_VALUE : toNodeId, (StoreCursors)storeCursors);
            }
        }
        this.observedCounts.incrementNodeLabel(-1, usedNodes);
    }

    private int[] checkNodeLabels(NodeRecord nodeRecord, int[] labels, StoreCursors storeCursors) {
        if (labels == null) {
            return null;
        }
        boolean allGood = true;
        boolean valid = true;
        int prevLabel = -1;
        for (int i = 0; i < labels.length; ++i) {
            int label = labels[i];
            if (!RecordLoading.checkValidToken(nodeRecord, label, this.tokenHolders.labelTokens(), this.neoStores.getLabelTokenStore(), (node, token) -> this.reporter.forNode(this.recordLoader.node(node.getId(), storeCursors, this.context.memoryTracker)).illegalLabel(), (node, token) -> this.reporter.forNode(this.recordLoader.node(node.getId(), storeCursors, this.context.memoryTracker)).labelNotInUse((LabelTokenRecord)token), storeCursors, this.context.memoryTracker)) {
                valid = false;
            }
            if (prevLabel != label) {
                this.observedCounts.incrementNodeLabel(label, 1L);
                prevLabel = label;
            }
            if (i <= 0) continue;
            if (labels[i] == labels[i - 1]) {
                this.reporter.forNode(nodeRecord).labelDuplicate(labels[i]);
                allGood = false;
                break;
            }
            if (labels[i] >= labels[i - 1]) continue;
            this.reporter.forNode(nodeRecord).labelsOutOfOrder(NumberUtils.max((int[])labels), NumberUtils.min((int[])labels));
            allGood = false;
            break;
        }
        if (!valid) {
            return null;
        }
        return allGood ? labels : NodeChecker.sortAndDeduplicate(labels);
    }

    private void checkNodeVsLabelIndex(NodeRecord nodeRecord, Iterator<EntityTokenRange> nodeLabelRangeIterator, EntityTokenIndexCheckState labelIndexState, long nodeId, int[] labels, long fromNodeId, StoreCursors storeCursors) {
        long nodeIdMissingFromStore;
        while (labelIndexState.needToMoveRangeForwardToReachEntity(nodeId) && !this.context.isCancelled() && nodeLabelRangeIterator.hasNext()) {
            if (labelIndexState.currentRange != null) {
                for (nodeIdMissingFromStore = labelIndexState.lastCheckedEntityId + 1L; nodeIdMissingFromStore < nodeId && labelIndexState.currentRange.covers(nodeIdMissingFromStore); ++nodeIdMissingFromStore) {
                    if (labelIndexState.currentRange.tokens(nodeIdMissingFromStore).length <= 0) continue;
                    this.reporter.forNodeLabelScan(new TokenScanDocument(labelIndexState.currentRange)).nodeNotInUse(this.recordLoader.node(nodeIdMissingFromStore, storeCursors, this.context.memoryTracker));
                }
            }
            labelIndexState.currentRange = nodeLabelRangeIterator.next();
            labelIndexState.lastCheckedEntityId = NumberUtils.max((long[])new long[]{fromNodeId, labelIndexState.currentRange.entities()[0]}) - 1L;
        }
        if (labelIndexState.currentRange != null && labelIndexState.currentRange.covers(nodeId)) {
            for (nodeIdMissingFromStore = labelIndexState.lastCheckedEntityId + 1L; nodeIdMissingFromStore < nodeId; ++nodeIdMissingFromStore) {
                if (labelIndexState.currentRange.tokens(nodeIdMissingFromStore).length <= 0) continue;
                this.reporter.forNodeLabelScan(new TokenScanDocument(labelIndexState.currentRange)).nodeNotInUse(this.recordLoader.node(nodeIdMissingFromStore, storeCursors, this.context.memoryTracker));
            }
            int[] labelsInLabelIndex = labelIndexState.currentRange.tokens(nodeId);
            if (labels != null) {
                this.validateLabelIds(nodeRecord, labels, NodeChecker.sortAndDeduplicate(labelsInLabelIndex), labelIndexState.currentRange, storeCursors);
            }
            labelIndexState.lastCheckedEntityId = nodeId;
        } else if (labels != null) {
            for (int label : labels) {
                this.reporter.forNodeLabelScan(new TokenScanDocument(null)).nodeLabelNotInIndex(this.recordLoader.node(nodeId, storeCursors, this.context.memoryTracker), label);
            }
        }
    }

    private void reportRemainingLabelIndexEntries(Iterator<EntityTokenRange> nodeLabelRangeIterator, EntityTokenIndexCheckState labelIndexState, long toNodeId, StoreCursors storeCursors) {
        if (labelIndexState.currentRange == null && nodeLabelRangeIterator.hasNext()) {
            labelIndexState.currentRange = nodeLabelRangeIterator.next();
        }
        while (labelIndexState.currentRange != null && !this.context.isCancelled()) {
            long nodeIdMissingFromStore = labelIndexState.lastCheckedEntityId + 1L;
            while (nodeIdMissingFromStore < toNodeId && !labelIndexState.needToMoveRangeForwardToReachEntity(nodeIdMissingFromStore)) {
                if (labelIndexState.currentRange.covers(nodeIdMissingFromStore) && labelIndexState.currentRange.tokens(nodeIdMissingFromStore).length > 0) {
                    this.reporter.forNodeLabelScan(new TokenScanDocument(labelIndexState.currentRange)).nodeNotInUse(this.recordLoader.node(nodeIdMissingFromStore, storeCursors, this.context.memoryTracker));
                }
                labelIndexState.lastCheckedEntityId = nodeIdMissingFromStore++;
            }
            labelIndexState.currentRange = nodeLabelRangeIterator.hasNext() ? nodeLabelRangeIterator.next() : null;
        }
    }

    private void validateLabelIds(NodeRecord node, int[] labelsInStore, int[] labelsInIndex, EntityTokenRange entityTokenRange, StoreCursors storeCursors) {
        NodeChecker.compareTwoSortedIntArrays(SchemaPatternMatchingType.COMPLETE_ALL_TOKENS, labelsInStore, labelsInIndex, indexLabel -> this.reporter.forNodeLabelScan(new TokenScanDocument(entityTokenRange)).nodeDoesNotHaveExpectedLabel(this.recordLoader.node(node.getId(), storeCursors, this.context.memoryTracker), indexLabel), storeLabel -> this.reporter.forNodeLabelScan(new TokenScanDocument(entityTokenRange)).nodeLabelNotInIndex(this.recordLoader.node(node.getId(), storeCursors, this.context.memoryTracker), storeLabel));
    }

    static void compareTwoSortedIntArrays(SchemaPatternMatchingType schemaPatternMatchingType, int[] a, int[] b, IntConsumer bHasSomethingThatAIsMissingReport, IntConsumer aHasSomethingThatBIsMissingReport) {
        block9: {
            boolean anyFound;
            int bCursor;
            block8: {
                bCursor = 0;
                int aCursor = 0;
                anyFound = false;
                while (aCursor < a.length && bCursor < b.length && a[aCursor] != -1 && b[bCursor] != -1) {
                    int bValue = b[bCursor];
                    int aValue = a[aCursor];
                    if (bValue < aValue) {
                        if (schemaPatternMatchingType == SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) {
                            bHasSomethingThatAIsMissingReport.accept(bValue);
                        }
                        ++bCursor;
                        continue;
                    }
                    if (bValue > aValue) {
                        if (schemaPatternMatchingType == SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) {
                            aHasSomethingThatBIsMissingReport.accept(aValue);
                        }
                        ++aCursor;
                        continue;
                    }
                    ++bCursor;
                    ++aCursor;
                    anyFound = true;
                }
                if (schemaPatternMatchingType != SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) break block8;
                while (bCursor < b.length && b[bCursor] != -1) {
                    bHasSomethingThatAIsMissingReport.accept(b[bCursor++]);
                }
                while (aCursor < a.length && a[aCursor] != -1) {
                    aHasSomethingThatBIsMissingReport.accept(a[aCursor++]);
                }
                break block9;
            }
            if (schemaPatternMatchingType != SchemaPatternMatchingType.PARTIAL_ANY_TOKEN || anyFound) break block9;
            while (bCursor < b.length) {
                bHasSomethingThatAIsMissingReport.accept(b[bCursor++]);
            }
        }
    }

    private void checkIndexVsNodes(LongRange range, IndexDescriptor descriptor, boolean lastRange) throws Exception {
        CacheAccess.Client client = this.context.cacheAccess.client();
        IndexAccessor accessor = this.context.indexAccessors.accessorFor(descriptor);
        RelationshipCounter.NodeLabelsLookup nodeLabelsLookup = this.observedCounts.nodeLabelsLookup();
        SchemaDescriptor schema = descriptor.schema();
        SchemaPatternMatchingType schemaPatternMatchingType = schema.schemaPatternMatchingType();
        int[] indexEntityTokenIds = schema.getEntityTokenIds();
        indexEntityTokenIds = NodeChecker.sortAndDeduplicate(indexEntityTokenIds);
        try (CursorContext cursorContext = this.context.contextFactory.create(NODE_INDEXES_CHECKER_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);
             BoundedIterable allEntriesReader = accessor.newAllEntriesValueReader(range.from(), lastRange ? Long.MAX_VALUE : range.to(), cursorContext);){
            Iterator iterator = allEntriesReader.iterator();
            while (iterator.hasNext()) {
                long entityId = (Long)iterator.next();
                try {
                    boolean entityExists = client.getBooleanFromCache(entityId, 2);
                    if (!entityExists) {
                        this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeNotInUse(this.recordLoader.node(entityId, (StoreCursors)storeCursors, this.context.memoryTracker));
                        continue;
                    }
                    int[] entityTokenIds = nodeLabelsLookup.nodeLabels(entityId);
                    NodeChecker.compareTwoSortedIntArrays(schemaPatternMatchingType, entityTokenIds, indexEntityTokenIds, indexLabel -> this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeDoesNotHaveExpectedLabel(this.recordLoader.node(entityId, (StoreCursors)storeCursors, this.context.memoryTracker), indexLabel), storeLabel -> {});
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.reporter.forIndexEntry(new IndexEntry(descriptor, this.context.tokenNameLookup, entityId)).nodeNotInUse(this.recordLoader.node(entityId, (StoreCursors)storeCursors, this.context.memoryTracker));
                }
            }
        }
    }

    public String toString() {
        NodeStore nodeRecordNoStoreHeaderCommonAbstractStore = this.neoStores.getNodeStore();
        return String.format("%s[highId:%d,indexesToCheck:%d]", this.getClass().getSimpleName(), nodeRecordNoStoreHeaderCommonAbstractStore.getIdGenerator().getHighId(), this.smallIndexes.size());
    }

    public static int[] sortAndDeduplicate(int[] labels) {
        if (ArrayUtils.isNotEmpty((int[])labels)) {
            Arrays.sort(labels);
            return PrimitiveArrays.deduplicate((int[])labels);
        }
        return labels;
    }
}

