/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.consistency.checking.cache.CacheSlots;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.io.ByteUnit;

public class EntityBasedMemoryLimiter
extends PrefetchingIterator<CheckRange> {
    private final long maxOffHeapCachingMemory;
    private final long requiredMemoryPerEntity;
    private final long highNodeId;
    private final long highRelationshipId;
    private final long highEntityId;
    private final long entitiesPerRange;
    private long currentRangeStart;
    private long currentRangeEnd;

    public static Factory defaultMemoryLimiter(long maxOffHeapCachingMemory) {
        return new DefaultFactory(maxOffHeapCachingMemory);
    }

    public EntityBasedMemoryLimiter(long maxOffHeapCachingMemory, long requiredMemoryPerEntity, long highNodeId, long highRelationshipId) {
        assert (maxOffHeapCachingMemory > 0L) : "Max off-heap caching memory is " + maxOffHeapCachingMemory;
        assert (requiredMemoryPerEntity > 0L) : "Required memory per entity is " + requiredMemoryPerEntity;
        this.maxOffHeapCachingMemory = maxOffHeapCachingMemory;
        this.requiredMemoryPerEntity = requiredMemoryPerEntity;
        this.highNodeId = highNodeId;
        this.highRelationshipId = highRelationshipId;
        this.highEntityId = Long.max(highNodeId, highRelationshipId);
        this.entitiesPerRange = Long.max(1L, Long.min(this.highEntityId, maxOffHeapCachingMemory / requiredMemoryPerEntity));
        this.currentRangeStart = 0L;
        this.currentRangeEnd = Long.min(this.highEntityId, this.entitiesPerRange);
    }

    int numberOfRanges() {
        return Math.toIntExact((long)(((double)this.highEntityId - 1.0) / (double)this.entitiesPerRange + 1.0));
    }

    int numberOfNodeRanges() {
        return Math.toIntExact((long)(((double)this.highNodeId - 1.0) / (double)this.entitiesPerRange + 1.0));
    }

    int numberOfRelationshipRanges() {
        return Math.toIntExact((long)(((double)this.highRelationshipId - 1.0) / (double)this.entitiesPerRange + 1.0));
    }

    long rangeSize() {
        return this.entitiesPerRange;
    }

    protected CheckRange fetchNextOrNull() {
        if (this.currentRangeStart >= this.highEntityId) {
            return null;
        }
        CheckRange range = new CheckRange(this.currentRangeStart, this.currentRangeEnd, this.highNodeId, this.highRelationshipId);
        this.currentRangeStart = this.currentRangeEnd;
        this.currentRangeEnd = Long.min(this.highEntityId, this.currentRangeEnd + this.entitiesPerRange);
        return range;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(((Object)((Object)this)).getClass().getSimpleName()).append(':');
        builder.append(String.format("%n  maxOffHeapCachingMemory:%s", ByteUnit.bytesToString((long)this.maxOffHeapCachingMemory)));
        builder.append(String.format("%n  perEntityMemory:%s", ByteUnit.bytesToString((long)this.requiredMemoryPerEntity)));
        builder.append(String.format("%n  nodeHighId:%s", this.highNodeId));
        builder.append(String.format("%n  relationshipHighId:%s", this.highRelationshipId));
        builder.append(String.format("%n  ==> numberOfRanges:%d", this.numberOfRanges()));
        builder.append(String.format("%n  ==> numberOfEntitiesPerRange:%d", this.entitiesPerRange));
        return builder.toString();
    }

    static boolean isFirst(LongRange range) {
        return range.from() == 0L;
    }

    boolean isLast(LongRange range, boolean isNodeRange) {
        if (isNodeRange) {
            return range.to() == this.highNodeId;
        }
        return range.to() == this.highRelationshipId;
    }

    private static class DefaultFactory
    implements Factory {
        private final long maxOffHeapCachingMemory;

        DefaultFactory(long maxOffHeapCachingMemory) {
            this.maxOffHeapCachingMemory = maxOffHeapCachingMemory;
        }

        @Override
        public EntityBasedMemoryLimiter create(long highNodeId, long highRelationshipId) {
            long perEntityMemory = CacheSlots.CACHE_LINE_SIZE_BYTES;
            return new EntityBasedMemoryLimiter(this.maxOffHeapCachingMemory, perEntityMemory, highNodeId, highRelationshipId);
        }
    }

    static class CheckRange {
        private final LongRange nodeRange;
        private final LongRange relationshipRange;
        private final long rangeStart;
        private final long rangeEnd;

        CheckRange(long rangeStart, long rangeEnd, long highNodeId, long highRelationshipId) {
            this.rangeStart = rangeStart;
            this.rangeEnd = rangeEnd;
            this.relationshipRange = rangeStart < highRelationshipId ? LongRange.range((long)rangeStart, (long)Long.min(rangeEnd, highRelationshipId)) : null;
            this.nodeRange = rangeStart < highNodeId ? LongRange.range((long)rangeStart, (long)Long.min(rangeEnd, highNodeId)) : null;
        }

        boolean applicableForNodeBasedChecks() {
            return this.nodeRange != null;
        }

        boolean applicableForRelationshipBasedChecks() {
            return this.relationshipRange != null;
        }

        public LongRange getNodeRange() {
            return this.nodeRange;
        }

        public LongRange getRelationshipRange() {
            return this.relationshipRange;
        }

        public long from() {
            return this.rangeStart;
        }

        public String toString() {
            return LongRange.range((long)this.rangeStart, (long)this.rangeEnd).toString();
        }
    }

    public static interface Factory {
        public EntityBasedMemoryLimiter create(long var1, long var3);
    }
}

