/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.spi;

import java.io.Serializable;
import org.neo4j.common.EntityType;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.cypher.internal.LastCommittedTxIdProvider;
import org.neo4j.cypher.internal.frontend.phases.ProcedureSignature;
import org.neo4j.cypher.internal.frontend.phases.QualifiedName;
import org.neo4j.cypher.internal.frontend.phases.UserFunctionSignature;
import org.neo4j.cypher.internal.logical.plans.CanGetValue$;
import org.neo4j.cypher.internal.logical.plans.DoNotGetValue$;
import org.neo4j.cypher.internal.logical.plans.GetValueFromIndexBehavior;
import org.neo4j.cypher.internal.planner.spi.DatabaseMode$;
import org.neo4j.cypher.internal.planner.spi.EventuallyConsistent$;
import org.neo4j.cypher.internal.planner.spi.IndexDescriptor;
import org.neo4j.cypher.internal.planner.spi.IndexOrderCapability;
import org.neo4j.cypher.internal.planner.spi.InstrumentedGraphStatistics;
import org.neo4j.cypher.internal.planner.spi.PlanContext;
import org.neo4j.cypher.internal.planner.spi.TokenIndexDescriptor;
import org.neo4j.cypher.internal.runtime.QueryTransactionalContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionBoundReadTokenContext;
import org.neo4j.cypher.internal.runtime.interpreted.TransactionalContextWrapper;
import org.neo4j.cypher.internal.spi.IndexDescriptorCompatibility;
import org.neo4j.cypher.internal.spi.TransactionBoundPlanContext$;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.LabelId;
import org.neo4j.cypher.internal.util.PropertyKeyId;
import org.neo4j.cypher.internal.util.PropertyKeyId$;
import org.neo4j.cypher.internal.util.RelTypeId;
import org.neo4j.exceptions.KernelException;
import org.neo4j.exceptions.Neo4jException;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexBehaviour;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLog;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\rMu!\u0002!B\u0011\u0003ae!\u0002(B\u0011\u0003y\u0005\"\u0002,\u0002\t\u00039\u0006\"\u0002-\u0002\t\u0003I\u0006b\u0002Bt\u0003\u0011\u00051q\u000e\u0005\b\u0007\u000b\tA\u0011ABF\r\u0011q\u0015\tA.\t\u001194!\u0011!Q\u0001\n=D\u0001B\u001d\u0004\u0003\u0002\u0003\u0006Ia\u001d\u0005\ts\u001a\u0011\t\u0011)A\u0005u\"AQP\u0002B\u0001B\u0003%a\u0010\u0003\u0004W\r\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u001f1A\u0011IA\t\u0011\u001d\tYD\u0002C!\u0003{Aq!a\u0011\u0007\t\u0003\n)\u0005C\u0004\u0002J\u0019!\t%a\u0013\t\u000f\u0005=c\u0001\"\u0011\u0002R!9\u0011Q\u000b\u0004\u0005B\u0005]\u0003bBA.\r\u0011%\u0011Q\f\u0005\b\u0003s2A\u0011BA>\u0011\u001d\t\tI\u0002C!\u0003\u0007Cq!!\"\u0007\t\u0003\n9\tC\u0004\u0002\u0012\u001a!\t%a%\t\u000f\u0005]e\u0001\"\u0011\u0002\u001a\"9\u00111\u0018\u0004\u0005B\u0005u\u0006bBAb\r\u0011\u0005\u0013Q\u0019\u0005\b\u0003\u00174A\u0011IAg\u0011\u001d\t)N\u0002C!\u0003/Dq!!8\u0007\t\u0003\ny\u000eC\u0004\u0002f\u001a!I!a:\t\u000f\u0005=h\u0001\"\u0003\u0002r\"9\u0011\u0011 \u0004\u0005\n\u0005m\bb\u0002B\u0006\r\u0011\u0005#Q\u0002\u0005\b\u0005+1A\u0011\tB\f\u0011\u001d\u0011iB\u0002C!\u0005?AqA!\n\u0007\t\u0003\u00129\u0003C\u0004\u0003.\u0019!\tEa\f\t\u000f\tUb\u0001\"\u0011\u00038!9!Q\b\u0004\u0005\n\t}\u0002b\u0002B%\r\u0011%!1\n\u0005\b\u0005K2A\u0011\tB4\u0011\u001d\u0011IG\u0002C!\u0005OBqAa\u001b\u0007\t\u0003\u0012i\u0007C\u0004\u0003t\u0019!\tE!\u001e\t\u000f\t}d\u0001\"\u0003\u0003\u0002\"9!q\u0012\u0004\u0005B\tE\u0005b\u0002BL\r\u0011\u0005#\u0011\u0014\u0005\b\u0005;3A\u0011\tBP\u0011\u001d\u0011\tK\u0002C!\u0005GCqAa.\u0007\t\u0003\u0012I\fC\u0004\u0003F\u001a!\tEa2\t\u000f\t=g\u0001\"\u0011\u0003R\"I!Q\u001b\u0004C\u0002\u0013\u0005#q\u001b\u0005\b\u000534\u0001\u0015!\u0003{\u0011%\u0011YN\u0002b\u0001\n\u0003\u0012i\u000e\u0003\u0005\u0003f\u001a\u0001\u000b\u0011\u0002Bp\u0011\u001d\u00119O\u0002C!\u0005SDqa!\u0002\u0007\t\u0003\u001a9\u0001C\u0004\u0004\u0014\u0019!\te!\u0006\t\u000f\r]a\u0001\"\u0011\u0004\u001a!911\u0004\u0004\u0005B\ru\u0001bBB\u0013\r\u0011\u00053q\u0005\u0005\b\u0007W1A\u0011IB\u0017\u0011\u001d\u0019)F\u0002C!\u0007/\n1\u0004\u0016:b]N\f7\r^5p]\n{WO\u001c3QY\u0006t7i\u001c8uKb$(B\u0001\"D\u0003\r\u0019\b/\u001b\u0006\u0003\t\u0016\u000b\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\r\u001e\u000baaY=qQ\u0016\u0014(B\u0001%J\u0003\u0015qWm\u001c\u001bk\u0015\u0005Q\u0015aA8sO\u000e\u0001\u0001CA'\u0002\u001b\u0005\t%a\u0007+sC:\u001c\u0018m\u0019;j_:\u0014u.\u001e8e!2\fgnQ8oi\u0016DHo\u0005\u0002\u0002!B\u0011\u0011\u000bV\u0007\u0002%*\t1+A\u0003tG\u0006d\u0017-\u0003\u0002V%\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001'\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013i\u001bIfa\u0017\u0004^\r5\u0004CA'\u0007'\u00111A\fZ6\u0011\u0005u\u0013W\"\u00010\u000b\u0005}\u0003\u0017aC5oi\u0016\u0014\bO]3uK\u0012T!!Y\"\u0002\u000fI,h\u000e^5nK&\u00111M\u0018\u0002!)J\fgn]1di&|gNQ8v]\u0012\u0014V-\u00193U_.,gnQ8oi\u0016DH\u000f\u0005\u0002fS6\taM\u0003\u0002CO*\u0011\u0001nQ\u0001\ba2\fgN\\3s\u0013\tQgMA\u0006QY\u0006t7i\u001c8uKb$\bCA'm\u0013\ti\u0017I\u0001\u000fJ]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s\u0007>l\u0007/\u0019;jE&d\u0017\u000e^=\u0002\u0005Q\u001c\u0007CA/q\u0013\t\thLA\u000eUe\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010^,sCB\u0004XM]\u0001\u0007Y><w-\u001a:\u0011\u0005Q<X\"A;\u000b\u0005Y\u001c\u0015\u0001B;uS2L!\u0001_;\u00035%sG/\u001a:oC2tu\u000e^5gS\u000e\fG/[8o\u0019><w-\u001a:\u0002\u001f\u001d\u0014\u0018\r\u001d5Ti\u0006$\u0018n\u001d;jGN\u0004\"!Z>\n\u0005q4'aG%ogR\u0014X/\\3oi\u0016$wI]1qQN#\u0018\r^5ti&\u001c7/A\u0007dsBDWM\u001d,feNLwN\u001c\t\u0004\u007f\u0006\u0005Q\"A\"\n\u0007\u0005\r1IA\u0007DsBDWM\u001d,feNLwN\u001c\u000b\n5\u0006\u001d\u0011\u0011BA\u0006\u0003\u001bAQA\\\u0006A\u0002=DQA]\u0006A\u0002MDQ!_\u0006A\u0002iDQ!`\u0006A\u0002y\fqC]1oO\u0016Le\u000eZ3yKN<U\r\u001e$pe2\u000b'-\u001a7\u0015\t\u0005M\u0011\u0011\u0007\t\u0007\u0003+\t)#a\u000b\u000f\t\u0005]\u0011\u0011\u0005\b\u0005\u00033\ty\"\u0004\u0002\u0002\u001c)\u0019\u0011QD&\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0016bAA\u0012%\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u0014\u0003S\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0004\u0003G\u0011\u0006cA3\u0002.%\u0019\u0011q\u00064\u0003\u001f%sG-\u001a=EKN\u001c'/\u001b9u_JDq!a\r\r\u0001\u0004\t)$A\u0004mC\n,G.\u00133\u0011\u0007E\u000b9$C\u0002\u0002:I\u00131!\u00138u\u0003e\u0011\u0018M\\4f\u0013:$W\r_3t\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3\u0015\t\u0005M\u0011q\b\u0005\b\u0003\u0003j\u0001\u0019AA\u001b\u0003%\u0011X\r\u001c+za\u0016LE-\u0001\fuKb$\u0018J\u001c3fq\u0016\u001cx)\u001a;G_Jd\u0015MY3m)\u0011\t\u0019\"a\u0012\t\u000f\u0005Mb\u00021\u0001\u00026\u0005AB/\u001a=u\u0013:$W\r_3t\u000f\u0016$hi\u001c:SK2$\u0016\u0010]3\u0015\t\u0005M\u0011Q\n\u0005\b\u0003\u0003z\u0001\u0019AA\u001b\u0003]\u0001x.\u001b8u\u0013:$W\r_3t\u000f\u0016$hi\u001c:MC\n,G\u000e\u0006\u0003\u0002\u0014\u0005M\u0003bBA\u001a!\u0001\u0007\u0011QG\u0001\u001aa>Lg\u000e^%oI\u0016DXm]$fi\u001a{'OU3m)f\u0004X\r\u0006\u0003\u0002\u0014\u0005e\u0003bBA!#\u0001\u0007\u0011QG\u0001\u0013S:$W\r_3t\u000f\u0016$hi\u001c:MC\n,G\u000e\u0006\u0004\u0002\u0014\u0005}\u0013\u0011\r\u0005\b\u0003g\u0011\u0002\u0019AA\u001b\u0011\u001d\t\u0019G\u0005a\u0001\u0003K\n\u0011\"\u001b8eKb$\u0016\u0010]3\u0011\u000bE\u000b9'a\u001b\n\u0007\u0005%$K\u0001\u0004PaRLwN\u001c\t\u0005\u0003[\n)(\u0004\u0002\u0002p)!\u0011\u0011OA:\u0003\u0019\u00198\r[3nC*\u0011AiR\u0005\u0005\u0003o\nyGA\u0005J]\u0012,\u0007\u0010V=qK\u0006!\u0012N\u001c3fq\u0016\u001cx)\u001a;G_J\u0014V\r\u001c+za\u0016$b!a\u0005\u0002~\u0005}\u0004bBA!'\u0001\u0007\u0011Q\u0007\u0005\b\u0003G\u001a\u0002\u0019AA3\u0003U\u0001(o\u001c9feRL\u0018J\u001c3fq\u0016\u001cx)\u001a;BY2$\"!a\u0005\u0002'%tG-\u001a=Fq&\u001cHo\u001d$pe2\u000b'-\u001a7\u0015\t\u0005%\u0015q\u0012\t\u0004#\u0006-\u0015bAAG%\n9!i\\8mK\u0006t\u0007bBA\u001a+\u0001\u0007\u0011QG\u0001\u0016S:$W\r_#ySN$8OR8s%\u0016dG+\u001f9f)\u0011\tI)!&\t\u000f\u0005\u0005c\u00031\u0001\u00026\u0005\tC/\u001a=u\u0013:$W\r_$fi\u001a{'\u000fT1cK2\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111TAO\u0003c\u0003R!UA4\u0003WAq!a(\u0018\u0001\u0004\t\t+A\u0005mC\n,GNT1nKB!\u00111UAV\u001d\u0011\t)+a*\u0011\u0007\u0005e!+C\u0002\u0002*J\u000ba\u0001\u0015:fI\u00164\u0017\u0002BAW\u0003_\u0013aa\u0015;sS:<'bAAU%\"9\u00111W\fA\u0002\u0005U\u0016\u0001\u00049s_B,'\u000f^=LKf\u001c\bCBA\u000b\u0003o\u000b\t+\u0003\u0003\u0002:\u0006%\"aA*fc\u0006\u0011#/\u00198hK&sG-\u001a=HKR4uN\u001d'bE\u0016d\u0017I\u001c3Qe>\u0004XM\u001d;jKN$b!a'\u0002@\u0006\u0005\u0007bBAP1\u0001\u0007\u0011\u0011\u0015\u0005\b\u0003gC\u0002\u0019AA[\u0003\t\u0002x.\u001b8u\u0013:$W\r_$fi\u001a{'\u000fT1cK2\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111TAd\u0003\u0013Dq!a(\u001a\u0001\u0004\t\t\u000bC\u0004\u00024f\u0001\r!!.\u0002GQ,\u0007\u0010^%oI\u0016Dx)\u001a;G_J\u0014V\r\u001c+za\u0016\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111TAh\u0003'Dq!!5\u001b\u0001\u0004\t\t+A\u0006sK2$\u0016\u0010]3OC6,\u0007bBAZ5\u0001\u0007\u0011QW\u0001%e\u0006tw-Z%oI\u0016Dx)\u001a;G_J\u0014V\r\u001c+za\u0016\fe\u000e\u001a)s_B,'\u000f^5fgR1\u00111TAm\u00037Dq!!5\u001c\u0001\u0004\t\t\u000bC\u0004\u00024n\u0001\r!!.\u0002IA|\u0017N\u001c;J]\u0012,\u0007pR3u\r>\u0014(+\u001a7UsB,\u0017I\u001c3Qe>\u0004XM\u001d;jKN$b!a'\u0002b\u0006\r\bbBAi9\u0001\u0007\u0011\u0011\u0015\u0005\b\u0003gc\u0002\u0019AA[\u0003uIg\u000eZ3y\u000f\u0016$hi\u001c:MC\n,G.\u00118e!J|\u0007/\u001a:uS\u0016\u001cH\u0003CAN\u0003S\fY/!<\t\u000f\u0005\rT\u00041\u0001\u0002l!9\u0011qT\u000fA\u0002\u0005\u0005\u0006bBAZ;\u0001\u0007\u0011QW\u0001 S:$W\r_$fi\u001a{'OU3m)f\u0004X-\u00118e!J|\u0007/\u001a:uS\u0016\u001cH\u0003CAN\u0003g\f)0a>\t\u000f\u0005\rd\u00041\u0001\u0002l!9\u0011\u0011\u001b\u0010A\u0002\u0005\u0005\u0006bBAZ=\u0001\u0007\u0011QW\u0001\u001cS:$W\r_$fi\u001a{'oU2iK6\fG)Z:de&\u0004Ho\u001c:\u0015\t\u0005u(\u0011\u0002\u000b\u0005\u00037\u000by\u0010C\u0004\u0003\u0002}\u0001\rAa\u0001\u0002\u0015\u0011,7o\u0019:jaR|'\u000f\u0005\u0003\u0002n\t\u0015\u0011\u0002\u0002B\u0004\u0003_\u0012\u0001cU2iK6\fG)Z:de&\u0004Ho\u001c:\t\u000f\u0005\rt\u00041\u0001\u0002l\u0005!C/\u001a=u\u0013:$W\r_#ySN$8OR8s\u0019\u0006\u0014W\r\\!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\n\n=!\u0011\u0003\u0005\b\u0003?\u0003\u0003\u0019AAQ\u0011\u001d\u0011\u0019\u0002\ta\u0001\u0003k\u000b1\u0002\u001d:pa\u0016\u0014H/_&fs\u0006)#/\u00198hK&sG-\u001a=Fq&\u001cHo\u001d$pe2\u000b'-\u001a7B]\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003\u0013\u0013IBa\u0007\t\u000f\u0005}\u0015\u00051\u0001\u0002\"\"9!1C\u0011A\u0002\u0005U\u0016!\n9pS:$\u0018J\u001c3fq\u0016C\u0018n\u001d;t\r>\u0014H*\u00192fY\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tII!\t\u0003$!9\u0011q\u0014\u0012A\u0002\u0005\u0005\u0006b\u0002B\nE\u0001\u0007\u0011QW\u0001'i\u0016DH/\u00138eKb,\u00050[:ug\u001a{'OU3m)f\u0004X-\u00118e!J|\u0007/\u001a:uS\u0016\u001cHCBAE\u0005S\u0011Y\u0003C\u0004\u0002R\u000e\u0002\r!!)\t\u000f\tM1\u00051\u0001\u00026\u00069#/\u00198hK&sG-\u001a=Fq&\u001cHo\u001d$peJ+G\u000eV=qK\u0006sG\r\u0015:pa\u0016\u0014H/[3t)\u0019\tII!\r\u00034!9\u0011\u0011\u001b\u0013A\u0002\u0005\u0005\u0006b\u0002B\nI\u0001\u0007\u0011QW\u0001(a>Lg\u000e^%oI\u0016DX\t_5tiN4uN\u001d*fYRK\b/Z!oIB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002\n\ne\"1\b\u0005\b\u0003#,\u0003\u0019AAQ\u0011\u001d\u0011\u0019\"\na\u0001\u0003k\u000babZ3u\u001f:d\u0017N\\3J]\u0012,\u0007\u0010\u0006\u0003\u0002\u001c\n\u0005\u0003b\u0002B\"M\u0001\u0007!QI\u0001\ne\u00164WM]3oG\u0016\u0004B!!\u001c\u0003H%!\u0011qFA8\u0003]9W\r\u001e+pW\u0016t\u0017J\u001c3fq\u0012+7o\u0019:jaR|'\u000f\u0006\u0003\u0003N\tU\u0003#B)\u0002h\t=\u0003cA3\u0003R%\u0019!1\u000b4\u0003)Q{7.\u001a8J]\u0012,\u0007\u0010R3tGJL\u0007\u000f^8s\u0011\u001d\u00119f\na\u0001\u00053\nq!\u001b8eKb,7\u000f\u0005\u0004\u0003\\\t\r$QI\u0007\u0003\u0005;R1A\u001eB0\u0015\t\u0011\t'\u0001\u0003kCZ\f\u0017\u0002BA\u0014\u0005;\naB\\8eKR{7.\u001a8J]\u0012,\u00070\u0006\u0002\u0003N\u00051\"/\u001a7bi&|gn\u001d5jaR{7.\u001a8J]\u0012,\u00070\u0001\u0012iCNtu\u000eZ3Qe>\u0004XM\u001d;z\u000bbL7\u000f^3oG\u0016\u001cuN\\:ue\u0006Lg\u000e\u001e\u000b\u0007\u0003\u0013\u0013yG!\u001d\t\u000f\u0005}%\u00061\u0001\u0002\"\"9!1\u0003\u0016A\u0002\u0005\u0005\u0016\u0001K4fi:{G-\u001a)s_B,'\u000f^5fg^KG\u000f[#ySN$XM\\2f\u0007>t7\u000f\u001e:bS:$H\u0003\u0002B<\u0005{\u0002b!a)\u0003z\u0005\u0005\u0016\u0002\u0002B>\u0003_\u00131aU3u\u0011\u001d\tyj\u000ba\u0001\u0003C\u000bQeZ3u!J|\u0007/\u001a:uS\u0016\u001chI]8n\u000bbL7\u000f^3oG\u0016\u001cuN\\:ue\u0006Lg\u000e^:\u0015\t\t]$1\u0011\u0005\b\u0005\u000bc\u0003\u0019\u0001BD\u0003-\u0019wN\\:ue\u0006Lg\u000e^:\u0011\r\u0005U\u0011Q\u0005BE!\u0011\tiGa#\n\t\t5\u0015q\u000e\u0002\u0015\u0007>t7\u000f\u001e:bS:$H)Z:de&\u0004Ho\u001c:\u0002U!\f7OU3mCRLwN\\:iSB\u0004&o\u001c9feRLX\t_5ti\u0016t7-Z\"p]N$(/Y5oiR1\u0011\u0011\u0012BJ\u0005+Cq!!5.\u0001\u0004\t\t\u000bC\u0004\u0003\u00145\u0002\r!!)\u0002a\u001d,GOU3mCRLwN\\:iSB\u0004&o\u001c9feRLWm],ji\",\u00050[:uK:\u001cWmQ8ogR\u0014\u0018-\u001b8u)\u0011\u00119Ha'\t\u000f\u0005Eg\u00061\u0001\u0002\"\u0006!s-\u001a;Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5Fq&\u001cH/\u001a8dK\u000e{gn\u001d;sC&tG/\u0006\u0002\u0003x\u0005i\u0002.Y:O_\u0012,\u0007K]8qKJ$\u0018\u0010V=qK\u000e{gn\u001d;sC&tG\u000f\u0006\u0005\u0002\n\n\u0015&q\u0015BU\u0011\u001d\ty\n\ra\u0001\u0003CCqAa\u00051\u0001\u0004\t\t\u000bC\u0004\u0003,B\u0002\rA!,\u0002\u0015\rL\b\u000f[3s)f\u0004X\r\u0005\u0003\u00030\nMVB\u0001BY\u0015\u0011\u0011))a\u001c\n\t\tU&\u0011\u0017\u0002\u0010'\u000eDW-\\1WC2,X\rV=qK\u0006\u0019s-\u001a;O_\u0012,\u0007K]8qKJ$\u0018.Z:XSRDG+\u001f9f\u0007>t7\u000f\u001e:bS:$H\u0003\u0002B^\u0005\u0007\u0004\u0002\"a)\u0003>\u0006\u0005&\u0011Y\u0005\u0005\u0005\u007f\u000byKA\u0002NCB\u0004b!!\u0006\u00028\n5\u0006bBAPc\u0001\u0007\u0011\u0011U\u0001&Q\u0006\u001c(+\u001a7bi&|gn\u001d5jaB\u0013x\u000e]3sif$\u0016\u0010]3D_:\u001cHO]1j]R$\u0002\"!#\u0003J\n-'Q\u001a\u0005\b\u0003#\u0014\u0004\u0019AAQ\u0011\u001d\u0011\u0019B\ra\u0001\u0003CCqAa+3\u0001\u0004\u0011i+A\u0016hKR\u0014V\r\\1uS>t7\u000f[5q!J|\u0007/\u001a:uS\u0016\u001cx+\u001b;i)f\u0004XmQ8ogR\u0014\u0018-\u001b8u)\u0011\u0011YLa5\t\u000f\u0005E7\u00071\u0001\u0002\"\u0006Q1\u000f^1uSN$\u0018nY:\u0016\u0003i\f1b\u001d;bi&\u001cH/[2tA\u0005IB.Y:u\u0007>lW.\u001b;uK\u0012$\u00060\u00133Qe>4\u0018\u000eZ3s+\t\u0011y\u000eE\u0002\u0000\u0005CL1Aa9D\u0005ea\u0015m\u001d;D_6l\u0017\u000e\u001e;fIRC\u0018\n\u001a)s_ZLG-\u001a:\u000251\f7\u000f^\"p[6LG\u000f^3e)bLE\r\u0015:pm&$WM\u001d\u0011\u0002%A\u0014xnY3ekJ,7+[4oCR,(/\u001a\u000b\u0005\u0005W\u0014Y\u0010\u0005\u0003\u0003n\n]XB\u0001Bx\u0015\u0011\u0011\tPa=\u0002\rAD\u0017m]3t\u0015\r\u0011)pQ\u0001\tMJ|g\u000e^3oI&!!\u0011 Bx\u0005I\u0001&o\\2fIV\u0014XmU5h]\u0006$XO]3\t\u000f\tu\b\b1\u0001\u0003\u0000\u0006!a.Y7f!\u0011\u0011io!\u0001\n\t\r\r!q\u001e\u0002\u000e#V\fG.\u001b4jK\u0012t\u0015-\\3\u0002#\u0019,hn\u0019;j_:\u001c\u0016n\u001a8biV\u0014X\r\u0006\u0003\u0004\n\rE\u0001#B)\u0002h\r-\u0001\u0003\u0002Bw\u0007\u001bIAaa\u0004\u0003p\n)Rk]3s\rVt7\r^5p]NKwM\\1ukJ,\u0007b\u0002B\u007fs\u0001\u0007!q`\u0001\u0013]>$\u0018NZ5dCRLwN\u001c'pO\u001e,'\u000fF\u0001t\u0003E!\bp\u0015;bi\u0016D\u0015m]\"iC:<Wm\u001d\u000b\u0003\u0003\u0013\u000b\u0011\u0004\u001d:pG\u0016$WO]3TS\u001et\u0017\r^;sKZ+'o]5p]V\u00111q\u0004\t\u0004#\u000e\u0005\u0012bAB\u0012%\n!Aj\u001c8h\u0003Y9\u0018\u000e\u001e5O_RLg-[2bi&|g\u000eT8hO\u0016\u0014Hc\u00013\u0004*!111C\u001fA\u0002M\fA\u0002Z1uC\n\f7/Z'pI\u0016,\"aa\f\u0011\t\rE2q\n\b\u0005\u0007g\u0019YE\u0004\u0003\u00046\r%c\u0002BB\u001c\u0007\u000frAa!\u000f\u0004F9!11HB\"\u001d\u0011\u0019id!\u0011\u000f\t\u0005e1qH\u0005\u0002\u0015&\u0011\u0001*S\u0005\u0003\r\u001eK!\u0001R#\n\u0005!\u001c\u0015B\u0001\"h\u0013\r\u0019iEZ\u0001\r\t\u0006$\u0018MY1tK6{G-Z\u0005\u0005\u0007#\u001a\u0019F\u0001\u0007ECR\f'-Y:f\u001b>$WMC\u0002\u0004N\u0019\fAd\u001d;pe\u0006<W\rS1t!J|\u0007/\u001a:us\u000e{Gn\\2bi&|g.\u0006\u0002\u0002\n\")an\u0001a\u0001_\")!o\u0001a\u0001g\"91qL\u0002A\u0002\r\u0005\u0014a\u00017pOB!11MB5\u001b\t\u0019)GC\u0002\u0004h\u001d\u000bq\u0001\\8hO&tw-\u0003\u0003\u0004l\r\u0015$aC%oi\u0016\u0014h.\u00197M_\u001eDQ!`\u0002A\u0002y$\u0002Ba;\u0004r\r\u00155q\u0011\u0005\b\u0007g\"\u0001\u0019AB;\u0003\t!\b\u0010\u0005\u0003\u0004x\r\u0005UBAB=\u0015\u0011\u0019Yh! \u0002\u0007\u0005\u0004\u0018NC\u0002\u0004\u0000\u001d\u000baa[3s]\u0016d\u0017\u0002BBB\u0007s\u0012\u0011cS3s]\u0016dGK]1og\u0006\u001cG/[8o\u0011\u001d\u0011i\u0010\u0002a\u0001\u0005\u007fDaa!#\u0005\u0001\u0004q\u0018a\u0002<feNLwN\u001c\u000b\t\u0007\u0013\u0019iia$\u0004\u0012\"911O\u0003A\u0002\rU\u0004b\u0002B\u007f\u000b\u0001\u0007!q \u0005\u0007\u0007\u0013+\u0001\u0019\u0001@")
public class TransactionBoundPlanContext
extends TransactionBoundReadTokenContext
implements PlanContext,
IndexDescriptorCompatibility {
    private final TransactionalContextWrapper tc;
    private final InternalNotificationLogger logger;
    private final InstrumentedGraphStatistics graphStatistics;
    private final CypherVersion cypherVersion;
    private final InstrumentedGraphStatistics statistics;
    private final LastCommittedTxIdProvider lastCommittedTxIdProvider;

    public static TransactionBoundPlanContext apply(TransactionalContextWrapper tc, InternalNotificationLogger logger, InternalLog log, CypherVersion cypherVersion) {
        return TransactionBoundPlanContext$.MODULE$.apply(tc, logger, log, cypherVersion);
    }

    @Override
    public org.neo4j.cypher.internal.planner.spi.IndexBehaviour kernelToCypher(IndexBehaviour behaviour) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, behaviour);
    }

    @Override
    public Option<IndexDescriptor.IndexType> kernelToCypher(IndexType indexType) {
        return IndexDescriptorCompatibility.kernelToCypher$((IndexDescriptorCompatibility)this, indexType);
    }

    @Override
    public SchemaDescriptor cypherToKernelSchema(org.neo4j.cypher.internal.planner.spi.IndexDescriptor index) {
        return IndexDescriptorCompatibility.cypherToKernelSchema$(this, index);
    }

    @Override
    public IndexType cypherToKernel(IndexDescriptor.IndexType indexType) {
        return IndexDescriptorCompatibility.cypherToKernel$(this, indexType);
    }

    @Override
    public Option<LabelSchemaDescriptor> toLabelSchemaDescriptor(TransactionBoundReadTokenContext tc, String labelName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toLabelSchemaDescriptor$(this, tc, labelName, propertyKeys);
    }

    @Override
    public Option<RelationTypeSchemaDescriptor> toRelTypeSchemaDescriptor(TransactionBoundReadTokenContext tc, String relTypeName, Seq<String> propertyKeys) {
        return IndexDescriptorCompatibility.toRelTypeSchemaDescriptor$(this, tc, relTypeName, propertyKeys);
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.RANGE));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.TEXT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexesGetForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)new Some((Object)IndexType.POINT));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForLabel(int labelId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$1(it, x$2));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForLabel$2(x$3));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getLabelIndexesNonLocking(labelId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    private Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexesGetForRelType(int relTypeId, Option<IndexType> indexType) {
        Function1 & Serializable intersect;
        Option<IndexType> option = indexType;
        if (option instanceof Some) {
            Some some = (Some)option;
            IndexType it = (IndexType)some.value();
            intersect = (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$1(it, x$4));
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexesGetForRelType$2(x$5));
        } else {
            throw new MatchError(option);
        }
        Function1 & Serializable selector = intersect;
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().getRelTypeIndexesNonLocking(relTypeId)).asScala().filter((Function1)selector).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public Iterator<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> propertyIndexesGetAll() {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexesGetAllNonLocking()).asScala().flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
    }

    public boolean indexExistsForLabel(int labelId) {
        return this.indexesGetForLabel(labelId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public boolean indexExistsForRelType(int relTypeId) {
        return this.indexesGetForRelType(relTypeId, (Option<IndexType>)None$.MODULE$).nonEmpty();
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.TEXT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.RANGE, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForLabelAndProperties(String labelName, Seq<String> propertyKeys) {
        return this.indexGetForLabelAndProperties(IndexType.POINT, labelName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> textIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.TEXT, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> rangeIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.RANGE, relTypeName, propertyKeys);
    }

    public Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> pointIndexGetForRelTypeAndProperties(String relTypeName, Seq<String> propertyKeys) {
        return this.indexGetForRelTypeAndProperties(IndexType.POINT, relTypeName, propertyKeys);
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForLabelAndProperties(IndexType indexType, String labelName, Seq<String> propertyKeys) {
        Option<LabelSchemaDescriptor> descriptor2 = this.toLabelSchemaDescriptor(this, labelName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForRelTypeAndProperties(IndexType indexType, String relTypeName, Seq<String> propertyKeys) {
        Option<RelationTypeSchemaDescriptor> descriptor2 = this.toRelTypeSchemaDescriptor(this, relTypeName, propertyKeys);
        return descriptor2.flatMap((Function1 & Serializable)descriptor -> this.indexGetForSchemaDescriptor(indexType, (SchemaDescriptor)descriptor));
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> indexGetForSchemaDescriptor(IndexType indexType, SchemaDescriptor descriptor) {
        Iterator itr = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().indexForSchemaNonLocking(descriptor)).asScala().filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TransactionBoundPlanContext.$anonfun$indexGetForSchemaDescriptor$1(indexType, x$6))).flatMap((Function1 & Serializable)reference -> this.getOnlineIndex((IndexDescriptor)reference));
        if (itr.hasNext()) {
            return new Some(itr.next());
        }
        return None$.MODULE$;
    }

    public boolean textIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.textIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.rangeIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForLabelAndProperties(String labelName, Seq<String> propertyKey) {
        return this.pointIndexGetForLabelAndProperties(labelName, propertyKey).isDefined();
    }

    public boolean textIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.textIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean rangeIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.rangeIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    public boolean pointIndexExistsForRelTypeAndProperties(String relTypeName, Seq<String> propertyKey) {
        return this.pointIndexGetForRelTypeAndProperties(relTypeName, propertyKey).isDefined();
    }

    private Option<org.neo4j.cypher.internal.planner.spi.IndexDescriptor> getOnlineIndex(IndexDescriptor reference) {
        Object object;
        block7: {
            try {
                InternalIndexState internalIndexState = this.tc.schemaRead().indexGetStateNonLocking(reference);
                if (InternalIndexState.ONLINE.equals(internalIndexState) && ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()))) {
                    CanGetValue$ valueCapability;
                    IndexDescriptor.EntityType$.Node node;
                    int tokenId = reference.schema().getEntityTokenIds()[0];
                    EntityType entityType = reference.schema().entityType();
                    if (EntityType.NODE.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Node(new LabelId(tokenId));
                    } else if (EntityType.RELATIONSHIP.equals(entityType)) {
                        node = new IndexDescriptor.EntityType$.Relationship(new RelTypeId(tokenId));
                    } else {
                        throw new MatchError((Object)entityType);
                    }
                    IndexDescriptor.EntityType$.Node entityType2 = node;
                    PropertyKeyId[] properties = (PropertyKeyId[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.intArrayOps(reference.schema().getPropertyIds()), (Function1)PropertyKeyId$.MODULE$, ClassTag$.MODULE$.apply(PropertyKeyId.class));
                    boolean isUnique = reference.isUnique();
                    Set behaviours = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])reference.getCapability().behaviours()), (Function1 & Serializable)behaviour -> this.kernelToCypher((IndexBehaviour)behaviour), ClassTag$.MODULE$.apply(org.neo4j.cypher.internal.planner.spi.IndexBehaviour.class))).toSet();
                    IndexOrderCapability.BOTH$ orderCapability = reference.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
                    Object object2 = valueCapability = reference.getCapability().supportsReturningValues() ? CanGetValue$.MODULE$ : DoNotGetValue$.MODULE$;
                    object = behaviours.contains((Object)EventuallyConsistent$.MODULE$) ? None$.MODULE$ : (isUnique && this.tc.schemaRead().indexGetOwningUniquenessConstraintIdNonLocking(reference) == null ? None$.MODULE$ : this.kernelToCypher(reference.getIndexType()).map(arg_0 -> TransactionBoundPlanContext.$anonfun$getOnlineIndex$2((Product)entityType2, properties, behaviours, (Product)orderCapability, (Product)valueCapability, reference, isUnique, arg_0)));
                    break block7;
                }
                object = None$.MODULE$;
            }
            catch (IndexNotFoundKernelException indexNotFoundKernelException) {
                object = None$.MODULE$;
            }
        }
        return object;
    }

    private Option<TokenIndexDescriptor> getTokenIndexDescriptor(java.util.Iterator<IndexDescriptor> indexes) {
        return CollectionConverters$.MODULE$.IteratorHasAsScala(indexes).asScala().nextOption().map((Function1 & Serializable)kernelIndexDescriptor -> {
            EntityType typ = kernelIndexDescriptor.schema().entityType();
            IndexOrderCapability.BOTH$ orderCapability = kernelIndexDescriptor.getCapability().supportsOrdering() ? IndexOrderCapability.BOTH$.MODULE$ : IndexOrderCapability.NONE$.MODULE$;
            return new TokenIndexDescriptor(typ, (IndexOrderCapability)orderCapability);
        });
    }

    public Option<TokenIndexDescriptor> nodeTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_NODE_SCHEMA_DESCRIPTOR));
    }

    public Option<TokenIndexDescriptor> relationshipTokenIndex() {
        return this.getTokenIndexDescriptor(this.tc.schemaRead().indexForSchemaNonTransactional((SchemaDescriptor)SchemaDescriptors.ANY_TOKEN_RELATIONSHIP_SCHEMA_DESCRIPTOR));
    }

    public boolean hasNodePropertyExistenceConstraint(String labelName, String propertyKey) {
        boolean bl;
        try {
            int labelId = this.getLabelId(labelName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forLabel((int)labelId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getNodePropertiesWithExistenceConstraint(String labelName) {
        Set<String> set;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    private Set<String> getPropertiesFromExistenceConstraints(Iterator<ConstraintDescriptor> constraints) {
        Iterator existsConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence()));
        Set distinctPropertyIds = existsConstraints.flatMap((Function1 & Serializable)x$7 -> Predef$.MODULE$.wrapIntArray(x$7.schema().getPropertyIds())).toSet();
        return (Set)distinctPropertyIds.map((Function1 & Serializable)id -> TransactionBoundPlanContext.$anonfun$getPropertiesFromExistenceConstraints$3(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public boolean hasRelationshipPropertyExistenceConstraint(String relTypeName, String propertyKey) {
        boolean bl;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            int propertyKeyId = this.getPropertyKeyId(propertyKey);
            bl = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForSchemaNonLocking((SchemaDescriptor)SchemaDescriptors.forRelType((int)relTypeId, (int[])new int[]{propertyKeyId}))).asScala().filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyExistence())).hasNext();
        }
        catch (KernelException kernelException) {
            bl = false;
        }
        return bl;
    }

    public Set<String> getRelationshipPropertiesWithExistenceConstraint(String relTypeName) {
        Set<String> set;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public Set<String> getPropertiesWithExistenceConstraint() {
        Set<String> set;
        try {
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetAllNonLocking()).asScala();
            set = this.getPropertiesFromExistenceConstraints((Iterator<ConstraintDescriptor>)constraints);
        }
        catch (KernelException kernelException) {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public boolean hasNodePropertyTypeConstraint(String labelName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getNodePropertiesWithTypeConstraint(labelName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getNodePropertiesWithTypeConstraint(String labelName) {
        Map map;
        try {
            int labelId = this.getLabelId(labelName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForLabelNonLocking(labelId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$8 -> x$8.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public boolean hasRelationshipPropertyTypeConstraint(String relTypeName, String propertyKey, SchemaValueType cypherType) {
        SeqOps seqOps;
        Some some;
        Seq seq;
        Option option = this.getRelationshipPropertiesWithTypeConstraint(relTypeName).get((Object)propertyKey);
        if (option instanceof Some && (seq = (Seq)(some = (Some)option).value()) != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0) {
            SchemaValueType schemaValueType = (SchemaValueType)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
            SchemaValueType schemaValueType2 = cypherType;
            SchemaValueType schemaValueType3 = schemaValueType;
            if (!(schemaValueType2 != null ? !schemaValueType2.equals(schemaValueType3) : schemaValueType3 != null)) {
                return true;
            }
        }
        return false;
    }

    public Map<String, Seq<SchemaValueType>> getRelationshipPropertiesWithTypeConstraint(String relTypeName) {
        Map map;
        try {
            int relTypeId = this.getRelTypeId(relTypeName);
            Iterator constraints = CollectionConverters$.MODULE$.IteratorHasAsScala(this.tc.schemaRead().constraintsGetForRelationshipTypeNonLocking(relTypeId)).asScala();
            Iterator typeConstraints = constraints.filter((Function1 & Serializable)c -> BoxesRunTime.boxToBoolean((boolean)c.enforcesPropertyType())).map((Function1 & Serializable)x$9 -> x$9.asPropertyTypeConstraint());
            map = typeConstraints.map((Function1 & Serializable)typeConstraint -> new Tuple2((Object)$this.tc.tokenRead().propertyKeyName(typeConstraint.schema().getPropertyId()), (Object)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])typeConstraint.propertyType().values())))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        catch (KernelException kernelException) {
            map = Predef$.MODULE$.Map().empty();
        }
        return map;
    }

    public InstrumentedGraphStatistics statistics() {
        return this.statistics;
    }

    public LastCommittedTxIdProvider lastCommittedTxIdProvider() {
        return this.lastCommittedTxIdProvider;
    }

    public ProcedureSignature procedureSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.procedureSignature(this.tc.kernelTransaction(), name, this.cypherVersion);
    }

    public Option<UserFunctionSignature> functionSignature(QualifiedName name) {
        return TransactionBoundPlanContext$.MODULE$.functionSignature(this.tc.kernelTransaction(), name, this.cypherVersion);
    }

    public InternalNotificationLogger notificationLogger() {
        return this.logger;
    }

    public boolean txStateHasChanges() {
        return this.tc.dataRead().transactionStateHasChanges();
    }

    public long procedureSignatureVersion() {
        return this.tc.procedures().signatureVersion();
    }

    public PlanContext withNotificationLogger(InternalNotificationLogger notificationLogger) {
        return new TransactionBoundPlanContext(this.tc, notificationLogger, this.graphStatistics, this.cypherVersion);
    }

    public Enumeration.Value databaseMode() {
        TransactionalContext.DatabaseMode databaseMode = this.tc.kernelTransactionalContext().databaseMode();
        if (TransactionalContext.DatabaseMode.SINGLE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SINGLE();
        }
        if (TransactionalContext.DatabaseMode.COMPOSITE.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.COMPOSITE();
        }
        if (TransactionalContext.DatabaseMode.SHARDED.equals(databaseMode)) {
            return DatabaseMode$.MODULE$.SHARDED();
        }
        throw new MatchError((Object)databaseMode);
    }

    public boolean storageHasPropertyColocation() {
        boolean bl;
        try {
            bl = this.tc.kernelTransaction().storageEngineCostCharacteristics().hasPropertyColocation();
        }
        catch (Neo4jException neo4jException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$1(IndexType it$1, IndexDescriptor x$2) {
        IndexType indexType = x$2.getIndexType();
        IndexType indexType2 = it$1;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForLabel$2(IndexDescriptor x$3) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$1(IndexType it$2, IndexDescriptor x$4) {
        IndexType indexType = x$4.getIndexType();
        IndexType indexType2 = it$2;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$indexesGetForRelType$2(IndexDescriptor x$5) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$indexGetForSchemaDescriptor$1(IndexType indexType$3, IndexDescriptor x$6) {
        IndexType indexType = x$6.getIndexType();
        IndexType indexType2 = indexType$3;
        return !(indexType != null ? !indexType.equals(indexType2) : indexType2 != null);
    }

    public static final /* synthetic */ org.neo4j.cypher.internal.planner.spi.IndexDescriptor $anonfun$getOnlineIndex$2(Product entityType$1, PropertyKeyId[] properties$1, Set behaviours$1, Product orderCapability$1, Product valueCapability$1, IndexDescriptor reference$1, boolean isUnique$1, IndexDescriptor.IndexType indexType) {
        return new org.neo4j.cypher.internal.planner.spi.IndexDescriptor(indexType, (IndexDescriptor.EntityType)entityType$1, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)properties$1), behaviours$1, (IndexOrderCapability)orderCapability$1, (GetValueFromIndexBehavior)valueCapability$1, (Option)new Some((Object)reference$1.getCapability()), isUnique$1);
    }

    public static final /* synthetic */ String $anonfun$getPropertiesFromExistenceConstraints$3(TransactionBoundPlanContext $this, int id) {
        return $this.tc.tokenRead().propertyKeyName(id);
    }

    public TransactionBoundPlanContext(TransactionalContextWrapper tc, InternalNotificationLogger logger, InstrumentedGraphStatistics graphStatistics, CypherVersion cypherVersion) {
        this.tc = tc;
        this.logger = logger;
        this.graphStatistics = graphStatistics;
        this.cypherVersion = cypherVersion;
        super((QueryTransactionalContext)tc);
        IndexDescriptorCompatibility.$init$(this);
        this.statistics = graphStatistics;
        this.lastCommittedTxIdProvider = new LastCommittedTxIdProvider(tc.graph());
    }
}

