/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import org.neo4j.cypher.internal.CypherRuntime;
import org.neo4j.cypher.internal.ExecutionPlan;
import org.neo4j.cypher.internal.ExecutionPlanWithNotifications;
import org.neo4j.cypher.internal.LogicalQuery;
import org.neo4j.cypher.internal.RuntimeContext;
import org.neo4j.cypher.internal.SchemaCommandRuntime$;
import org.neo4j.cypher.internal.UnknownRuntime;
import org.neo4j.cypher.internal.options.CypherRuntimeOption;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.exceptions.RuntimeUnsupportedException;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.notifications.RuntimeUnsupportedNotification;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001B\u0005\u000b\u0001MA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\to\u0001\u0011\t\u0011)A\u0005q!)a\b\u0001C\u0001\u007f!)1\t\u0001C!\t\")Q\n\u0001C!\u001d\")!\u000b\u0001C\u0005'\")\u0011\f\u0001C!5\")a\u0010\u0001C\u0005\u007f\nya)\u00197mE\u0006\u001c7NU;oi&lWM\u0003\u0002\f\u0019\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u000e\u001d\u000511-\u001f9iKJT!a\u0004\t\u0002\u000b9,w\u000e\u000e6\u000b\u0003E\t1a\u001c:h\u0007\u0001)\"\u0001F\u0011\u0014\u0007\u0001)2\u0004\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VM\u001a\t\u00049uyR\"\u0001\u0006\n\u0005yQ!!D\"za\",'OU;oi&lW\r\u0005\u0002!C1\u0001A!\u0002\u0012\u0001\u0005\u0004\u0019#aB\"P\u001dR+\u0005\fV\t\u0003I\u001d\u0002\"AF\u0013\n\u0005\u0019:\"a\u0002(pi\"Lgn\u001a\t\u00039!J!!\u000b\u0006\u0003\u001dI+h\u000e^5nK\u000e{g\u000e^3yi\u0006A!/\u001e8uS6,7\u000fE\u0002-imq!!\f\u001a\u000f\u00059\nT\"A\u0018\u000b\u0005A\u0012\u0012A\u0002\u001fs_>$h(C\u0001\u0019\u0013\t\u0019t#A\u0004qC\u000e\\\u0017mZ3\n\u0005U2$AC%oI\u0016DX\rZ*fc*\u00111gF\u0001\u0011e\u0016\fX/Z:uK\u0012\u0014VO\u001c;j[\u0016\u0004\"!\u000f\u001f\u000e\u0003iR!a\u000f\u0006\u0002\u000f=\u0004H/[8og&\u0011QH\u000f\u0002\u0014\u0007f\u0004\b.\u001a:Sk:$\u0018.\\3PaRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\u000b%\tE\u0002\u001d\u0001}AQAK\u0002A\u0002-BQaN\u0002A\u0002a\nAA\\1nKV\tQ\t\u0005\u0002G\u0015:\u0011q\t\u0013\t\u0003]]I!!S\f\u0002\rA\u0013X\rZ3g\u0013\tYEJ\u0001\u0004TiJLgn\u001a\u0006\u0003\u0013^\t!dY8se\u0016\u001c\bo\u001c8eS:<'+\u001e8uS6,w\n\u001d;j_:,\u0012a\u0014\t\u0004-AC\u0014BA)\u0018\u0005\u0019y\u0005\u000f^5p]\u0006\u0019\u0002/\u001e2mS\u000e\u001c\u0015M\u001c8pi\u000e{W\u000e]5mKR\u0011A\u0005\u0016\u0005\u0006+\u001a\u0001\rAV\u0001\u0012_JLw-\u001b8bY\u0016C8-\u001a9uS>t\u0007C\u0001\u0017X\u0013\tAfGA\u0005Fq\u000e,\u0007\u000f^5p]\u0006\u00192m\\7qS2,Gk\\#yK\u000e,H/\u00192mKR!1LX2f!\taB,\u0003\u0002^\u0015\tiQ\t_3dkRLwN\u001c)mC:DQaX\u0004A\u0002\u0001\fA\u0002\\8hS\u000e\fG.U;fef\u0004\"\u0001H1\n\u0005\tT!\u0001\u0004'pO&\u001c\u0017\r\\)vKJL\b\"\u00023\b\u0001\u0004y\u0012aB2p]R,\u0007\u0010\u001e\u0005\u0006M\u001e\u0001\raZ\u0001\rI\u0006$\u0018MY1tK6{G-\u001a\t\u0003Qnt!!\u001b=\u000f\u0005),hBA6s\u001d\ta\u0007O\u0004\u0002n_:\u0011aF\\\u0005\u0002#%\u0011q\u0002E\u0005\u0003c:\taa[3s]\u0016d\u0017BA:u\u0003\u0011IW\u000e\u001d7\u000b\u0005Et\u0011B\u0001<x\u0003\u0015\tX/\u001a:z\u0015\t\u0019H/\u0003\u0002zu\u0006!BK]1og\u0006\u001cG/[8oC2\u001cuN\u001c;fqRT!A^<\n\u0005ql(\u0001\u0004#bi\u0006\u0014\u0017m]3N_\u0012,'BA={\u0003-\u0011XO\u001c;j[\u0016\u001cuN\u001c4\u0015\u0007\u0015\u000b\t\u0001\u0003\u0004\u0002\u0004!\u0001\raG\u0001\beVtG/[7f\u0001")
public class FallbackRuntime<CONTEXT extends RuntimeContext>
implements CypherRuntime<CONTEXT> {
    private final IndexedSeq<CypherRuntime<CONTEXT>> runtimes;
    private final CypherRuntimeOption requestedRuntime;

    @Override
    public String name() {
        return "fallback";
    }

    @Override
    public Option<CypherRuntimeOption> correspondingRuntimeOption() {
        return this.runtimes.collectFirst((PartialFunction)new Serializable(null){
            private static final long serialVersionUID = 0L;

            public final <A1 extends CypherRuntime<CONTEXT>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1.correspondingRuntimeOption().isDefined()) {
                    return (B1)A1.correspondingRuntimeOption().get();
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(CypherRuntime<CONTEXT> x1) {
                CypherRuntime<CONTEXT> cypherRuntime = x1;
                return cypherRuntime.correspondingRuntimeOption().isDefined();
            }
        });
    }

    private Nothing$ publicCannotCompile(Exception originalException) {
        throw new RuntimeUnsupportedException(originalException.getMessage(), (Throwable)originalException);
    }

    @Override
    public ExecutionPlan compileToExecutable(LogicalQuery logicalQuery, CONTEXT context, TransactionalContext.DatabaseMode databaseMode) {
        RecordingNotificationLogger logger = new RecordingNotificationLogger();
        Tuple2 failedAttempt = null;
        Throwable lastException = null;
        for (int i = 0; i < this.runtimes.length(); ++i) {
            CypherRuntime runtime = (CypherRuntime)this.runtimes.apply(i);
            if (failedAttempt != null) {
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$)) {
                    Tuple2 tuple2 = failedAttempt;
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    CypherRuntime failingRuntime = (CypherRuntime)tuple2._1();
                    String message = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)failingRuntime, (Object)message);
                    CypherRuntime failingRuntime2 = (CypherRuntime)tuple22._1();
                    String message2 = (String)tuple22._2();
                    logger.log((InternalNotification)new RuntimeUnsupportedNotification(this.runtimeConf(failingRuntime2), this.runtimeConf(runtime), message2));
                    failedAttempt = null;
                }
            }
            try {
                ExecutionPlan plan = runtime.compileToExecutable(logicalQuery, context, databaseMode);
                Set notifications = logger.notifications();
                ExecutionPlan notifiedPlan = notifications.isEmpty() ? plan : new ExecutionPlanWithNotifications(plan, (Set<InternalNotification>)notifications);
                return notifiedPlan;
            }
            catch (CantCompileQueryException e) {
                lastException = e;
                CypherRuntime cypherRuntime = runtime;
                SchemaCommandRuntime$ schemaCommandRuntime$ = SchemaCommandRuntime$.MODULE$;
                if (!(cypherRuntime == null ? schemaCommandRuntime$ != null : !cypherRuntime.equals(schemaCommandRuntime$))) continue;
                CypherRuntimeOption cypherRuntimeOption = this.requestedRuntime;
                CypherRuntimeOption.default$ default$2 = CypherRuntimeOption.default$.MODULE$;
                if (!(cypherRuntimeOption == null ? default$2 != null : !cypherRuntimeOption.equals(default$2)) || i >= this.runtimes.length() - 1) continue;
                failedAttempt = new Tuple2((Object)runtime, (Object)e.getMessage());
                continue;
            }
            catch (RuntimeUnsupportedException e) {
                throw e;
            }
            catch (Exception e) {
                lastException = e;
                ((RuntimeContext)context).log().debug("Runtime " + runtime.getClass().getSimpleName() + " failed to compile query " + logicalQuery.queryText(), (Throwable)e);
            }
        }
        Throwable throwable = lastException;
        if (throwable instanceof CantCompileQueryException) {
            CantCompileQueryException cantCompileQueryException = (CantCompileQueryException)throwable;
            throw this.publicCannotCompile((Exception)((Object)cantCompileQueryException));
        }
        throw throwable;
    }

    private String runtimeConf(CypherRuntime<CONTEXT> runtime) {
        CypherRuntime cypherRuntime = runtime;
        if (cypherRuntime instanceof UnknownRuntime) {
            UnknownRuntime unknownRuntime = (UnknownRuntime)cypherRuntime;
            String requestedRuntime = unknownRuntime.requestedRuntime();
            return "runtime=" + requestedRuntime;
        }
        return (String)runtime.correspondingRuntimeOption().map((Function1 & Serializable)x$2 -> x$2.renderExplicit()).getOrElse((Function0 & Serializable)() -> "runtime=" + runtime.name());
    }

    public FallbackRuntime(IndexedSeq<CypherRuntime<CONTEXT>> runtimes, CypherRuntimeOption requestedRuntime) {
        this.runtimes = runtimes;
        this.requestedRuntime = requestedRuntime;
    }
}

