/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal;

import java.io.Serializable;
import java.time.Clock;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.cypher.internal.CachingPreParser;
import org.neo4j.cypher.internal.CompilerWithExpressionCodeGenOption;
import org.neo4j.cypher.internal.ExecutableQuery;
import org.neo4j.cypher.internal.ExecutionEngine$;
import org.neo4j.cypher.internal.FullyParsedQuery;
import org.neo4j.cypher.internal.FunctionWithInformation$;
import org.neo4j.cypher.internal.InputQuery;
import org.neo4j.cypher.internal.MasterCompiler;
import org.neo4j.cypher.internal.PreParsedQuery;
import org.neo4j.cypher.internal.QueryCache;
import org.neo4j.cypher.internal.QueryCache$;
import org.neo4j.cypher.internal.SchemaHelper;
import org.neo4j.cypher.internal.cache.CypherQueryCaches;
import org.neo4j.cypher.internal.config.CypherConfiguration;
import org.neo4j.cypher.internal.expressions.IterablePredicateExpression$;
import org.neo4j.cypher.internal.expressions.functions.Function$;
import org.neo4j.cypher.internal.frontend.phases.BaseState;
import org.neo4j.cypher.internal.options.CypherReplanOption;
import org.neo4j.cypher.internal.runtime.InputDataStream;
import org.neo4j.cypher.internal.runtime.NoInput$;
import org.neo4j.cypher.internal.tracing.CompilationTracer;
import org.neo4j.cypher.internal.util.InternalNotification;
import org.neo4j.cypher.internal.util.InternalNotificationLogger;
import org.neo4j.cypher.internal.util.RecordingNotificationLogger;
import org.neo4j.exceptions.ParameterNotFoundException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.GraphDatabaseQueryService;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.kernel.impl.query.FunctionInformation;
import org.neo4j.kernel.impl.query.QueryExecution;
import org.neo4j.kernel.impl.query.QueryExecutionMonitor;
import org.neo4j.kernel.impl.query.QuerySubscriber;
import org.neo4j.kernel.impl.query.TransactionalContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.values.virtual.MapValue;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r=e!\u0002\u00192\u0003\u0003Q\u0004\u0002C!\u0001\u0005\u000b\u0007I\u0011\u0001\"\t\u0011%\u0003!\u0011!Q\u0001\n\rC\u0001B\u0013\u0001\u0003\u0006\u0004%\ta\u0013\u0005\t%\u0002\u0011\t\u0011)A\u0005\u0019\"A1\u000b\u0001BC\u0002\u0013\u0005A\u000b\u0003\u0005\\\u0001\t\u0005\t\u0015!\u0003V\u0011!a\u0006A!b\u0001\n\u0003i\u0006\u0002C2\u0001\u0005\u0003\u0005\u000b\u0011\u00020\t\u0011\u0011\u0004!Q1A\u0005\u0002\u0015D\u0001B\u001b\u0001\u0003\u0002\u0003\u0006IA\u001a\u0005\tW\u0002\u0011)\u0019!C\u0001Y\"A1\u000f\u0001B\u0001B\u0003%Q\u000e\u0003\u0005u\u0001\t\u0015\r\u0011\"\u0001v\u0011!a\bA!A!\u0002\u00131\b\u0002C?\u0001\u0005\u000b\u0007I\u0011\u0001@\t\u0013\u0005=\u0001A!A!\u0002\u0013y\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\n\u0003O\u0001!\u0019!C\t\u0003SA\u0001\"a\u000f\u0001A\u0003%\u00111\u0006\u0005\n\u0003{\u0001!\u0019!C\u0005\u0003\u007fA\u0001\"a\u0012\u0001A\u0003%\u0011\u0011\t\u0005\n\u0003\u0013\u0002!\u0019!C\u0005\u0003\u0017B\u0001\"!#\u0001A\u0003%\u0011Q\n\u0005\n\u0003\u0017\u0003!\u0019!C\u0005\u0003\u001bC\u0001\"!&\u0001A\u0003%\u0011q\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011%\ti\u000fAI\u0001\n\u0003\ty\u000fC\u0004\u0002\u0018\u0002!\tA!\u0002\t\u000f\t-\u0002\u0001\"\u0001\u0003.!I!\u0011\t\u0001\u0012\u0002\u0013\u0005\u0011q\u001e\u0005\b\u0005\u0007\u0002A\u0011\u0002B#\u0011\u001d\u0011\u0019\t\u0001C\u0005\u0005\u000bCqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003X\u0002!IA!7\t\u000f\t\u001d\b\u0001\"\u0001\u0003j\"9!\u0011\u001f\u0001\u0005\u0002\t%\bb\u0002Bz\u0001\u0011\u0005!\u0011\u001e\u0005\b\u0005k\u0004A\u0011\u0001Bu\u0011\u001d\u00119\u0010\u0001C\u0001\u0005sDqa!\u000e\u0001\t\u0003\u00199\u0004C\u0004\u0004J\u0001!Iaa\u0013\b\u000f\rU\u0014\u0007#\u0001\u0004x\u00191\u0001'\rE\u0001\u0007sBq!!\u0005,\t\u0003\u0019Y\bC\u0005\u0004~-\u0012\r\u0011\"\u0001\u0004\u0000!A1qQ\u0016!\u0002\u0013\u0019\t\tC\u0005\u0004\n.\n\n\u0011\"\u0001\u0004\f\nyQ\t_3dkRLwN\\#oO&tWM\u0003\u00023g\u0005A\u0011N\u001c;fe:\fGN\u0003\u00025k\u000511-\u001f9iKJT!AN\u001c\u0002\u000b9,w\u000e\u000e6\u000b\u0003a\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u001e\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g\u00031\tX/\u001a:z'\u0016\u0014h/[2f+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$6\u0003\u0019YWM\u001d8fY&\u0011\u0001*\u0012\u0002\u001a\u000fJ\f\u0007\u000f\u001b#bi\u0006\u0014\u0017m]3Rk\u0016\u0014\u0018pU3sm&\u001cW-A\u0007rk\u0016\u0014\u0018pU3sm&\u001cW\rI\u0001\u000fW\u0016\u0014h.\u001a7N_:LGo\u001c:t+\u0005a\u0005CA'Q\u001b\u0005q%BA(6\u0003)iwN\\5u_JLgnZ\u0005\u0003#:\u0013\u0001\"T8oSR|'o]\u0001\u0010W\u0016\u0014h.\u001a7N_:LGo\u001c:tA\u00051AO]1dKJ,\u0012!\u0016\t\u0003-fk\u0011a\u0016\u0006\u00031F\nq\u0001\u001e:bG&tw-\u0003\u0002[/\n\t2i\\7qS2\fG/[8o)J\f7-\u001a:\u0002\u000fQ\u0014\u0018mY3sA\u000511m\u001c8gS\u001e,\u0012A\u0018\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u00039FJ!A\u00191\u0003'\rK\b\u000f[3s\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\u000f\r|gNZ5hA\u0005qQ.Y:uKJ\u001cu.\u001c9jY\u0016\u0014X#\u00014\u0011\u0005\u001dDW\"A\u0019\n\u0005%\f$AD'bgR,'oQ8na&dWM]\u0001\u0010[\u0006\u001cH/\u001a:D_6\u0004\u0018\u000e\\3sA\u0005Y\u0011/^3ss\u000e\u000b7\r[3t+\u0005i\u0007C\u00018r\u001b\u0005y'B\u000192\u0003\u0015\u0019\u0017m\u00195f\u0013\t\u0011xNA\tDsBDWM])vKJL8)Y2iKN\fA\"];fef\u001c\u0015m\u00195fg\u0002\n1\u0002\\8h!J|g/\u001b3feV\ta\u000f\u0005\u0002xu6\t\u0001P\u0003\u0002zk\u00059An\\4hS:<\u0017BA>y\u0005MIe\u000e^3s]\u0006dGj\\4Qe>4\u0018\u000eZ3s\u00031awn\u001a)s_ZLG-\u001a:!\u0003\u0015\u0019Gn\\2l+\u0005y\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005i&lWM\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u000b\rcwnY6\u0002\r\rdwnY6!\u0003\u0019a\u0014N\\5u}Q\u0011\u0012QCA\f\u00033\tY\"!\b\u0002 \u0005\u0005\u00121EA\u0013!\t9\u0007\u0001C\u0003B#\u0001\u00071\tC\u0003K#\u0001\u0007A\nC\u0003T#\u0001\u0007Q\u000bC\u0003]#\u0001\u0007a\fC\u0003e#\u0001\u0007a\rC\u0003l#\u0001\u0007Q\u000eC\u0003u#\u0001\u0007a\u000fC\u0004~#A\u0005\t\u0019A@\u00029\u0011,g-Y;miF+XM]=Fq\u0016\u001cW\u000f^5p]6{g.\u001b;peV\u0011\u00111\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\u0015\tX/\u001a:z\u0015\r\t)$R\u0001\u0005S6\u0004H.\u0003\u0003\u0002:\u0005=\"!F)vKJLX\t_3dkRLwN\\'p]&$xN]\u0001\u001eI\u00164\u0017-\u001e7u#V,'/_#yK\u000e,H/[8o\u001b>t\u0017\u000e^8sA\u0005I\u0001O]3QCJ\u001cXM]\u000b\u0003\u0003\u0003\u00022aZA\"\u0013\r\t)%\r\u0002\u0011\u0007\u0006\u001c\u0007.\u001b8h!J,\u0007+\u0019:tKJ\f!\u0002\u001d:f!\u0006\u00148/\u001a:!\u0003)\tX/\u001a:z\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003\u001b\u0002raZA(\u0003'\n\u0019)C\u0002\u0002RE\u0012!\"U;fef\u001c\u0015m\u00195f!\u0019\t)&!\u001d\u0002x9!\u0011qKA7\u001d\u0011\tI&a\u001b\u000f\t\u0005m\u0013\u0011\u000e\b\u0005\u0003;\n9G\u0004\u0003\u0002`\u0005\u0015TBAA1\u0015\r\t\u0019'O\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AN\u001c\n\u0005Q*\u0014B\u0001\u001a4\u0013\r\ty'M\u0001\u000b#V,'/_\"bG\",\u0017\u0002BA:\u0003k\u0012\u0001bQ1dQ\u0016\\U-\u001f\u0006\u0004\u0003_\n\u0004\u0003BA=\u0003\u007fr1aZA>\u0013\r\ti(M\u0001\u000b\u0013:\u0004X\u000f^)vKJL\u0018\u0002BA:\u0003\u0003S1!! 2!\r9\u0017QQ\u0005\u0004\u0003\u000f\u000b$aD#yK\u000e,H/\u00192mKF+XM]=\u0002\u0017E,XM]=DC\u000eDW\rI\u0001\rg\u000eDW-\\1IK2\u0004XM]\u000b\u0003\u0003\u001f\u00032aZAI\u0013\r\t\u0019*\r\u0002\r'\u000eDW-\\1IK2\u0004XM]\u0001\u000eg\u000eDW-\\1IK2\u0004XM\u001d\u0011\u0002\u000f\u0015DXmY;uKR\u0001\u00121TAQ\u0003g\u000b9-!5\u0002\\\u0006}\u0017\u0011\u001e\t\u0005\u0003[\ti*\u0003\u0003\u0002 \u0006=\"AD)vKJLX\t_3dkRLwN\u001c\u0005\b\u0003cQ\u0002\u0019AAR!\u0011\t)+!,\u000f\t\u0005\u001d\u0016\u0011\u0016\t\u0004\u0003?j\u0014bAAV{\u00051\u0001K]3eK\u001aLA!a,\u00022\n11\u000b\u001e:j]\u001eT1!a+>\u0011\u001d\t)L\u0007a\u0001\u0003o\u000ba\u0001]1sC6\u001c\b\u0003BA]\u0003\u0007l!!a/\u000b\t\u0005u\u0016qX\u0001\bm&\u0014H/^1m\u0015\r\t\t-N\u0001\u0007m\u0006dW/Z:\n\t\u0005\u0015\u00171\u0018\u0002\t\u001b\u0006\u0004h+\u00197vK\"9\u0011\u0011\u001a\u000eA\u0002\u0005-\u0017aB2p]R,\u0007\u0010\u001e\t\u0005\u0003[\ti-\u0003\u0003\u0002P\u0006=\"\u0001\u0006+sC:\u001c\u0018m\u0019;j_:\fGnQ8oi\u0016DH\u000fC\u0004\u0002Tj\u0001\r!!6\u0002\u000fA\u0014xNZ5mKB\u0019A(a6\n\u0007\u0005eWHA\u0004C_>dW-\u00198\t\u000f\u0005u'\u00041\u0001\u0002V\u0006Y\u0001O]3Q_B,H.\u0019;f\u0011\u001d\t\tO\u0007a\u0001\u0003G\f!b];cg\u000e\u0014\u0018NY3s!\u0011\ti#!:\n\t\u0005\u001d\u0018q\u0006\u0002\u0010#V,'/_*vEN\u001c'/\u001b2fe\"I\u00111\u001e\u000e\u0011\u0002\u0003\u0007\u00111F\u0001\b[>t\u0017\u000e^8s\u0003E)\u00070Z2vi\u0016$C-\u001a4bk2$HeN\u000b\u0003\u0003cTC!a\u000b\u0002t.\u0012\u0011Q\u001f\t\u0005\u0003o\u0014\t!\u0004\u0002\u0002z*!\u00111`A\u007f\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0000v\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\u0019!!?\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0006\t\u0002\u001c\n\u001d!q\u0002B\t\u0005'\u0011)B!\n\u0003*!9\u0011\u0011\u0007\u000fA\u0002\t%\u0001cA4\u0003\f%\u0019!QB\u0019\u0003!\u0019+H\u000e\\=QCJ\u001cX\rZ)vKJL\bbBA[9\u0001\u0007\u0011q\u0017\u0005\b\u0003\u0013d\u0002\u0019AAf\u0011\u001d\ti\u000e\ba\u0001\u0003+DqAa\u0006\u001d\u0001\u0004\u0011I\"A\u0003j]B,H\u000f\u0005\u0003\u0003\u001c\t\u0005RB\u0001B\u000f\u0015\r\u0011y\"M\u0001\beVtG/[7f\u0013\u0011\u0011\u0019C!\b\u0003\u001f%s\u0007/\u001e;ECR\f7\u000b\u001e:fC6DqAa\n\u001d\u0001\u0004\tY#\u0001\u0007rk\u0016\u0014\u00180T8oSR|'\u000fC\u0004\u0002br\u0001\r!a9\u0002\u001f\u0015DXmY;uKN+(-];fef$\"#a'\u00030\tE\"1\u0007B\u001b\u0005s\u0011YD!\u0010\u0003@!9\u0011\u0011G\u000fA\u0002\u0005\r\u0006bBA[;\u0001\u0007\u0011q\u0017\u0005\b\u0003\u0013l\u0002\u0019AAf\u0011\u001d\u00119$\ba\u0001\u0003+\f\u0001#[:PkR,'/\\8tiF+XM]=\t\u000f\u0005MW\u00041\u0001\u0002V\"9\u0011Q\\\u000fA\u0002\u0005U\u0007bBAq;\u0001\u0007\u00111\u001d\u0005\n\u0003Wl\u0002\u0013!a\u0001\u0003W\t\u0011$\u001a=fGV$XmU;ccV,'/\u001f\u0013eK\u001a\fW\u000f\u001c;%q\u000591\r\\8tS:<W\u0003\u0002B$\u0005\u001f\"bA!\u0013\u0003l\t5D\u0003\u0002B&\u0005C\u0002BA!\u0014\u0003P1\u0001Aa\u0002B)?\t\u0007!1\u000b\u0002\u0002)F!!Q\u000bB.!\ra$qK\u0005\u0004\u00053j$a\u0002(pi\"Lgn\u001a\t\u0004y\tu\u0013b\u0001B0{\t\u0019\u0011I\\=\t\u0011\t\rt\u0004\"a\u0001\u0005K\nAaY8eKB)AHa\u001a\u0003L%\u0019!\u0011N\u001f\u0003\u0011q\u0012\u0017P\\1nKzBq!!3 \u0001\u0004\tY\rC\u0004\u0003p}\u0001\rA!\u001d\u0002\u0015Q\u0014\u0018mY3Fm\u0016tG\u000f\u0005\u0003\u0003t\tud\u0002\u0002B;\u0005srA!a\u0016\u0003x%\u0011\u0001,M\u0005\u0004\u0005w:\u0016!E\"p[BLG.\u0019;j_:$&/Y2fe&!!q\u0010BA\u0005U\tV/\u001a:z\u0007>l\u0007/\u001b7bi&|g.\u0012<f]RT1Aa\u001fX\u0003%!w.\u0012=fGV$X\r\u0006\f\u0002\u001c\n\u001d%q\u0012BI\u0005'\u0013)Ja&\u0003\u001a\nm%Q\u0014BP\u0011\u001d\t\t\u0004\ta\u0001\u0005\u0013\u00032a\u001aBF\u0013\r\u0011i)\r\u0002\u000b\u0013:\u0004X\u000f^)vKJL\bbBA[A\u0001\u0007\u0011q\u0017\u0005\b\u0003\u0013\u0004\u0003\u0019AAf\u0011\u001d\u00119\u0004\ta\u0001\u0003+Dq!!8!\u0001\u0004\t)\u000eC\u0004\u0003\u0018\u0001\u0002\rA!\u0007\t\u000f\t\u001d\u0002\u00051\u0001\u0002,!11\u000b\ta\u0001\u0005cBq!!9!\u0001\u0004\t\u0019\u000fC\u0004\u0003\"\u0002\u0002\rAa)\u0002%9|G/\u001b4jG\u0006$\u0018n\u001c8M_\u001e<WM\u001d\t\u0005\u0005K\u0013Y+\u0004\u0002\u0003(*\u0019!\u0011V\u0019\u0002\tU$\u0018\u000e\\\u0005\u0005\u0005[\u00139K\u0001\u000eJ]R,'O\\1m\u001d>$\u0018NZ5dCRLwN\u001c'pO\u001e,'/A\u0012d_6\u0004\u0018\u000e\\3s/&$\b.\u0012=qe\u0016\u001c8/[8o\u0007>$WmR3o\u001fB$\u0018n\u001c8\u0015\u001d\tM&\u0011\u0018B_\u0005\u007f\u0013\u0019M!2\u0003HB)qM!.\u0002\u0004&\u0019!qW\u0019\u0003G\r{W\u000e]5mKJ<\u0016\u000e\u001e5FqB\u0014Xm]:j_:\u001cu\u000eZ3HK:|\u0005\u000f^5p]\"9!1X\u0011A\u0002\t%\u0015AC5oaV$\u0018+^3ss\"11+\ta\u0001\u0005cBqA!1\"\u0001\u0004\tY-\u0001\u000bue\u0006t7/Y2uS>t\u0017\r\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003k\u000b\u0003\u0019AA\\\u0011\u001d\u0011\t+\ta\u0001\u0005GCqA!3\"\u0001\u0004\u0011Y-A\btKN\u001c\u0018n\u001c8ECR\f'-Y:f!\u0011\u0011iMa5\u000e\u0005\t='b\u0001Bi\u000b\u0006AA-\u0019;bE\u0006\u001cX-\u0003\u0003\u0003V\n='!\u0005#bi\u0006\u0014\u0017m]3SK\u001a,'/\u001a8dK\u0006aq-\u001a;Pe\u000e{W\u000e]5mKRa\u00111\u0011Bn\u0005;\u0014\tOa9\u0003f\"9\u0011\u0011\u001a\u0012A\u0002\u0005-\u0007b\u0002BpE\u0001\u0007!\u0011R\u0001\u0012S:LG/[1m\u0013:\u0004X\u000f^)vKJL\bBB*#\u0001\u0004\u0011\t\bC\u0004\u00026\n\u0002\r!a.\t\u000f\t\u0005&\u00051\u0001\u0003$\u0006\u00012\r\\3beF+XM]=DC\u000eDWm\u001d\u000b\u0003\u0005W\u00042\u0001\u0010Bw\u0013\r\u0011y/\u0010\u0002\u0005\u0019>tw-A\ndY\u0016\f'\u000f\u0015:f!\u0006\u00148/\u001a:DC\u000eDW-A\rdY\u0016\f'/\u0012=fGV$\u0018M\u00197f#V,'/_\"bG\",\u0017aE2mK\u0006\u00148i\\7qS2,'oQ1dQ\u0016\u001c\u0018aD5og\u0016\u0014H/\u00138u_\u000e\u000b7\r[3\u0015\u0019\tm8\u0011AB\u0003\u0007\u001f\u0019\tb!\n\u0011\u0007q\u0012i0C\u0002\u0003\u0000v\u0012A!\u00168ji\"911A\u0014A\u0002\u0005\r\u0016!C9vKJLH+\u001a=u\u0011\u001d\u00199a\na\u0001\u0007\u0013\ta\u0002\u001d:f!\u0006\u00148/\u001a3Rk\u0016\u0014\u0018\u0010E\u0002h\u0007\u0017I1a!\u00042\u00059\u0001&/\u001a)beN,G-U;fefDq!!.(\u0001\u0004\t9\fC\u0004\u0004\u0014\u001d\u0002\ra!\u0006\u0002\u0017A\f'o]3e#V,'/\u001f\t\u0005\u0007/\u0019\t#\u0004\u0002\u0004\u001a)!11DB\u000f\u0003\u0019\u0001\b.Y:fg*\u00191qD\u0019\u0002\u0011\u0019\u0014xN\u001c;f]\u0012LAaa\t\u0004\u001a\tI!)Y:f'R\fG/\u001a\u0005\b\u0007O9\u0003\u0019AB\u0015\u0003Q\u0001\u0018M]:j]\u001etu\u000e^5gS\u000e\fG/[8ogB1\u0011QUB\u0016\u0007_IAa!\f\u00022\n\u00191+\u001a;\u0011\t\t\u00156\u0011G\u0005\u0005\u0007g\u00119K\u0001\u000bJ]R,'O\\1m\u001d>$\u0018NZ5dCRLwN\\\u0001\u0013O\u0016$8)\u001f9iKJ4UO\\2uS>t7/\u0006\u0002\u0004:A111HB \u0007\u0007j!a!\u0010\u000b\t\t%\u0016qA\u0005\u0005\u0007\u0003\u001aiD\u0001\u0003MSN$\b\u0003BA\u0017\u0007\u000bJAaa\u0012\u00020\t\u0019b)\u001e8di&|g.\u00138g_Jl\u0017\r^5p]\u0006y1\r[3dWB\u000b'/Y7fi\u0016\u00148\u000f\u0006\u0005\u0003|\u000e53qKB.\u0011\u001d\u0019y%\u000ba\u0001\u0007#\n1\"];fef\u0004\u0016M]1ngB)Aha\u0015\u0002$&\u00191QK\u001f\u0003\u000b\u0005\u0013(/Y=\t\u000f\re\u0013\u00061\u0001\u00028\u0006Yq-\u001b<f]B\u000b'/Y7t\u0011\u001d\u0019i&\u000ba\u0001\u0003o\u000bq\"\u001a=ue\u0006\u001cG/\u001a3QCJ\fWn\u001d\u0015\u0006S\r\u000541\u000f\t\u0006y\r\r4qM\u0005\u0004\u0007Kj$A\u0002;ie><8\u000f\u0005\u0003\u0004j\r=TBAB6\u0015\r\u0019i'N\u0001\u000bKb\u001cW\r\u001d;j_:\u001c\u0018\u0002BB9\u0007W\u0012!\u0004U1sC6,G/\u001a:O_R4u.\u001e8e\u000bb\u001cW\r\u001d;j_:\u001c#aa\u001a\u0002\u001f\u0015CXmY;uS>tWI\\4j]\u0016\u0004\"aZ\u0016\u0014\u0005-ZDCAB<\u0003M\u0001F*\u0011(`\u0005VKE\nR%O\u000f~#&+S#T+\t\u0019\t\tE\u0002=\u0007\u0007K1a!\">\u0005\rIe\u000e^\u0001\u0015!2\u000bej\u0018\"V\u00132#\u0015JT$`)JKUi\u0015\u0011\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00139+\t\u0019iIK\u0002\u0000\u0003g\u0004")
public abstract class ExecutionEngine {
    private final GraphDatabaseQueryService queryService;
    private final Monitors kernelMonitors;
    private final CompilationTracer tracer;
    private final CypherConfiguration config;
    private final MasterCompiler masterCompiler;
    private final CypherQueryCaches queryCaches;
    private final InternalLogProvider logProvider;
    private final Clock clock;
    private final QueryExecutionMonitor defaultQueryExecutionMonitor;
    private final CachingPreParser preParser;
    private final QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache;
    private final SchemaHelper schemaHelper;

    public static Clock $lessinit$greater$default$8() {
        return ExecutionEngine$.MODULE$.$lessinit$greater$default$8();
    }

    public static int PLAN_BUILDING_TRIES() {
        return ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES();
    }

    public GraphDatabaseQueryService queryService() {
        return this.queryService;
    }

    public Monitors kernelMonitors() {
        return this.kernelMonitors;
    }

    public CompilationTracer tracer() {
        return this.tracer;
    }

    public CypherConfiguration config() {
        return this.config;
    }

    public MasterCompiler masterCompiler() {
        return this.masterCompiler;
    }

    public CypherQueryCaches queryCaches() {
        return this.queryCaches;
    }

    public InternalLogProvider logProvider() {
        return this.logProvider;
    }

    public Clock clock() {
        return this.clock;
    }

    public QueryExecutionMonitor defaultQueryExecutionMonitor() {
        return this.defaultQueryExecutionMonitor;
    }

    private CachingPreParser preParser() {
        return this.preParser;
    }

    private QueryCache<QueryCache.CacheKey<InputQuery.CacheKey>, ExecutableQuery> queryCache() {
        return this.queryCache;
    }

    private SchemaHelper schemaHelper() {
        return this.schemaHelper;
    }

    public QueryExecution execute(String query, MapValue params, TransactionalContext context, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        monitor.startProcessing(context.executingQuery());
        return this.executeSubquery(query, params, context, true, profile, prePopulate, subscriber, monitor);
    }

    public QueryExecution execute(FullyParsedQuery query, MapValue params, TransactionalContext context, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, QuerySubscriber subscriber) {
        queryMonitor.startProcessing(context.executingQuery());
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query.description());
        RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> this.doExecute(query, params, context, true, prePopulate, input, queryMonitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger));
    }

    public QueryExecutionMonitor execute$default$7() {
        return this.defaultQueryExecutionMonitor();
    }

    public QueryExecution executeSubquery(String query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean profile, boolean prePopulate, QuerySubscriber subscriber, QueryExecutionMonitor monitor) {
        CompilationTracer.QueryCompilationEvent queryTracer = this.tracer().compileQuery(query);
        return (QueryExecution)this.closing(context, queryTracer, (Function0 & Serializable)() -> {
            boolean couldContainSensitiveFields = isOutermostQuery && this.masterCompiler().supportsAdministrativeCommands();
            RecordingNotificationLogger notificationLogger = new RecordingNotificationLogger();
            PreParsedQuery preParsedQuery = this.preParser().preParseQuery(query, (InternalNotificationLogger)notificationLogger, profile, couldContainSensitiveFields, TransactionalContext.DatabaseMode.COMPOSITE.equals((Object)context.databaseMode()));
            return this.doExecute(preParsedQuery, params, context, isOutermostQuery, prePopulate, (InputDataStream)NoInput$.MODULE$, monitor, queryTracer, subscriber, (InternalNotificationLogger)notificationLogger);
        });
    }

    public QueryExecutionMonitor executeSubquery$default$8() {
        return this.defaultQueryExecutionMonitor();
    }

    private <T> T closing(TransactionalContext context, CompilationTracer.QueryCompilationEvent traceEvent, Function0<T> code) {
        Object object;
        try {
            try {
                object = code.apply();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof Status.HasStatus) {
                    Throwable throwable3 = throwable2;
                    context.kernelTransaction().markForTermination(((Status.HasStatus)throwable3).status());
                    context.close();
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable4 = throwable2;
                    context.kernelTransaction().markForTermination((Status)Status.Transaction.QueryExecutionFailedOnTransaction);
                    context.close();
                    throw throwable4;
                }
                throw throwable;
            }
        }
        finally {
            traceEvent.close();
        }
        return (T)object;
    }

    private QueryExecution doExecute(InputQuery query, MapValue params, TransactionalContext context, boolean isOutermostQuery, boolean prePopulate, InputDataStream input, QueryExecutionMonitor queryMonitor, CompilationTracer.QueryCompilationEvent tracer, QuerySubscriber subscriber, InternalNotificationLogger notificationLogger) {
        MapValue combinedParams;
        ExecutableQuery executableQuery;
        block11: {
            ExecutableQuery executableQuery2;
            try {
                executableQuery2 = this.getOrCompile(context, query, tracer, params, notificationLogger);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ErrorGqlStatusObject) {
                    Throwable throwable3 = throwable2;
                    if (isOutermostQuery) {
                        Status status;
                        Throwable throwable4 = throwable3;
                        if (throwable4 instanceof Status.HasStatus) {
                            Throwable throwable5 = throwable4;
                            status = ((Status.HasStatus)throwable5).status();
                        } else {
                            status = null;
                        }
                        Status status2 = status;
                        queryMonitor.endFailure(context.executingQuery(), throwable3.getMessage(), status2, (ErrorGqlStatusObject)throwable3);
                    }
                    throw throwable3;
                }
                if (throwable2 != null) {
                    Throwable throwable6 = throwable2;
                    if (isOutermostQuery) {
                        Status status;
                        Throwable throwable7 = throwable6;
                        if (throwable7 instanceof Status.HasStatus) {
                            Throwable throwable8 = throwable7;
                            status = ((Status.HasStatus)throwable8).status();
                        } else {
                            status = null;
                        }
                        Status status3 = status;
                        queryMonitor.endFailure(context.executingQuery(), throwable6.getMessage(), status3, null);
                    }
                    throw throwable6;
                }
                throw throwable;
            }
            executableQuery = executableQuery2;
            String string = query.options().queryOptions().executionMode().name();
            String string2 = "explain";
            if (string == null ? string2 != null : !string.equals(string2)) {
                this.checkParameters(executableQuery.paramNames(), params, executableQuery.extractedParams());
            }
            combinedParams = params.updatedWith(executableQuery.extractedParams());
            if (!isOutermostQuery) break block11;
            context.executingQuery().onObfuscatorReady(executableQuery.queryObfuscator(), query.options().offset().offset());
            context.executingQuery().onCompilationCompleted(executableQuery.compilerInfo(), executableQuery.planDescriptionSupplier(), executableQuery.deprecationNotificationsProvider(query.options().offset()), executableQuery.executionPlanCacheKeyHash());
        }
        return executableQuery.execute(context, isOutermostQuery, query.options(), combinedParams, prePopulate, input, queryMonitor, subscriber);
    }

    private CompilerWithExpressionCodeGenOption<ExecutableQuery> compilerWithExpressionCodeGenOption(InputQuery inputQuery, CompilationTracer.QueryCompilationEvent tracer, TransactionalContext transactionalContext, MapValue params, InternalNotificationLogger notificationLogger, DatabaseReference sessionDatabase) {
        Function0 & Serializable compiledExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery.withRecompilationLimitReached(), tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        Function0 & Serializable interpretedExpressionCompiler = (Function0 & Serializable)() -> this.masterCompiler().compile(inputQuery, tracer, transactionalContext, params, notificationLogger, sessionDatabase);
        return new CompilerWithExpressionCodeGenOption<ExecutableQuery>(this, inputQuery, (Function0)compiledExpressionCompiler, (Function0)interpretedExpressionCompiler){
            private final /* synthetic */ ExecutionEngine $outer;
            private final InputQuery inputQuery$1;
            private final Function0 compiledExpressionCompiler$1;
            private final Function0 interpretedExpressionCompiler$1;

            public ExecutableQuery compile() {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() == 0) {
                    return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
                }
                return (ExecutableQuery)this.interpretedExpressionCompiler$1.apply();
            }

            public ExecutableQuery compileWithExpressionCodeGen() {
                return (ExecutableQuery)this.compiledExpressionCompiler$1.apply();
            }

            public Option<ExecutableQuery> maybeCompileWithExpressionCodeGen(int hitCount, Function0<Object> shouldRecompile) {
                if (this.inputQuery$1.options().compileWhenHot() && this.$outer.config().recompilationLimit() > 0 && hitCount >= this.$outer.config().recompilationLimit() && shouldRecompile.apply$mcZ$sp()) {
                    return new Some(this.compiledExpressionCompiler$1.apply());
                }
                return None$.MODULE$;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.inputQuery$1 = inputQuery$1;
                this.compiledExpressionCompiler$1 = compiledExpressionCompiler$1;
                this.interpretedExpressionCompiler$1 = interpretedExpressionCompiler$1;
            }
        };
    }

    private ExecutableQuery getOrCompile(TransactionalContext context, InputQuery initialInputQuery, CompilationTracer.QueryCompilationEvent tracer, MapValue params, InternalNotificationLogger notificationLogger) {
        block7: {
            ExecutableQuery executableQuery;
            block6: {
                TransactionalContext tc = context.getOrBeginNewIfClosed();
                KernelTransaction.Revertable compilerAuthorization = tc.restrictCurrentTransaction(tc.securityContext().withMode((AccessMode)AccessMode.Static.READ));
                boolean forceReplan = false;
                InputQuery inputQuery = initialInputQuery;
                QueryCache.CacheKey<InputQuery.CacheKey> cacheKey = new QueryCache.CacheKey<InputQuery.CacheKey>(initialInputQuery.cacheKey(), QueryCache$.MODULE$.extractParameterTypeMap(params, this.config().useParameterSizeHint()), tc.kernelTransaction().dataRead().transactionStateHasChanges());
                try {
                    for (int n = 0; n < ExecutionEngine$.MODULE$.PLAN_BUILDING_TRIES(); ++n) {
                        long schemaToken = this.schemaHelper().readSchemaToken(tc);
                        if (forceReplan) {
                            forceReplan = false;
                            inputQuery = inputQuery.withReplanOption((CypherReplanOption)CypherReplanOption.force$.MODULE$);
                        }
                        CompilerWithExpressionCodeGenOption<ExecutableQuery> compiler = this.compilerWithExpressionCodeGenOption(inputQuery, tracer, tc, params, notificationLogger, new DatabaseReference(null, context){
                            private final TransactionalContext context$3;

                            public String name() {
                                return super.name();
                            }

                            public NormalizedDatabaseName alias() {
                                throw new NotImplementedError();
                            }

                            public Optional<NormalizedDatabaseName> namespace() {
                                throw new NotImplementedError();
                            }

                            public boolean isPrimary() {
                                throw new NotImplementedError();
                            }

                            public UUID id() {
                                throw new NotImplementedError();
                            }

                            public String toPrettyString() {
                                throw new NotImplementedError();
                            }

                            public NormalizedDatabaseName fullName() {
                                return new NormalizedDatabaseName(this.context$3.databaseId().name());
                            }

                            public boolean isComposite() {
                                return this.context$3.databaseMode().equals((Object)TransactionalContext.DatabaseMode.COMPOSITE);
                            }

                            public int compareTo(DatabaseReference o) {
                                throw new NotImplementedError();
                            }

                            public String owningDatabaseName() {
                                return this.fullName().name();
                            }

                            public NormalizedCatalogEntry catalogEntry() {
                                throw new NotImplementedError();
                            }
                            {
                                this.context$3 = context$3;
                            }
                        });
                        ExecutableQuery executableQuery2 = this.queryCache().computeIfAbsentOrStale(cacheKey, tc, compiler, inputQuery.options().queryOptions().replan(), context.executingQuery().id());
                        SchemaHelper.LockedEntities lockedEntities = this.schemaHelper().lockEntities(schemaToken, executableQuery2, tc);
                        if (lockedEntities.successful()) {
                            executableQuery = executableQuery2;
                            break block6;
                        }
                        forceReplan = lockedEntities.needsReplan();
                    }
                    break block7;
                }
                finally {
                    compilerAuthorization.close();
                }
            }
            return executableQuery;
        }
        throw new IllegalStateException("Could not compile query due to insanely frequent schema changes");
    }

    public long clearQueryCaches() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.masterCompiler().clearCaches(), this.queryCache().clear(), this.preParser().clearCache()}))).max((Ordering)Ordering.Long$.MODULE$));
    }

    public long clearPreParserCache() {
        return this.preParser().clearCache();
    }

    public long clearExecutableQueryCache() {
        return this.queryCache().clear();
    }

    public long clearCompilerCaches() {
        return this.masterCompiler().clearCaches();
    }

    public void insertIntoCache(String queryText, PreParsedQuery preParsedQuery, MapValue params, BaseState parsedQuery, Set<InternalNotification> parsingNotifications) {
        this.preParser().insertIntoCache(queryText, preParsedQuery);
        this.masterCompiler().insertIntoCache(preParsedQuery, params, parsedQuery, parsingNotifications);
    }

    public java.util.List<FunctionInformation> getCypherFunctions() {
        List informations = Function$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        scala.collection.immutable.Seq predicateInformations = (scala.collection.immutable.Seq)IterablePredicateExpression$.MODULE$.functionInfo().map((Function1)FunctionWithInformation$.MODULE$);
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)informations.$plus$plus((IterableOnce)predicateInformations)).asJava();
    }

    private void checkParameters(String[] queryParams, MapValue givenParams, MapValue extractedParams) throws ParameterNotFoundException {
        for (int i = 0; i < queryParams.length; ++i) {
            String key2 = queryParams[i];
            if (givenParams.containsKey(key2) || extractedParams.containsKey(key2)) continue;
            String[] missingKeys = (String[])ArrayOps$.MODULE$.distinct$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])queryParams), (Function1 & Serializable)key -> BoxesRunTime.boxToBoolean((boolean)ExecutionEngine.$anonfun$checkParameters$1(givenParams, extractedParams, key)))));
            throw new ParameterNotFoundException("Expected parameter(s): " + Predef$.MODULE$.wrapRefArray((Object[])missingKeys).mkString(", "));
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkParameters$1(MapValue givenParams$1, MapValue extractedParams$1, String key) {
        return !givenParams$1.containsKey(key) && !extractedParams$1.containsKey(key);
    }

    public ExecutionEngine(GraphDatabaseQueryService queryService, Monitors kernelMonitors, CompilationTracer tracer, CypherConfiguration config, MasterCompiler masterCompiler, CypherQueryCaches queryCaches, InternalLogProvider logProvider, Clock clock) {
        this.queryService = queryService;
        this.kernelMonitors = kernelMonitors;
        this.tracer = tracer;
        this.config = config;
        this.masterCompiler = masterCompiler;
        this.queryCaches = queryCaches;
        this.logProvider = logProvider;
        this.clock = clock;
        this.defaultQueryExecutionMonitor = (QueryExecutionMonitor)kernelMonitors.newMonitor(QueryExecutionMonitor.class, new String[0]);
        this.preParser = new CachingPreParser(config, queryCaches.preParserCache());
        this.queryCache = queryCaches.executableQueryCache();
        this.schemaHelper = new SchemaHelper(this.queryCache(), masterCompiler);
    }
}

