/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.memory;

import com.sun.jna.Platform;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.util.FeatureToggles;

final class RuntimeInternals {
    static final boolean DEBUG_ESTIMATIONS;
    static final long LONG_CACHE_MIN_VALUE;
    static final long LONG_CACHE_MAX_VALUE;
    static final int HEADER_SIZE;
    static final int OBJECT_ALIGNMENT;
    static final boolean COMPRESSED_OOPS;
    static final VarHandle STRING_VALUE_ARRAY;

    private RuntimeInternals() {
    }

    static int stringBackingArraySize(String s) {
        if (STRING_VALUE_ARRAY != null) {
            byte[] value = STRING_VALUE_ARRAY.get(s);
            return value.length;
        }
        return s.length() << 1;
    }

    private static String getVmOptionString(String key) throws Exception {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        ObjectName mbean = new ObjectName("com.sun.management:type=HotSpotDiagnostic");
        CompositeDataSupport val = (CompositeDataSupport)server.invoke(mbean, "getVMOption", new Object[]{key}, new String[]{"java.lang.String"});
        return val.get("value").toString();
    }

    private static boolean guessCompressedOops() {
        long off1 = UnsafeUtil.getFieldOffset(CompressedOopsClass.class, "obj1");
        long off2 = UnsafeUtil.getFieldOffset(CompressedOopsClass.class, "obj2");
        return Math.abs(off2 - off1) == 4L;
    }

    private static int guessHeaderSize() {
        long off1 = UnsafeUtil.getFieldOffset(HeaderClass.class, "b1");
        return (int)off1;
    }

    static {
        VarHandle stringValueArray;
        long longCacheMaxValue;
        long longCacheMinValue;
        DEBUG_ESTIMATIONS = FeatureToggles.flag(HeapEstimator.class, (String)"DEBUG", (boolean)false);
        HEADER_SIZE = RuntimeInternals.guessHeaderSize();
        if (Platform.is64Bit()) {
            int objectAlignment;
            boolean compressedOops;
            try {
                compressedOops = Boolean.parseBoolean(RuntimeInternals.getVmOptionString("UseCompressedOops"));
                objectAlignment = Integer.parseInt(RuntimeInternals.getVmOptionString("ObjectAlignmentInBytes"));
            }
            catch (Exception e) {
                if (DEBUG_ESTIMATIONS) {
                    System.err.println("HotSpotDiagnostic not available, falling back to guessing. Exception:");
                    e.printStackTrace(System.err);
                }
                compressedOops = RuntimeInternals.guessCompressedOops();
                objectAlignment = 8;
            }
            COMPRESSED_OOPS = compressedOops;
            OBJECT_ALIGNMENT = objectAlignment;
        } else {
            COMPRESSED_OOPS = true;
            OBJECT_ALIGNMENT = 8;
        }
        for (longCacheMinValue = 0L; longCacheMinValue > Long.MIN_VALUE && Long.valueOf(longCacheMinValue - 1L) == Long.valueOf(longCacheMinValue - 1L); --longCacheMinValue) {
        }
        for (longCacheMaxValue = -1L; longCacheMaxValue < Long.MAX_VALUE && Long.valueOf(longCacheMaxValue + 1L) == Long.valueOf(longCacheMaxValue + 1L); ++longCacheMaxValue) {
        }
        LONG_CACHE_MIN_VALUE = longCacheMinValue;
        LONG_CACHE_MAX_VALUE = longCacheMaxValue;
        try {
            stringValueArray = MethodHandles.privateLookupIn(String.class, MethodHandles.lookup()).findVarHandle(String.class, "value", byte[].class);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            stringValueArray = null;
        }
        STRING_VALUE_ARRAY = stringValueArray;
    }

    public static class CompressedOopsClass {
        public Object obj1;
        public Object obj2;
    }

    public static class HeaderClass {
        public boolean b1;
    }
}

